/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.engine;

import com.orientechnologies.orient.core.record.impl.ODocument;
import java.io.IOException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.store.Directory;

public class OLuceneIndexWriterFactory {
    public IndexWriter createIndexWriter(Directory dir, ODocument metadata, Analyzer analyzer) throws IOException {
        IndexWriterConfig config = this.createIndexWriterConfig(metadata, analyzer);
        return new IndexWriter(dir, config);
    }

    public IndexWriterConfig createIndexWriterConfig(ODocument metadata, Analyzer analyzer) {
        IndexWriterConfig config = new IndexWriterConfig(analyzer);
        config.setOpenMode(IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
        if (metadata.containsField("use_compound_file")) {
            config.setUseCompoundFile(((Boolean)metadata.field("use_compound_file")).booleanValue());
        }
        if (metadata.containsField("ram_buffer_MB")) {
            config.setRAMBufferSizeMB(Double.valueOf((String)metadata.field("ram_buffer_MB")).doubleValue());
        }
        if (metadata.containsField("max_buffered_docs")) {
            config.setMaxBufferedDocs(Integer.valueOf((String)metadata.field("max_buffered_docs")).intValue());
        }
        if (metadata.containsField("ram_per_thread_MB")) {
            config.setRAMPerThreadHardLimitMB(Integer.valueOf((String)metadata.field("ram_per_thread_MB")).intValue());
        }
        return config;
    }
}

