/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.engine;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.util.ORawPair;
import com.orientechnologies.lucene.builder.OLuceneDocumentBuilder;
import com.orientechnologies.lucene.builder.OLuceneIndexType;
import com.orientechnologies.lucene.builder.OLuceneQueryBuilder;
import com.orientechnologies.lucene.collections.LuceneIndexTransformer;
import com.orientechnologies.lucene.collections.OLuceneCompositeKey;
import com.orientechnologies.lucene.collections.OLuceneResultSet;
import com.orientechnologies.lucene.engine.OLuceneIndexEngineAbstract;
import com.orientechnologies.lucene.engine.OLuceneIndexEngineUtils;
import com.orientechnologies.lucene.engine.OLuceneIndexWriterFactory;
import com.orientechnologies.lucene.query.OLuceneKeyAndMetadata;
import com.orientechnologies.lucene.query.OLuceneQueryContext;
import com.orientechnologies.lucene.tx.OLuceneTxChanges;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.OContextualRecordId;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.index.OCompositeKey;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexEngineException;
import com.orientechnologies.orient.core.index.OIndexKeyUpdater;
import com.orientechnologies.orient.core.index.engine.OBaseIndexEngine;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.parser.ParseException;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations.OAtomicOperation;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.highlight.TextFragment;
import org.apache.lucene.store.Directory;

public class OLuceneFullTextIndexEngine
extends OLuceneIndexEngineAbstract {
    private final OLuceneDocumentBuilder builder;
    private OLuceneQueryBuilder queryBuilder;
    private final AtomicLong bonsayFileId = new AtomicLong(0L);

    public OLuceneFullTextIndexEngine(OStorage storage, String idxName, int id) {
        super(id, storage, idxName);
        this.builder = new OLuceneDocumentBuilder();
    }

    @Override
    public void init(String indexName, String indexType, OIndexDefinition indexDefinition, boolean isAutomatic, ODocument metadata) {
        super.init(indexName, indexType, indexDefinition, isAutomatic, metadata);
        this.queryBuilder = new OLuceneQueryBuilder(metadata);
    }

    @Override
    public IndexWriter createIndexWriter(Directory directory) throws IOException {
        OLuceneIndexWriterFactory fc = new OLuceneIndexWriterFactory();
        OLogManager.instance().debug((Object)this, "Creating Lucene index in '%s'...", new Object[]{directory});
        return fc.createIndexWriter(directory, this.metadata, this.indexAnalyzer());
    }

    @Override
    public void onRecordAddedToResultSet(final OLuceneQueryContext queryContext, OContextualRecordId recordId, Document ret, final ScoreDoc score) {
        recordId.setContext((Map)new HashMap<String, Object>(){
            {
                Map<String, TextFragment[]> frag = queryContext.getFragments();
                frag.forEach((key, fragments) -> {
                    StringBuilder hlField = new StringBuilder();
                    for (TextFragment fragment : fragments) {
                        if (fragment == null || !(fragment.getScore() > 0.0f)) continue;
                        hlField.append(fragment.toString());
                    }
                    this.put("$" + key + "_hl", hlField.toString());
                });
                this.put("$score", Float.valueOf(score.score));
            }
        });
    }

    public boolean remove(OAtomicOperation atomicOperation, Object key) {
        return this.remove(key);
    }

    public Object get(Object key) {
        return this.getInTx(key, null);
    }

    public void update(OAtomicOperation atomicOperation, Object key, OIndexKeyUpdater<Object> updater) {
        this.put(atomicOperation, key, updater.update(null, this.bonsayFileId).getValue());
    }

    public void put(OAtomicOperation atomicOperation, Object key, Object value) {
        this.updateLastAccess();
        this.openIfClosed();
        Collection container = (Collection)value;
        for (OIdentifiable oIdentifiable : container) {
            Document doc = this.buildDocument(key, oIdentifiable);
            this.addDocument(doc);
        }
    }

    public boolean validatedPut(OAtomicOperation atomicOperation, Object key, ORID value, OBaseIndexEngine.Validator<Object, ORID> validator) {
        throw new UnsupportedOperationException("Validated put is not supported by OLuceneFullTextIndexEngine");
    }

    public Stream<ORawPair<Object, ORID>> iterateEntriesBetween(Object rangeFrom, boolean fromInclusive, Object rangeTo, boolean toInclusive, boolean ascSortOrder, OBaseIndexEngine.ValuesTransformer transformer) {
        return LuceneIndexTransformer.transformToStream((OLuceneResultSet)this.get(rangeFrom), rangeFrom);
    }

    private Set<OIdentifiable> getResults(Query query, OCommandContext context, OLuceneTxChanges changes, ODocument metadata) {
        List<SortField> fields = OLuceneIndexEngineUtils.buildSortFields(metadata);
        IndexSearcher luceneSearcher = this.searcher();
        OLuceneQueryContext queryContext = new OLuceneQueryContext(context, luceneSearcher, query, fields).withChanges(changes);
        return new OLuceneResultSet(this, queryContext, metadata);
    }

    public Stream<ORawPair<Object, ORID>> iterateEntriesMajor(Object fromKey, boolean isInclusive, boolean ascSortOrder, OBaseIndexEngine.ValuesTransformer transformer) {
        return null;
    }

    public Stream<ORawPair<Object, ORID>> iterateEntriesMinor(Object toKey, boolean isInclusive, boolean ascSortOrder, OBaseIndexEngine.ValuesTransformer transformer) {
        return null;
    }

    public boolean hasRangeQuerySupport() {
        return false;
    }

    public void updateUniqueIndexVersion(Object key) {
    }

    public int getUniqueIndexVersion(Object key) {
        return 0;
    }

    @Override
    public Document buildDocument(Object key, OIdentifiable value) {
        if (this.indexDefinition.isAutomatic()) {
            return this.builder.build(this.indexDefinition, key, value, this.collectionFields, this.metadata);
        }
        return OLuceneFullTextIndexEngine.putInManualindex(key, value);
    }

    private static Document putInManualindex(Object key, OIdentifiable oIdentifiable) {
        Document doc = new Document();
        doc.add((IndexableField)OLuceneIndexType.createField("RID", oIdentifiable.getIdentity().toString(), Field.Store.YES));
        if (key instanceof OCompositeKey) {
            List keys = ((OCompositeKey)key).getKeys();
            int k = 0;
            for (Object o : keys) {
                doc.add((IndexableField)OLuceneIndexType.createField("k" + k, o, Field.Store.YES));
                ++k;
            }
        } else if (key instanceof Collection) {
            Collection keys = (Collection)key;
            int k = 0;
            for (Object o : keys) {
                doc.add((IndexableField)OLuceneIndexType.createField("k" + k, o, Field.Store.YES));
                ++k;
            }
        } else {
            doc.add((IndexableField)OLuceneIndexType.createField("k0", key, Field.Store.NO));
        }
        return doc;
    }

    @Override
    public Query buildQuery(Object maybeQuery) {
        try {
            if (maybeQuery instanceof String) {
                return this.queryBuilder.query(this.indexDefinition, maybeQuery, OLuceneQueryBuilder.EMPTY_METADATA, this.queryAnalyzer());
            }
            OLuceneKeyAndMetadata q = (OLuceneKeyAndMetadata)maybeQuery;
            return this.queryBuilder.query(this.indexDefinition, (Object)q.key, q.metadata, this.queryAnalyzer());
        }
        catch (ParseException e) {
            throw OException.wrapException((OException)new OIndexEngineException("Error parsing query"), (Throwable)e);
        }
    }

    @Override
    public Set<OIdentifiable> getInTx(Object key, OLuceneTxChanges changes) {
        this.updateLastAccess();
        this.openIfClosed();
        try {
            if (key instanceof OLuceneKeyAndMetadata) {
                OLuceneKeyAndMetadata q = (OLuceneKeyAndMetadata)key;
                Query query = this.queryBuilder.query(this.indexDefinition, (Object)q.key, q.metadata, this.queryAnalyzer());
                OCommandContext commandContext = q.key.getContext();
                return this.getResults(query, commandContext, changes, q.metadata);
            }
            Query query = this.queryBuilder.query(this.indexDefinition, key, OLuceneQueryBuilder.EMPTY_METADATA, this.queryAnalyzer());
            OCommandContext commandContext = null;
            if (key instanceof OLuceneCompositeKey) {
                commandContext = ((OLuceneCompositeKey)((Object)key)).getContext();
            }
            return this.getResults(query, commandContext, changes, OLuceneQueryBuilder.EMPTY_METADATA);
        }
        catch (ParseException e) {
            throw OException.wrapException((OException)new OIndexEngineException("Error parsing lucene query"), (Throwable)e);
        }
    }
}

