/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.spatial.shape;

import com.orientechnologies.spatial.shape.OShapeFactory;
import com.orientechnologies.spatial.shape.OShapeOperation;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.spatial4j.shape.Shape;
import org.locationtech.spatial4j.shape.ShapeCollection;
import org.locationtech.spatial4j.shape.SpatialRelation;

public class OShapeOperationImpl
implements OShapeOperation {
    private final OShapeFactory factory;

    public OShapeOperationImpl(OShapeFactory oShapeFactory) {
        this.factory = oShapeFactory;
    }

    @Override
    public double distance(Shape s1, Shape s2) {
        Geometry geometry = this.factory.toGeometry(s1);
        Geometry geometry1 = this.factory.toGeometry(s2);
        return geometry.distance(geometry1);
    }

    @Override
    public boolean isWithInDistance(Shape s1, Shape s2, Double dist) {
        Geometry geometry = this.factory.toGeometry(s1);
        Geometry geometry1 = this.factory.toGeometry(s2);
        return geometry.isWithinDistance(geometry1, dist.doubleValue());
    }

    @Override
    public boolean intersect(Shape s1, Shape s2) {
        Geometry geometry = this.factory.toGeometry(s1);
        Geometry geometry1 = this.factory.toGeometry(s2);
        return geometry.intersects(geometry1);
    }

    @Override
    public boolean contains(Shape shape, Shape shape1) {
        if (shape instanceof ShapeCollection || shape1 instanceof ShapeCollection) {
            return shape.relate(shape1).equals((Object)SpatialRelation.CONTAINS);
        }
        Geometry geometry = this.factory.toGeometry(shape);
        Geometry geometry1 = this.factory.toGeometry(shape1);
        return geometry.contains(geometry1);
    }

    @Override
    public boolean within(Shape shape, Shape shape1) {
        if (shape instanceof ShapeCollection || shape1 instanceof ShapeCollection) {
            return shape.relate(shape1).equals((Object)SpatialRelation.WITHIN);
        }
        Geometry geometry = this.factory.toGeometry(shape);
        Geometry geometry1 = this.factory.toGeometry(shape1);
        return geometry.within(geometry1);
    }

    @Override
    public boolean isEquals(Shape shape, Shape shape1) {
        return this.within(shape, shape1) && this.within(shape1, shape);
    }
}

