/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.spatial.shape;

import com.orientechnologies.orient.core.db.ODatabaseInternal;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OSchema;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.spatial.shape.OShapeBuilder;
import com.orientechnologies.spatial.shape.OShapeType;
import java.util.ArrayList;
import java.util.List;
import org.locationtech.spatial4j.shape.Point;

public class OPointShapeBuilder
extends OShapeBuilder<Point> {
    public static String NAME = "OPoint";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public OShapeType getType() {
        return OShapeType.POINT;
    }

    @Override
    public void initClazz(ODatabaseInternal db) {
        OSchema schema = db.getMetadata().getSchema();
        OClass point = schema.createAbstractClass(this.getName(), this.superClass(db));
        OProperty coordinates = point.createProperty("coordinates", OType.EMBEDDEDLIST, OType.DOUBLE);
        coordinates.setMin("2");
        coordinates.setMin("2");
    }

    @Override
    public Point fromDoc(ODocument document) {
        this.validate(document);
        List coordinates = (List)document.field("coordinates");
        Point point = SHAPE_FACTORY.pointXY(((Number)coordinates.get(0)).doubleValue(), ((Number)coordinates.get(1)).doubleValue());
        return point;
    }

    @Override
    public ODocument toDoc(final Point shape) {
        ODocument doc = new ODocument(this.getName());
        doc.field("coordinates", (Object)new ArrayList<Double>(){
            {
                this.add(shape.getX());
                this.add(shape.getY());
            }
        });
        return doc;
    }
}

