/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.spatial.operator;

import com.orientechnologies.lucene.operator.OLuceneOperatorUtil;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexCursor;
import com.orientechnologies.orient.core.index.OIndexCursorCollectionValue;
import com.orientechnologies.orient.core.index.OIndexCursorSingleValue;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.ODocumentSerializer;
import com.orientechnologies.orient.core.sql.OIndexSearchResult;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterCondition;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterItemField;
import com.orientechnologies.orient.core.sql.operator.OIndexReuseType;
import com.orientechnologies.orient.core.sql.operator.OQueryTargetOperator;
import com.orientechnologies.spatial.collections.OSpatialCompositeKey;
import com.orientechnologies.spatial.shape.OShapeFactory;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.locationtech.spatial4j.distance.DistanceUtils;
import org.locationtech.spatial4j.shape.Circle;
import org.locationtech.spatial4j.shape.Point;
import org.locationtech.spatial4j.shape.Shape;
import org.locationtech.spatial4j.shape.SpatialRelation;

public class OLuceneNearOperator
extends OQueryTargetOperator {
    OShapeFactory factory = OShapeFactory.INSTANCE;

    public OLuceneNearOperator() {
        super("NEAR", 5, false);
    }

    public Object evaluateRecord(OIdentifiable iRecord, ODocument iCurrentResult, OSQLFilterCondition iCondition, Object iLeft, Object iRight, OCommandContext iContext, ODocumentSerializer serializer) {
        List left = (List)iLeft;
        double lat = ((Number)left.get(0)).doubleValue();
        double lon = ((Number)left.get(1)).doubleValue();
        Point shape = this.factory.context().makePoint(lon, lat);
        List right = (List)iRight;
        double lat1 = ((Number)right.get(0)).doubleValue();
        double lon1 = ((Number)right.get(1)).doubleValue();
        Point shape1 = this.factory.context().makePoint(lon1, lat1);
        Map map = (Map)right.get(2);
        double distance = 0.0;
        Number n = (Number)map.get("maxDistance");
        if (n != null) {
            distance = n.doubleValue();
        }
        Point p = shape1;
        Circle circle = this.factory.context().makeCircle(p.getX(), p.getY(), DistanceUtils.dist2Degrees((double)distance, (double)6371.0087714));
        double docDistDEG = this.factory.context().getDistCalc().distance(shape, p);
        double docDistInKM = DistanceUtils.degrees2Dist((double)docDistDEG, (double)6378.137);
        iContext.setVariable("distance", (Object)docDistInKM);
        return shape.relate((Shape)circle) == SpatialRelation.WITHIN;
    }

    private Object[] parseParams(OIdentifiable iRecord, OSQLFilterCondition iCondition) {
        ODocument oDocument = (ODocument)iRecord;
        Collection left = (Collection)iCondition.getLeft();
        Collection right = (Collection)iCondition.getRight();
        Object[] params = new Object[left.size() * 2 - 2];
        int i = 0;
        for (Object obj : left) {
            if (!(obj instanceof OSQLFilterItemField)) continue;
            String fName = ((OSQLFilterItemField)obj).getFieldChain().getItemName(0);
            params[i] = oDocument.field(fName);
            ++i;
        }
        for (Object obj : right) {
            if (!(obj instanceof Number)) continue;
            params[i] = (double)((Double)OType.convert(obj, Double.class));
            ++i;
        }
        return params;
    }

    public OIndexCursor executeIndexQuery(OCommandContext iContext, OIndex<?> index, List<Object> keyParams, boolean ascSortOrder) {
        OIndexDefinition definition = index.getDefinition();
        int idxSize = definition.getFields().size();
        int paramsSize = keyParams.size();
        double distance = 0.0;
        Object spatial = iContext.getVariable("spatial");
        if (spatial != null) {
            Map params;
            Object dst;
            if (spatial instanceof Number) {
                distance = (Double)OType.convert((Object)spatial, Double.class);
            } else if (spatial instanceof Map && (dst = (params = (Map)spatial).get("maxDistance")) != null && dst instanceof Number) {
                distance = (Double)OType.convert(dst, Double.class);
            }
        }
        iContext.setVariable("$luceneIndex", (Object)true);
        Object indexResult = index.get((Object)new OSpatialCompositeKey(keyParams).setMaxDistance(distance).setContext(iContext));
        if (indexResult == null || indexResult instanceof OIdentifiable) {
            return new OIndexCursorSingleValue((OIdentifiable)indexResult, (Object)new OSpatialCompositeKey(keyParams));
        }
        return new OIndexCursorCollectionValue((Collection)indexResult, (Object)new OSpatialCompositeKey(keyParams));
    }

    public OIndexReuseType getIndexReuseType(Object iLeft, Object iRight) {
        return OIndexReuseType.INDEX_OPERATOR;
    }

    public ORID getBeginRidRange(Object iLeft, Object iRight) {
        return null;
    }

    public ORID getEndRidRange(Object iLeft, Object iRight) {
        return null;
    }

    public String getSyntax() {
        return "<left> NEAR[(<begin-deep-level> [,<maximum-deep-level> [,<fields>]] )] ( <conditions> )";
    }

    public OIndexSearchResult getOIndexSearchResult(OClass iSchemaClass, OSQLFilterCondition iCondition, List<OIndexSearchResult> iIndexSearchResults, OCommandContext context) {
        return OLuceneOperatorUtil.buildOIndexSearchResult(iSchemaClass, iCondition, iIndexSearchResults, context);
    }

    public Collection<OIdentifiable> filterRecords(ODatabase<?> iRecord, List<String> iTargetClasses, OSQLFilterCondition iCondition, Object iLeft, Object iRight) {
        return null;
    }
}

