/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.spatial.engine;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.lucene.builder.OLuceneIndexType;
import com.orientechnologies.lucene.engine.OLuceneIndexEngineAbstract;
import com.orientechnologies.lucene.engine.OLuceneIndexWriterFactory;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.index.OIndexCursor;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexEngine;
import com.orientechnologies.orient.core.index.OIndexKeyCursor;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.spatial.engine.OLuceneSpatialIndexContainer;
import com.orientechnologies.spatial.factory.OSpatialStrategyFactory;
import com.orientechnologies.spatial.shape.OShapeBuilder;
import com.orientechnologies.spatial.strategy.SpatialQueryBuilder;
import java.io.IOException;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.Query;
import org.apache.lucene.spatial.SpatialStrategy;
import org.apache.lucene.store.Directory;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.shape.Shape;

public abstract class OLuceneSpatialIndexEngineAbstract
extends OLuceneIndexEngineAbstract
implements OLuceneSpatialIndexContainer {
    protected final OShapeBuilder factory;
    protected SpatialContext ctx;
    protected SpatialStrategy strategy;
    protected OSpatialStrategyFactory strategyFactory;
    protected SpatialQueryBuilder queryStrategy;

    public OLuceneSpatialIndexEngineAbstract(OStorage storage, String indexName, OShapeBuilder factory) {
        super(storage, indexName);
        this.ctx = factory.context();
        this.factory = factory;
        this.strategyFactory = new OSpatialStrategyFactory(factory);
        this.queryStrategy = new SpatialQueryBuilder(this, factory);
    }

    @Override
    public void init(String indexName, String indexType, OIndexDefinition indexDefinition, boolean isAutomatic, ODocument metadata) {
        super.init(indexName, indexType, indexDefinition, isAutomatic, metadata);
        this.strategy = this.createSpatialStrategy(indexDefinition, metadata);
    }

    protected abstract SpatialStrategy createSpatialStrategy(OIndexDefinition var1, ODocument var2);

    @Override
    public IndexWriter createIndexWriter(Directory directory) throws IOException {
        OLuceneIndexWriterFactory fc = new OLuceneIndexWriterFactory();
        OLogManager.instance().debug((Object)this, "Creating Lucene index in '%s'...", new Object[]{directory});
        return fc.createIndexWriter(directory, this.metadata, this.indexAnalyzer());
    }

    public boolean contains(Object key) {
        return false;
    }

    public boolean remove(Object key) {
        return false;
    }

    public Object getFirstKey() {
        return null;
    }

    public Object getLastKey() {
        return null;
    }

    public OIndexCursor iterateEntriesBetween(Object rangeFrom, boolean fromInclusive, Object rangeTo, boolean toInclusive, boolean ascSortOrder, OIndexEngine.ValuesTransformer transformer) {
        return null;
    }

    public OIndexCursor iterateEntriesMajor(Object fromKey, boolean isInclusive, boolean ascSortOrder, OIndexEngine.ValuesTransformer transformer) {
        return null;
    }

    public OIndexCursor iterateEntriesMinor(Object toKey, boolean isInclusive, boolean ascSortOrder, OIndexEngine.ValuesTransformer transformer) {
        return null;
    }

    @Override
    public OIndexCursor cursor(OIndexEngine.ValuesTransformer valuesTransformer) {
        return null;
    }

    @Override
    public OIndexKeyCursor keyCursor() {
        return null;
    }

    public boolean hasRangeQuerySupport() {
        return false;
    }

    protected Document newGeoDocument(OIdentifiable oIdentifiable, Shape shape) {
        FieldType ft = new FieldType();
        ft.setIndexOptions(IndexOptions.DOCS);
        ft.setStored(true);
        Document doc = new Document();
        doc.add((IndexableField)OLuceneIndexType.createField("RID", oIdentifiable.getIdentity().toString(), Field.Store.YES));
        for (Field f : this.strategy.createIndexableFields(shape)) {
            doc.add((IndexableField)f);
        }
        doc.add((IndexableField)new StoredField(this.strategy.getFieldName(), this.ctx.toString(shape)));
        return doc;
    }

    @Override
    public Document buildDocument(Object key, OIdentifiable value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Query buildQuery(Object query) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SpatialStrategy strategy() {
        return this.strategy;
    }
}

