/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.analyzer;

import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.DelegatingAnalyzerWrapper;
import org.apache.lucene.analysis.core.KeywordAnalyzer;

public class OLucenePerFieldAnalyzerWrapper
extends DelegatingAnalyzerWrapper {
    private final Analyzer defaultAnalyzer;
    private final Map<String, Analyzer> fieldAnalyzers;

    public OLucenePerFieldAnalyzerWrapper(Analyzer defaultAnalyzer) {
        this(defaultAnalyzer, new HashMap<String, Analyzer>());
    }

    public OLucenePerFieldAnalyzerWrapper(Analyzer defaultAnalyzer, Map<String, Analyzer> fieldAnalyzers) {
        super(PER_FIELD_REUSE_STRATEGY);
        this.defaultAnalyzer = defaultAnalyzer;
        this.fieldAnalyzers = new HashMap<String, Analyzer>();
        this.fieldAnalyzers.putAll(fieldAnalyzers);
        this.fieldAnalyzers.put("RID", (Analyzer)new KeywordAnalyzer());
        this.fieldAnalyzers.put("_CLASS", (Analyzer)new KeywordAnalyzer());
        this.fieldAnalyzers.put("_CLUSTER", (Analyzer)new KeywordAnalyzer());
        this.fieldAnalyzers.put("_JSON", (Analyzer)new KeywordAnalyzer());
    }

    protected Analyzer getWrappedAnalyzer(String fieldName) {
        Analyzer analyzer = this.fieldAnalyzers.get(fieldName);
        return analyzer != null ? analyzer : this.defaultAnalyzer;
    }

    public String toString() {
        return "PerFieldAnalyzerWrapper(" + this.fieldAnalyzers + ", default=" + this.defaultAnalyzer + ")";
    }

    public OLucenePerFieldAnalyzerWrapper add(String field, Analyzer analyzer) {
        this.fieldAnalyzers.put(field, analyzer);
        return this;
    }

    public OLucenePerFieldAnalyzerWrapper add(OLucenePerFieldAnalyzerWrapper analyzer) {
        this.fieldAnalyzers.putAll(analyzer.getAnalyzers());
        return this;
    }

    protected Map<String, Analyzer> getAnalyzers() {
        return this.fieldAnalyzers;
    }

    public OLucenePerFieldAnalyzerWrapper remove(String field) {
        this.fieldAnalyzers.remove(field);
        return this;
    }
}

