/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.graph.sql.functions;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.metadata.schema.OImmutableClass;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentInternal;
import com.orientechnologies.orient.core.sql.functions.OSQLFunctionAbstract;
import com.orientechnologies.orient.graph.gremlin.OGremlinHelper;
import com.tinkerpop.blueprints.impls.orient.OrientBaseGraph;
import com.tinkerpop.blueprints.impls.orient.OrientEdge;
import com.tinkerpop.blueprints.impls.orient.OrientElementIterable;
import com.tinkerpop.blueprints.impls.orient.OrientVertex;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.script.ScriptEngine;

public class OSQLFunctionGremlin
extends OSQLFunctionAbstract {
    public static final String NAME = "gremlin";
    private List<Object> result;

    public OSQLFunctionGremlin() {
        super(NAME, 1, 1);
    }

    public Object execute(Object iThis, final OIdentifiable iCurrentRecord, Object iCurrentResult, Object[] iParams, OCommandContext iContext) {
        ODatabaseDocumentTx db = OGremlinHelper.getGraphDatabase(ODatabaseRecordThreadLocal.INSTANCE.get());
        this.result = new ArrayList<Object>();
        OGremlinHelper.execute(db, (String)iParams[0], null, (Map<Object, Object>)iContext.getVariables(), this.result, new OGremlinHelper.OGremlinCallback(){

            @Override
            public boolean call(ScriptEngine iEngine, OrientBaseGraph iGraph) {
                if (iCurrentRecord == null) {
                    return true;
                }
                ODocument document = (ODocument)iCurrentRecord;
                OImmutableClass clazz = ODocumentInternal.getImmutableSchemaClass((ODocument)document);
                if (clazz != null && clazz.isSubClassOf("E")) {
                    OrientEdge graphElement = (OrientEdge)new OrientElementIterable(iGraph, Arrays.asList(document)).iterator().next();
                    iEngine.getBindings(100).put("current", (Object)graphElement);
                    iEngine.getBindings(100).put("it", (Object)graphElement);
                } else {
                    OrientVertex graphElement = (OrientVertex)new OrientElementIterable(iGraph, Arrays.asList(document)).iterator().next();
                    iEngine.getBindings(100).put("current", (Object)graphElement);
                    iEngine.getBindings(100).put("it", (Object)graphElement);
                }
                return true;
            }
        }, null);
        return this.result;
    }

    public boolean aggregateResults() {
        return false;
    }

    public String getSyntax() {
        return "gremlin(<gremlin-expression>)";
    }

    public boolean filterResult() {
        return true;
    }

    public Object getResult() {
        return this.result;
    }
}

