/*
 * Decompiled with CFR 0.152.
 */
package com.orhanobut.logger;

import android.text.TextUtils;
import android.util.Log;
import com.orhanobut.logger.LogLevel;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class Logger {
    private static final int CHUNK_SIZE = 4000;
    private static final int JSON_INDENT = 4;
    private static final int MAX_METHOD_COUNT = 5;
    private static final Settings settings = new Settings();
    private static final char TOP_LEFT_CORNER = '\u2554';
    private static final char BOTTOM_LEFT_CORNER = '\u255a';
    private static final char MIDDLE_CORNER = '\u255f';
    private static final char HORIZONTAL_DOUBLE_LINE = '\u2551';
    private static final String DOUBLE_DIVIDER = "\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550";
    private static final String SINGLE_DIVIDER = "\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500";
    private static final String TOP_BORDER = "\u2554\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550";
    private static final String BOTTOM_BORDER = "\u255a\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550";
    private static final String MIDDLE_BORDER = "\u255f\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500";
    private static String TAG = "PRETTYLOGGER";

    private Logger() {
    }

    public static Settings init() {
        return settings;
    }

    public static Settings init(String tag) {
        if (tag == null) {
            throw new NullPointerException("tag may not be null");
        }
        if (tag.trim().length() == 0) {
            throw new IllegalStateException("tag may not be empty");
        }
        TAG = tag;
        return settings;
    }

    public static void d(String message) {
        Logger.d(TAG, message);
    }

    public static void d(String tag, String message) {
        Logger.d(tag, message, Logger.settings.methodCount);
    }

    public static void d(String message, int methodCount) {
        Logger.d(TAG, message, methodCount);
    }

    public static void d(String tag, String message, int methodCount) {
        Logger.validateMethodCount(methodCount);
        Logger.log(3, tag, message, methodCount);
    }

    public static void e(String message) {
        Logger.e(TAG, message);
    }

    public static void e(String tag, String message) {
        Logger.e(tag, message, null, Logger.settings.methodCount);
    }

    public static void e(Exception e) {
        Logger.e(TAG, null, e, Logger.settings.methodCount);
    }

    public static void e(String tag, Exception e) {
        Logger.e(tag, null, e, Logger.settings.methodCount);
    }

    public static void e(String message, int methodCount) {
        Logger.validateMethodCount(methodCount);
        Logger.e(message, null, methodCount);
    }

    public static void e(String tag, String message, int methodCount) {
        Logger.validateMethodCount(methodCount);
        Logger.e(tag, message, null, methodCount);
    }

    public static void e(String tag, String message, Exception e) {
        Logger.e(tag, message, e, Logger.settings.methodCount);
    }

    public static void e(String tag, String message, Exception e, int methodCount) {
        Logger.validateMethodCount(methodCount);
        if (e != null && message != null) {
            message = message + " : " + e.toString();
        }
        if (e != null && message == null) {
            message = e.toString();
        }
        if (message == null) {
            message = "No message/exception is set";
        }
        Logger.log(6, tag, message, methodCount);
    }

    public static void w(String message) {
        Logger.w(TAG, message);
    }

    public static void w(String tag, String message) {
        Logger.w(tag, message, Logger.settings.methodCount);
    }

    public static void w(String message, int methodCount) {
        Logger.w(TAG, message, methodCount);
    }

    public static void w(String tag, String message, int methodCount) {
        Logger.validateMethodCount(methodCount);
        Logger.log(5, tag, message, methodCount);
    }

    public static void i(String message) {
        Logger.i(TAG, message);
    }

    public static void i(String tag, String message) {
        Logger.i(tag, message, Logger.settings.methodCount);
    }

    public static void i(String message, int methodCount) {
        Logger.i(TAG, message, methodCount);
    }

    public static void i(String tag, String message, int methodCount) {
        Logger.validateMethodCount(methodCount);
        Logger.log(4, tag, message, methodCount);
    }

    public static void v(String message) {
        Logger.v(TAG, message);
    }

    public static void v(String tag, String message) {
        Logger.v(tag, message, Logger.settings.methodCount);
    }

    public static void v(String message, int methodCount) {
        Logger.v(TAG, message, methodCount);
    }

    public static void v(String tag, String message, int methodCount) {
        Logger.validateMethodCount(methodCount);
        Logger.log(2, tag, message, methodCount);
    }

    public static void wtf(String message) {
        Logger.wtf(TAG, message);
    }

    public static void wtf(String tag, String message) {
        Logger.wtf(tag, message, Logger.settings.methodCount);
    }

    public static void wtf(String message, int methodCount) {
        Logger.wtf(TAG, message, methodCount);
    }

    public static void wtf(String tag, String message, int methodCount) {
        Logger.validateMethodCount(methodCount);
        Logger.log(7, tag, message, methodCount);
    }

    public static void json(String json) {
        Logger.json(TAG, json);
    }

    public static void json(String tag, String json) {
        Logger.json(tag, json, Logger.settings.methodCount);
    }

    public static void json(String json, int methodCount) {
        Logger.json(TAG, json, methodCount);
    }

    public static void json(String tag, String json, int methodCount) {
        Logger.validateMethodCount(methodCount);
        if (TextUtils.isEmpty((CharSequence)json)) {
            Logger.d(tag, "Empty/Null json content", methodCount);
            return;
        }
        try {
            if (json.startsWith("{")) {
                JSONObject jsonObject = new JSONObject(json);
                String message = jsonObject.toString(4);
                Logger.d(tag, message, methodCount);
                return;
            }
            if (json.startsWith("[")) {
                JSONArray jsonArray = new JSONArray(json);
                String message = jsonArray.toString(4);
                Logger.d(tag, message, methodCount);
            }
        }
        catch (JSONException e) {
            Logger.d(tag, e.getCause().getMessage() + "\n" + json, methodCount);
        }
    }

    private static void log(int logType, String tag, String message, int methodCount) {
        if (Logger.settings.logLevel == LogLevel.NONE) {
            return;
        }
        Logger.logTopBorder(logType, tag);
        Logger.logHeaderContent(logType, tag, methodCount);
        byte[] bytes = message.getBytes();
        int length = bytes.length;
        if (length <= 4000) {
            if (methodCount > 0) {
                Logger.logDivider(logType, tag);
            }
            Logger.logContent(logType, tag, message);
            Logger.logBottomBorder(logType, tag);
            return;
        }
        if (methodCount > 0) {
            Logger.logDivider(logType, tag);
        }
        for (int i = 0; i < length; i += 4000) {
            int count = Math.min(length - i, 4000);
            Logger.logContent(logType, tag, new String(bytes, i, count));
        }
        Logger.logBottomBorder(logType, tag);
    }

    private static void logTopBorder(int logType, String tag) {
        Logger.logChunk(logType, tag, TOP_BORDER);
    }

    private static void logHeaderContent(int logType, String tag, int methodCount) {
        StackTraceElement[] trace = Thread.currentThread().getStackTrace();
        if (Logger.settings.showThreadInfo) {
            Logger.logChunk(logType, tag, "\u2551 Thread: " + Thread.currentThread().getName());
            Logger.logDivider(logType, tag);
        }
        String level = "";
        for (int i = methodCount; i > 0; --i) {
            int stackIndex = i + 5;
            StringBuilder builder = new StringBuilder();
            builder.append("\u2551 ").append(level).append(Logger.getSimpleClassName(trace[stackIndex].getClassName())).append(".").append(trace[stackIndex].getMethodName()).append(" ").append(" (").append(trace[stackIndex].getFileName()).append(":").append(trace[stackIndex].getLineNumber()).append(")");
            level = level + "   ";
            Logger.logChunk(logType, tag, builder.toString());
        }
    }

    private static void logBottomBorder(int logType, String tag) {
        Logger.logChunk(logType, tag, BOTTOM_BORDER);
    }

    private static void logDivider(int logType, String tag) {
        Logger.logChunk(logType, tag, MIDDLE_BORDER);
    }

    private static void logContent(int logType, String tag, String chunk) {
        String[] lines;
        for (String line : lines = chunk.split(System.getProperty("line.separator"))) {
            Logger.logChunk(logType, tag, "\u2551 " + line);
        }
    }

    private static void logChunk(int logType, String tag, String chunk) {
        String finalTag = Logger.formatTag(tag);
        switch (logType) {
            case 6: {
                Log.e((String)finalTag, (String)chunk);
                break;
            }
            case 4: {
                Log.i((String)finalTag, (String)chunk);
                break;
            }
            case 2: {
                Log.v((String)finalTag, (String)chunk);
                break;
            }
            case 5: {
                Log.w((String)finalTag, (String)chunk);
                break;
            }
            case 7: {
                Log.wtf((String)finalTag, (String)chunk);
                break;
            }
            default: {
                Log.d((String)finalTag, (String)chunk);
            }
        }
    }

    private static String getSimpleClassName(String name) {
        int lastIndex = name.lastIndexOf(".");
        return name.substring(lastIndex + 1);
    }

    private static void validateMethodCount(int methodCount) {
        if (methodCount < 0 || methodCount > 5) {
            throw new IllegalStateException("methodCount must be > 0 and < 5");
        }
    }

    private static String formatTag(String tag) {
        if (!TextUtils.isEmpty((CharSequence)tag) && !TextUtils.equals((CharSequence)TAG, (CharSequence)tag)) {
            return TAG + "-" + tag;
        }
        return TAG;
    }

    public static class Settings {
        int methodCount = 2;
        boolean showThreadInfo = true;
        LogLevel logLevel = LogLevel.FULL;

        public Settings hideThreadInfo() {
            this.showThreadInfo = false;
            return this;
        }

        public Settings setMethodCount(int methodCount) {
            Logger.validateMethodCount(methodCount);
            this.methodCount = methodCount;
            return this;
        }

        public Settings setLogLevel(LogLevel logLevel) {
            this.logLevel = logLevel;
            return this;
        }
    }
}

