/*
 * Decompiled with CFR 0.152.
 */
package com.orhanobut.dialogplus;

import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.orhanobut.dialogplus.Holder;
import com.orhanobut.dialogplus.R;

public class ViewHolder
implements Holder {
    private static final int INVALID = -1;
    private int backgroundResource;
    private ViewGroup headerContainer;
    private View headerView;
    private ViewGroup footerContainer;
    private View footerView;
    private View.OnKeyListener keyListener;
    private View contentView;
    private int viewResourceId = -1;

    public ViewHolder(int viewResourceId) {
        this.viewResourceId = viewResourceId;
    }

    public ViewHolder(View contentView) {
        this.contentView = contentView;
    }

    @Override
    public void addHeader(View view) {
        if (view == null) {
            return;
        }
        this.headerContainer.addView(view);
        this.headerView = view;
    }

    @Override
    public void addFooter(View view) {
        if (view == null) {
            return;
        }
        this.footerContainer.addView(view);
        this.footerView = view;
    }

    @Override
    public void setBackgroundResource(int colorResource) {
        this.backgroundResource = colorResource;
    }

    @Override
    public View getView(LayoutInflater inflater, ViewGroup parent) {
        View view = inflater.inflate(R.layout.dialog_view, parent, false);
        View outMostView = view.findViewById(R.id.dialogplus_outmost_container);
        outMostView.setBackgroundResource(this.backgroundResource);
        ViewGroup contentContainer = (ViewGroup)view.findViewById(R.id.dialogplus_view_container);
        contentContainer.setOnKeyListener(new View.OnKeyListener(){

            public boolean onKey(View v, int keyCode, KeyEvent event) {
                if (ViewHolder.this.keyListener == null) {
                    throw new NullPointerException("keyListener should not be null");
                }
                return ViewHolder.this.keyListener.onKey(v, keyCode, event);
            }
        });
        this.addContent(inflater, parent, contentContainer);
        this.headerContainer = (ViewGroup)view.findViewById(R.id.dialogplus_header_container);
        this.footerContainer = (ViewGroup)view.findViewById(R.id.dialogplus_footer_container);
        return view;
    }

    private void addContent(LayoutInflater inflater, ViewGroup parent, ViewGroup container) {
        if (this.viewResourceId != -1) {
            this.contentView = inflater.inflate(this.viewResourceId, parent, false);
        } else {
            ViewGroup parentView = (ViewGroup)this.contentView.getParent();
            if (parentView != null) {
                parentView.removeView(this.contentView);
            }
        }
        container.addView(this.contentView);
    }

    @Override
    public void setOnKeyListener(View.OnKeyListener keyListener) {
        this.keyListener = keyListener;
    }

    @Override
    public View getInflatedView() {
        return this.contentView;
    }

    @Override
    public View getHeader() {
        return this.headerView;
    }

    @Override
    public View getFooter() {
        return this.footerView;
    }
}

