/*
 * Decompiled with CFR 0.152.
 */
package com.orctom.mojo.was.utils;

import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import com.orctom.mojo.was.model.WebSphereModel;
import com.orctom.mojo.was.model.WebSphereServiceException;
import java.io.File;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class CommandUtils {
    private static final String TIMESTAMP_FORMAT = "yyyyMMdd-HHmmss-SSS";

    public static String getWorkingDir(String targetFolder, String templateExt) {
        return targetFolder + "/" + "was-maven-plugin" + "/" + templateExt + "/";
    }

    public static File getExecutable(String wasHome, final String name) {
        if (StringUtils.isBlank((String)wasHome)) {
            throw new WebSphereServiceException("WAS_HOME is not set");
        }
        File binDir = new File(wasHome, "bin");
        Object[] candidates = binDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String fileName) {
                return fileName.startsWith(name) && (fileName.endsWith("bat") || fileName.endsWith("sh"));
            }
        });
        if (candidates.length != 1) {
            throw new WebSphereServiceException("Couldn't find " + name + "[.sh|.bat], candidates: " + Arrays.toString(candidates));
        }
        File executable = candidates[0];
        System.out.println(name + " location: " + executable.getAbsolutePath());
        return executable;
    }

    public static File getBuildScript(String task, String template, WebSphereModel model, String workingDir, String ext) throws IOException {
        if (StringUtils.isNotEmpty((String)model.getScript())) {
            if (model.getScript().startsWith("/")) {
                return new File(model.getScript());
            }
            return new File(workingDir, model.getScript());
        }
        DefaultMustacheFactory mf = new DefaultMustacheFactory();
        Mustache mustache = mf.compile(template);
        StringBuilder buildFile = new StringBuilder(50);
        buildFile.append(task);
        if (StringUtils.isNotBlank((String)model.getHost())) {
            buildFile.append("-").append(model.getHost());
        }
        if (StringUtils.isNotBlank((String)model.getApplicationName())) {
            buildFile.append("-").append(model.getApplicationName());
        }
        buildFile.append("-").append(CommandUtils.getTimestampString()).append(".").append(ext);
        File buildScriptFile = new File(workingDir, buildFile.toString());
        buildScriptFile.getParentFile().mkdirs();
        FileWriter writer = new FileWriter(buildScriptFile);
        mustache.execute((Writer)writer, (Object)model.getProperties()).flush();
        return buildScriptFile;
    }

    public static void executeCommand(Commandline commandline, StreamConsumer outConsumer, StreamConsumer errorConsumer, boolean isVerbose) throws CommandLineException {
        if (isVerbose) {
            System.out.println("Executing command:\n" + StringUtils.join((Object[])commandline.getShellCommandline(), (String)" "));
        }
        int returnCode = CommandLineUtils.executeCommandLine((Commandline)commandline, (StreamConsumer)outConsumer, (StreamConsumer)errorConsumer, (int)1800);
        String msg = "Return code: " + returnCode;
        if (returnCode != 0) {
            throw new WebSphereServiceException(msg);
        }
        System.out.println(msg);
    }

    public static String getTimestampString() {
        return new SimpleDateFormat(TIMESTAMP_FORMAT).format(new Date());
    }
}

