/*
 * Decompiled with CFR 0.152.
 */
package com.orctom.mojo.was.service.impl;

import com.orctom.mojo.was.model.WebSphereModel;
import com.orctom.mojo.was.model.WebSphereServiceException;
import com.orctom.mojo.was.service.IWebSphereService;
import com.orctom.mojo.was.utils.CommandUtils;
import java.io.File;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineTimeOutException;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class WebSphereServiceScriptImpl
implements IWebSphereService {
    private WebSphereModel model;
    private String workingDir;
    private static final String TEMPLATE = "jython/websphere.py";
    private static final String TEMPLATE_EXT = "py";

    public WebSphereServiceScriptImpl(WebSphereModel model, String targetDir) {
        System.out.println("Using Jython");
        this.model = model;
        this.workingDir = CommandUtils.getWorkingDir(targetDir, TEMPLATE_EXT);
    }

    @Override
    public void restartServer() {
        this.execute("restartServer");
    }

    public void startServer() {
        this.execute("startServer");
    }

    public void stopServer() {
        this.execute("stopServer");
    }

    @Override
    public void installApplication() {
        this.execute("installApplication");
    }

    @Override
    public void uninstallApplication() {
        this.execute("uninstallApplication");
    }

    @Override
    public void startApplication() {
        this.execute("startApplication");
    }

    @Override
    public void stopApplication() {
        this.execute("stopApplication");
    }

    @Override
    public void deploy() {
        this.execute("deploy");
    }

    private void execute(String task) {
        try {
            File buildScript = CommandUtils.getBuildScript(task, TEMPLATE, this.model, this.workingDir, TEMPLATE_EXT);
            Commandline commandLine = new Commandline();
            commandLine.setExecutable(CommandUtils.getExecutable(this.model.getWasHome(), "wsadmin").getAbsolutePath());
            commandLine.setWorkingDirectory(this.workingDir);
            commandLine.createArg().setLine("-conntype " + this.model.getConnectorType());
            commandLine.createArg().setLine("-host " + this.model.getHost());
            commandLine.createArg().setLine("-port " + this.model.getPort());
            if (StringUtils.isNotBlank((String)this.model.getUser())) {
                commandLine.createArg().setLine("-user " + this.model.getUser());
                if (StringUtils.isNotBlank((String)this.model.getPassword())) {
                    commandLine.createArg().setLine("-password " + this.model.getPassword());
                }
            }
            commandLine.createArg().setLine("-lang jython");
            if (StringUtils.isNotEmpty((String)this.model.getJavaoption())) {
                for (String option : StringUtils.split((String)this.model.getJavaoption())) {
                    commandLine.createArg().setLine("-javaoption");
                    commandLine.createArg().setLine(option);
                }
            }
            commandLine.createArg().setLine("-tracefile " + buildScript + ".trace");
            commandLine.createArg().setLine("-appendtrace true");
            commandLine.createArg().setLine("-f " + buildScript.getAbsolutePath());
            if (StringUtils.isNotEmpty((String)this.model.getScript())) {
                commandLine.createArg().setLine(this.model.getScriptArgs());
            } else {
                commandLine.createArg().setLine("-o " + task);
            }
            StringStreamConsumer outConsumer = new StringStreamConsumer();
            StringStreamConsumer errConsumer = new StringStreamConsumer();
            CommandUtils.executeCommand(commandLine, outConsumer, errConsumer, this.model.isVerbose());
            FileUtils.fileWrite((File)new File(buildScript + ".log"), (String)outConsumer.getOutput());
            String error = errConsumer.getOutput();
            if (StringUtils.isNotEmpty((String)error)) {
                System.err.println(error);
            }
        }
        catch (CommandLineTimeOutException e) {
            throw new WebSphereServiceException("Failed to execute task" + task + "\n\tPlease ensure remote WAS or Deployment Manager is running", e);
        }
        catch (Exception e) {
            throw new WebSphereServiceException("Failed to execute task: " + task, e);
        }
    }

    class StringStreamConsumer
    implements StreamConsumer {
        private String ls = System.getProperty("line.separator");
        private StringBuffer string = new StringBuffer();

        StringStreamConsumer() {
        }

        public void consumeLine(String line) {
            this.string.append(line).append(this.ls);
            System.out.println(line);
        }

        public String getOutput() {
            return this.string.toString();
        }
    }
}

