/*
 * Decompiled with CFR 0.152.
 */
package com.orctom.mojo.was;

import com.orctom.mojo.was.AbstractWASMojo;
import com.orctom.mojo.was.model.WebSphereModel;
import com.orctom.mojo.was.model.WebSphereServiceException;
import com.orctom.mojo.was.service.impl.WebSphereServiceScriptImpl;
import com.orctom.mojo.was.utils.AntTaskUtils;
import java.io.IOException;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.util.ExceptionUtils;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="deploy", defaultPhase=LifecyclePhase.PRE_INTEGRATION_TEST, requiresDirectInvocation=true, threadSafe=true)
public class WASDeployMojo
extends AbstractWASMojo {
    @Parameter
    protected String parallel;

    public void execute() throws MojoExecutionException, MojoFailureException {
        boolean parallelDeploy;
        this.getLog().info((CharSequence)"was-maven-plugin - deploy");
        Set<WebSphereModel> models = this.getWebSphereModels();
        if (null == models || models.isEmpty()) {
            this.getLog().info((CharSequence)"[SKIPPED DEPLOYMENT] empty target server configured, please check your configuration");
            return;
        }
        boolean bl = StringUtils.isEmpty((String)this.parallel) ? models.size() > 1 : (parallelDeploy = Boolean.valueOf(this.parallel).booleanValue());
        if (parallelDeploy) {
            ExecutorService executor = Executors.newFixedThreadPool(models.size());
            for (final WebSphereModel model : models) {
                executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        WASDeployMojo.this.execute(model);
                    }
                });
            }
            executor.shutdown();
            try {
                executor.awaitTermination(20L, TimeUnit.MINUTES);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            for (WebSphereModel model : models) {
                this.execute(model);
            }
        }
    }

    private void execute(WebSphereModel model) {
        this.getLog().info((CharSequence)"============================================================");
        this.getLog().info((CharSequence)("[DEPLOY] " + model.getHost() + " " + model.getApplicationName()));
        this.getLog().info((CharSequence)"============================================================");
        try {
            this.getLog().info((CharSequence)"====================    pre-steps    =======================");
            this.executeAntTasks(model, this.preSteps);
            this.getLog().info((CharSequence)"======================    deploy    ========================");
            new WebSphereServiceScriptImpl(model, this.project.getBuild().getDirectory()).deploy();
            this.getLog().info((CharSequence)"====================    post-steps    ======================");
            this.executeAntTasks(model, this.postSteps);
        }
        catch (RuntimeException e) {
            if (this.failOnError) {
                throw e;
            }
            this.getLog().error((CharSequence)"##############  Exception occurred during deploying to WebSphere  ###############");
            this.getLog().error((CharSequence)ExceptionUtils.getFullStackTrace((Throwable)e));
        }
        catch (Throwable t) {
            if (this.failOnError) {
                throw new WebSphereServiceException(t);
            }
            this.getLog().error((CharSequence)"##############  Exception occurred during deploying to WebSphere  ###############");
            this.getLog().error((CharSequence)ExceptionUtils.getFullStackTrace((Throwable)t));
        }
    }

    private void executeAntTasks(WebSphereModel model, PlexusConfiguration[] targets) throws IOException, MojoExecutionException {
        if (null == targets || 0 == targets.length) {
            this.getLog().info((CharSequence)"Skipped, not configured.");
            return;
        }
        for (PlexusConfiguration target : targets) {
            AntTaskUtils.execute(model, target, this.project, this.projectHelper, this.pluginArtifacts, this.getLog());
        }
    }
}

