/*
 * Decompiled with CFR 0.152.
 */
package com.orctom.mojo.was;

import com.orctom.mojo.was.model.WebSphereModel;
import com.orctom.mojo.was.utils.PropertiesUtils;
import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.util.StringUtils;

public abstract class AbstractWASMojo
extends AbstractMojo {
    @Component
    protected MavenProject project;
    @Component
    protected MavenProjectHelper projectHelper;
    @Parameter(defaultValue="${plugin.artifacts}")
    protected List<Artifact> pluginArtifacts;
    @Parameter(defaultValue="${project.basedir}/was-maven-plugin.properties")
    protected File deploymentsPropertyFile;
    @Parameter(required=true)
    protected String wasHome;
    @Parameter(defaultValue="${project.build.finalName}")
    protected String applicationName;
    @Parameter(defaultValue="localhost")
    protected String host;
    @Parameter
    protected String port;
    @Parameter
    protected String connectorType;
    @Parameter
    protected String cluster;
    @Parameter
    protected String cell;
    @Parameter
    protected String node;
    @Parameter
    protected String server;
    @Parameter
    protected String virtualHost;
    @Parameter
    protected String user;
    @Parameter
    protected String password;
    @Parameter
    protected String contextRoot;
    @Parameter
    protected String sharedLibs;
    @Parameter
    protected boolean parentLast;
    @Parameter
    protected boolean webModuleParentLast;
    @Parameter(defaultValue="${project.artifact.file}")
    protected File packageFile;
    @Parameter(defaultValue="false")
    protected boolean failOnError;
    @Parameter
    protected String script;
    @Parameter
    protected String scriptArgs;
    @Parameter
    protected String javaoption;
    @Parameter
    protected boolean verbose;
    @Parameter
    protected PlexusConfiguration[] preSteps;
    @Parameter
    protected PlexusConfiguration[] postSteps;

    protected Set<WebSphereModel> getWebSphereModels() {
        String deployTargets = System.getProperty("deploy_targets");
        if (StringUtils.isNotBlank((String)deployTargets)) {
            if (null != this.deploymentsPropertyFile && this.deploymentsPropertyFile.exists()) {
                this.project.getBasedir();
                Map<String, Properties> propertiesMap = PropertiesUtils.loadSectionedProperties(this.deploymentsPropertyFile, this.getProjectProperties());
                if (propertiesMap.size() >= 1) {
                    this.getLog().info((CharSequence)("Multi targets: " + deployTargets));
                    return this.getWebSphereModels(deployTargets, propertiesMap);
                }
            }
            if (null == this.deploymentsPropertyFile) {
                this.getLog().info((CharSequence)("Property config file: " + this.deploymentsPropertyFile + " not configured."));
            }
            if (!this.deploymentsPropertyFile.exists()) {
                this.getLog().info((CharSequence)("Property config file: " + this.deploymentsPropertyFile + " doesn't exist."));
            }
            this.getLog().info((CharSequence)"Single target not properly configured.");
            return null;
        }
        WebSphereModel model = this.getWebSphereModel();
        if (!model.isValid()) {
            this.getLog().info((CharSequence)"Single target not properly configured. Missing 'cell' or 'cluster' or 'server' or 'node'");
            return null;
        }
        this.getLog().info((CharSequence)("Single target: " + model.getHost()));
        HashSet<WebSphereModel> models = new HashSet<WebSphereModel>(1);
        models.add(model);
        return models;
    }

    protected WebSphereModel getWebSphereModel() {
        WebSphereModel model = new WebSphereModel().setWasHome(this.wasHome).setApplicationName(this.applicationName).setHost(this.host).setPort(this.port).setConnectorType(this.connectorType).setCluster(this.cluster).setCell(this.cell).setNode(this.node).setServer(this.server).setVirtualHost(this.virtualHost).setContextRoot(this.contextRoot).setSharedLibs(this.sharedLibs).setParentLast(this.parentLast).setWebModuleParentLast(this.webModuleParentLast).setUser(this.user).setPassword(this.password).setPackageFile(this.packageFile.getAbsolutePath()).setScript(this.script).setScriptArgs(this.scriptArgs).setJavaoption(this.javaoption).setFailOnError(this.failOnError).setVerbose(this.verbose);
        model.setProperties(this.getProjectProperties());
        return model;
    }

    protected Set<WebSphereModel> getWebSphereModels(String deployTargetStr, Map<String, Properties> propertiesMap) {
        HashSet deployTargets = new HashSet();
        Collections.addAll(deployTargets, StringUtils.split((String)deployTargetStr, (String)","));
        HashSet<WebSphereModel> models = new HashSet<WebSphereModel>();
        for (String deployTarget : deployTargets) {
            Properties props = propertiesMap.get(deployTarget);
            if (null == props || props.isEmpty()) {
                this.getLog().info((CharSequence)("[SKIPPED] " + deployTarget + ", not configured in property file."));
                continue;
            }
            this.updateApplicationNameWithSuffix(props);
            WebSphereModel model = new WebSphereModel().setWasHome(this.wasHome).setApplicationName(this.getPropertyValue("applicationName", props)).setHost(this.getPropertyValue("host", props)).setPort(this.getPropertyValue("port", props)).setConnectorType(this.getPropertyValue("connectorType", props)).setCluster(this.getPropertyValue("cluster", props)).setCell(this.getPropertyValue("cell", props)).setNode(this.getPropertyValue("node", props)).setServer(this.getPropertyValue("server", props)).setVirtualHost(this.getPropertyValue("virtualHost", props)).setContextRoot(this.getPropertyValue("contextRoot", props)).setSharedLibs(this.getPropertyValue("sharedLibs", props)).setParentLast(Boolean.valueOf(this.getPropertyValue("parentLast", props))).setWebModuleParentLast(Boolean.valueOf(this.getPropertyValue("webModuleParentLast", props))).setUser(this.getPropertyValue("user", props)).setPassword(this.getPropertyValue("password", props)).setPackageFile(this.packageFile.getAbsolutePath()).setScript(this.script).setScriptArgs(this.scriptArgs).setJavaoption(this.javaoption).setFailOnError(this.failOnError).setVerbose(this.verbose);
            model.setProperties(props);
            if (!model.isValid()) continue;
            models.add(model);
        }
        return models;
    }

    private void updateApplicationNameWithSuffix(Properties props) {
        String appNameSuffix = this.getPropertyValue("applicationNameSuffix", props);
        if (StringUtils.isNotEmpty((String)appNameSuffix)) {
            String appName = this.getPropertyValue("applicationName", props);
            props.setProperty("applicationName", appName + "_" + appNameSuffix);
        }
    }

    protected String getPropertyValue(String propertyName, Properties props) {
        String value = props.getProperty(propertyName);
        if (this.isValueNotResolved(value)) {
            value = PropertiesUtils.resolve(value, props);
            props.setProperty(propertyName, value);
        }
        return value;
    }

    private boolean isValueNotResolved(String value) {
        return StringUtils.isNotEmpty((String)value) && value.contains("{{") && value.contains("}}");
    }

    private Properties getProjectProperties() {
        Properties properties = new Properties(this.project.getProperties());
        this.setProperty(properties, "applicationName", this.applicationName);
        this.setProperty(properties, "host", this.host);
        this.setProperty(properties, "port", this.port);
        this.setProperty(properties, "connectorType", this.connectorType);
        this.setProperty(properties, "cluster", this.cluster);
        this.setProperty(properties, "cell", this.cell);
        this.setProperty(properties, "node", this.node);
        this.setProperty(properties, "server", this.server);
        this.setProperty(properties, "virtualHost", this.virtualHost);
        this.setProperty(properties, "user", this.user);
        this.setProperty(properties, "password", this.password);
        this.setProperty(properties, "contextRoot", this.contextRoot);
        this.setProperty(properties, "sharedLibs", this.sharedLibs);
        this.setProperty(properties, "parentLast", String.valueOf(this.parentLast));
        this.setProperty(properties, "webModuleParentLast", String.valueOf(this.webModuleParentLast));
        this.setProperty(properties, "packageFile", this.packageFile.getAbsolutePath());
        this.setProperty(properties, "javaoption", this.javaoption);
        this.setProperty(properties, "failOnError", String.valueOf(this.failOnError));
        this.setProperty(properties, "script", this.script);
        this.setProperty(properties, "scriptArgs", this.scriptArgs);
        this.setProperty(properties, "verbose", String.valueOf(this.verbose));
        properties.setProperty("basedir", this.project.getBasedir().getAbsolutePath());
        properties.setProperty("project.basedir", this.project.getBasedir().getAbsolutePath());
        properties.setProperty("version", this.project.getVersion());
        properties.setProperty("project.version", this.project.getVersion());
        properties.setProperty("project.build.directory", this.project.getBuild().getDirectory());
        properties.setProperty("project.build.outputDirectory", this.project.getBuild().getOutputDirectory());
        properties.setProperty("project.build.finalName", this.project.getBuild().getFinalName());
        properties.setProperty("project.name", this.project.getName());
        properties.setProperty("groupId", this.project.getGroupId());
        properties.setProperty("project.groupId", this.project.getGroupId());
        properties.setProperty("artifactId", this.project.getArtifactId());
        properties.setProperty("project.artifactId", this.project.getArtifactId());
        return properties;
    }

    private void setProperty(Properties properties, String key, String value) {
        if (StringUtils.isNotEmpty((String)value)) {
            properties.setProperty(key, value);
        }
    }
}

