/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.option;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.orbitz.consul.option.ConsistencyMode;
import com.orbitz.consul.option.ImmutableQueryOptions;
import com.orbitz.consul.option.Options;
import com.orbitz.consul.option.ParamAdder;
import java.math.BigInteger;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.immutables.value.Value;

@Value.Immutable
public abstract class QueryOptions
implements ParamAdder {
    public static final QueryOptions BLANK = ImmutableQueryOptions.builder().build();

    public abstract Optional<String> getWait();

    public abstract Optional<String> getToken();

    public abstract Optional<String> getHash();

    public abstract Optional<BigInteger> getIndex();

    public abstract Optional<String> getNear();

    public abstract Optional<String> getDatacenter();

    public abstract Optional<String> getFilter();

    public abstract Optional<String> getNamespace();

    public abstract List<String> getNodeMeta();

    public abstract List<String> getTag();

    @Value.Default
    public ConsistencyMode getConsistencyMode() {
        return ConsistencyMode.DEFAULT;
    }

    @Value.Derived
    public boolean isBlocking() {
        return this.getWait().isPresent();
    }

    @Value.Derived
    public boolean hasToken() {
        return this.getToken().isPresent();
    }

    @Value.Derived
    public List<String> getNodeMetaQuery() {
        return this.getNodeMeta() == null ? Collections.emptyList() : ImmutableList.copyOf(this.getNodeMeta());
    }

    @Value.Derived
    public List<String> getTagsQuery() {
        return this.getTag() == null ? Collections.emptyList() : ImmutableList.copyOf(this.getTag());
    }

    @Value.Check
    void validate() {
        if (this.isBlocking()) {
            Preconditions.checkArgument((this.getIndex().isPresent() || this.getHash().isPresent() ? 1 : 0) != 0, (Object)"If wait is specified, index/hash must also be specified");
            Preconditions.checkArgument((!this.getIndex().isPresent() || !this.getHash().isPresent() ? 1 : 0) != 0, (Object)"Cannot specify index and hash ath the same time");
        }
    }

    public static ImmutableQueryOptions.Builder blockSeconds(int seconds, BigInteger index) {
        return QueryOptions.blockBuilder("s", seconds, index);
    }

    public static ImmutableQueryOptions.Builder blockMinutes(int minutes, BigInteger index) {
        return QueryOptions.blockBuilder("m", minutes, index);
    }

    private static ImmutableQueryOptions.Builder blockBuilder(String identifier, int qty, BigInteger index) {
        return ImmutableQueryOptions.builder().wait(String.format("%s%s", qty, identifier)).index(index);
    }

    public static ImmutableQueryOptions.Builder blockSeconds(int seconds, String hash) {
        return QueryOptions.blockBuilder("s", seconds, hash);
    }

    public static ImmutableQueryOptions.Builder blockMinutes(int minutes, String hash) {
        return QueryOptions.blockBuilder("m", minutes, hash);
    }

    private static ImmutableQueryOptions.Builder blockBuilder(String identifier, int qty, String hash) {
        return ImmutableQueryOptions.builder().wait(String.format("%s%s", qty, identifier)).hash(hash);
    }

    @Override
    public Map<String, Object> toQuery() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Optional<String> consistency = this.getConsistencyMode().toParam();
        if (consistency.isPresent()) {
            result.put(consistency.get(), "");
        }
        if (this.isBlocking()) {
            Options.optionallyAdd(result, "wait", this.getWait());
            Options.optionallyAdd(result, "index", this.getIndex());
            Options.optionallyAdd(result, "hash", this.getHash());
        }
        Options.optionallyAdd(result, "token", this.getToken());
        Options.optionallyAdd(result, "near", this.getNear());
        Options.optionallyAdd(result, "dc", this.getDatacenter());
        Options.optionallyAdd(result, "filter", this.getFilter());
        Options.optionallyAdd(result, "ns", this.getNamespace());
        return result;
    }

    @Override
    public Map<String, String> toHeaders() {
        return this.getConsistencyMode().getAdditionalHeaders();
    }
}

