/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.model.health;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.orbitz.consul.model.catalog.ServiceWeights;
import com.orbitz.consul.model.health.Service;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@JsonIgnoreProperties(ignoreUnknown=true)
@Immutable
public final class ImmutableService
extends Service {
    private final String id;
    private final String service;
    @Nullable
    private final Boolean enableTagOverride;
    private final ImmutableList<String> tags;
    private final String address;
    private final ImmutableMap<String, String> meta;
    private final int port;
    @Nullable
    private final ServiceWeights weights;

    private ImmutableService(String id, String service, @Nullable Boolean enableTagOverride, ImmutableList<String> tags, String address, ImmutableMap<String, String> meta, int port, @Nullable ServiceWeights weights) {
        this.id = id;
        this.service = service;
        this.enableTagOverride = enableTagOverride;
        this.tags = tags;
        this.address = address;
        this.meta = meta;
        this.port = port;
        this.weights = weights;
    }

    @Override
    @JsonProperty(value="ID")
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="Service")
    public String getService() {
        return this.service;
    }

    @Override
    @JsonProperty(value="EnableTagOverride")
    public Optional<Boolean> getEnableTagOverride() {
        return Optional.ofNullable(this.enableTagOverride);
    }

    @JsonProperty(value="Tags")
    @JsonDeserialize(as=ImmutableList.class, contentAs=String.class)
    public ImmutableList<String> getTags() {
        return this.tags;
    }

    @Override
    @JsonProperty(value="Address")
    public String getAddress() {
        return this.address;
    }

    @JsonProperty(value="Meta")
    public ImmutableMap<String, String> getMeta() {
        return this.meta;
    }

    @Override
    @JsonProperty(value="Port")
    public int getPort() {
        return this.port;
    }

    @Override
    @JsonProperty(value="Weights")
    public Optional<ServiceWeights> getWeights() {
        return Optional.ofNullable(this.weights);
    }

    public final ImmutableService withId(String value) {
        if (this.id.equals(value)) {
            return this;
        }
        return new ImmutableService((String)Preconditions.checkNotNull((Object)value, (Object)"id"), this.service, this.enableTagOverride, this.tags, this.address, this.meta, this.port, this.weights);
    }

    public final ImmutableService withService(String value) {
        if (this.service.equals(value)) {
            return this;
        }
        return new ImmutableService(this.id, (String)Preconditions.checkNotNull((Object)value, (Object)"service"), this.enableTagOverride, this.tags, this.address, this.meta, this.port, this.weights);
    }

    public final ImmutableService withEnableTagOverride(boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.enableTagOverride, newValue)) {
            return this;
        }
        return new ImmutableService(this.id, this.service, newValue, this.tags, this.address, this.meta, this.port, this.weights);
    }

    public final ImmutableService withEnableTagOverride(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.enableTagOverride, value)) {
            return this;
        }
        return new ImmutableService(this.id, this.service, value, this.tags, this.address, this.meta, this.port, this.weights);
    }

    public final ImmutableService withTags(String ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableService(this.id, this.service, this.enableTagOverride, (ImmutableList<String>)newValue, this.address, this.meta, this.port, this.weights);
    }

    public final ImmutableService withTags(Iterable<String> elements) {
        if (this.tags == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableService(this.id, this.service, this.enableTagOverride, (ImmutableList<String>)newValue, this.address, this.meta, this.port, this.weights);
    }

    public final ImmutableService withAddress(String value) {
        if (this.address.equals(value)) {
            return this;
        }
        return new ImmutableService(this.id, this.service, this.enableTagOverride, this.tags, (String)Preconditions.checkNotNull((Object)value, (Object)"address"), this.meta, this.port, this.weights);
    }

    public final ImmutableService withMeta(Map<String, ? extends String> entries) {
        if (this.meta == entries) {
            return this;
        }
        ImmutableMap value = ImmutableMap.copyOf(entries);
        return new ImmutableService(this.id, this.service, this.enableTagOverride, this.tags, this.address, (ImmutableMap<String, String>)value, this.port, this.weights);
    }

    public final ImmutableService withPort(int value) {
        if (this.port == value) {
            return this;
        }
        return new ImmutableService(this.id, this.service, this.enableTagOverride, this.tags, this.address, this.meta, value, this.weights);
    }

    public final ImmutableService withWeights(ServiceWeights value) {
        ServiceWeights newValue = (ServiceWeights)Preconditions.checkNotNull((Object)value, (Object)"weights");
        if (this.weights == newValue) {
            return this;
        }
        return new ImmutableService(this.id, this.service, this.enableTagOverride, this.tags, this.address, this.meta, this.port, newValue);
    }

    public final ImmutableService withWeights(Optional<ServiceWeights> optional) {
        ServiceWeights value = optional.orElse(null);
        if (this.weights == value) {
            return this;
        }
        return new ImmutableService(this.id, this.service, this.enableTagOverride, this.tags, this.address, this.meta, this.port, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableService && this.equalTo((ImmutableService)another);
    }

    private boolean equalTo(ImmutableService another) {
        return this.id.equals(another.id) && this.service.equals(another.service) && Objects.equals(this.enableTagOverride, another.enableTagOverride) && this.tags.equals(another.tags) && this.address.equals(another.address) && this.meta.equals(another.meta) && this.port == another.port && Objects.equals(this.weights, another.weights);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.id.hashCode();
        h = h * 17 + this.service.hashCode();
        h = h * 17 + com.google.common.base.Objects.hashCode((Object[])new Object[]{this.enableTagOverride});
        h = h * 17 + this.tags.hashCode();
        h = h * 17 + this.address.hashCode();
        h = h * 17 + this.meta.hashCode();
        h = h * 17 + this.port;
        h = h * 17 + com.google.common.base.Objects.hashCode((Object[])new Object[]{this.weights});
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Service").omitNullValues().add("id", (Object)this.id).add("service", (Object)this.service).add("enableTagOverride", (Object)this.enableTagOverride).add("tags", this.tags).add("address", (Object)this.address).add("meta", this.meta).add("port", this.port).add("weights", (Object)this.weights).toString();
    }

    @Deprecated
    @JsonCreator
    static ImmutableService fromJson(Json json) {
        Builder builder = ImmutableService.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.service != null) {
            builder.service(json.service);
        }
        if (json.enableTagOverride != null) {
            builder.enableTagOverride(json.enableTagOverride);
        }
        if (json.tags != null) {
            builder.addAllTags(json.tags);
        }
        if (json.address != null) {
            builder.address(json.address);
        }
        if (json.meta != null) {
            builder.putAllMeta(json.meta);
        }
        if (json.port != null) {
            builder.port(json.port);
        }
        if (json.weights != null) {
            builder.weights(json.weights);
        }
        return builder.build();
    }

    public static ImmutableService copyOf(Service instance) {
        if (instance instanceof ImmutableService) {
            return (ImmutableService)instance;
        }
        return ImmutableService.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_SERVICE = 2L;
        private static final long INIT_BIT_ADDRESS = 4L;
        private static final long INIT_BIT_PORT = 8L;
        private long initBits = 15L;
        @Nullable
        private String id;
        @Nullable
        private String service;
        @Nullable
        private Boolean enableTagOverride;
        private ImmutableList.Builder<String> tagsBuilder = ImmutableList.builder();
        @Nullable
        private String address;
        private ImmutableMap.Builder<String, String> metaBuilder = ImmutableMap.builder();
        private int port;
        @Nullable
        private ServiceWeights weights;

        private Builder() {
        }

        public final Builder from(Service instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.id(instance.getId());
            this.service(instance.getService());
            Optional<Boolean> enableTagOverrideOptional = instance.getEnableTagOverride();
            if (enableTagOverrideOptional.isPresent()) {
                this.enableTagOverride(enableTagOverrideOptional);
            }
            this.addAllTags(instance.getTags());
            this.address(instance.getAddress());
            this.putAllMeta(instance.getMeta());
            this.port(instance.getPort());
            Optional<ServiceWeights> weightsOptional = instance.getWeights();
            if (weightsOptional.isPresent()) {
                this.weights(weightsOptional);
            }
            return this;
        }

        public final Builder id(String id) {
            this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder service(String service) {
            this.service = (String)Preconditions.checkNotNull((Object)service, (Object)"service");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder enableTagOverride(boolean enableTagOverride) {
            this.enableTagOverride = enableTagOverride;
            return this;
        }

        public final Builder enableTagOverride(Optional<Boolean> enableTagOverride) {
            this.enableTagOverride = enableTagOverride.orElse(null);
            return this;
        }

        public final Builder addTags(String element) {
            this.tagsBuilder.add((Object)element);
            return this;
        }

        public final Builder addTags(String ... elements) {
            this.tagsBuilder.add((Object[])elements);
            return this;
        }

        public final Builder tags(Iterable<String> elements) {
            this.tagsBuilder = ImmutableList.builder();
            return this.addAllTags(elements);
        }

        public final Builder addAllTags(Iterable<String> elements) {
            this.tagsBuilder.addAll(elements);
            return this;
        }

        public final Builder address(String address) {
            this.address = (String)Preconditions.checkNotNull((Object)address, (Object)"address");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder putMeta(String key, String value) {
            this.metaBuilder.put((Object)key, (Object)value);
            return this;
        }

        public final Builder putMeta(Map.Entry<String, ? extends String> entry) {
            this.metaBuilder.put(entry);
            return this;
        }

        public final Builder meta(Map<String, ? extends String> entries) {
            this.metaBuilder = ImmutableMap.builder();
            return this.putAllMeta(entries);
        }

        public final Builder putAllMeta(Map<String, ? extends String> entries) {
            this.metaBuilder.putAll(entries);
            return this;
        }

        public final Builder port(int port) {
            this.port = port;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder weights(ServiceWeights weights) {
            this.weights = (ServiceWeights)Preconditions.checkNotNull((Object)weights, (Object)"weights");
            return this;
        }

        public final Builder weights(Optional<ServiceWeights> weights) {
            this.weights = weights.orElse(null);
            return this;
        }

        public ImmutableService build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableService(this.id, this.service, this.enableTagOverride, this.tagsBuilder.build(), this.address, this.metaBuilder.build(), this.port, this.weights);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("service");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("address");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("port");
            }
            return "Cannot build Service, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    static final class Json
    extends Service {
        @Nullable
        String id;
        @Nullable
        String service;
        Optional<Boolean> enableTagOverride = Optional.empty();
        List<String> tags = ImmutableList.of();
        @Nullable
        String address;
        @Nullable
        Map<String, String> meta;
        @Nullable
        Integer port;
        Optional<ServiceWeights> weights = Optional.empty();

        Json() {
        }

        @JsonProperty(value="ID")
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty(value="Service")
        public void setService(String service) {
            this.service = service;
        }

        @JsonProperty(value="EnableTagOverride")
        public void setEnableTagOverride(Optional<Boolean> enableTagOverride) {
            this.enableTagOverride = enableTagOverride;
        }

        @JsonProperty(value="Tags")
        @JsonDeserialize(as=ImmutableList.class, contentAs=String.class)
        public void setTags(List<String> tags) {
            this.tags = tags;
        }

        @JsonProperty(value="Address")
        public void setAddress(String address) {
            this.address = address;
        }

        @JsonProperty(value="Meta")
        public void setMeta(Map<String, String> meta) {
            this.meta = meta;
        }

        @JsonProperty(value="Port")
        public void setPort(int port) {
            this.port = port;
        }

        @JsonProperty(value="Weights")
        public void setWeights(Optional<ServiceWeights> weights) {
            this.weights = weights;
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getService() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Boolean> getEnableTagOverride() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getTags() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getAddress() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, String> getMeta() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getPort() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<ServiceWeights> getWeights() {
            throw new UnsupportedOperationException();
        }
    }
}

