/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.cache;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.orbitz.consul.cache.ServiceHealthKey;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@JsonIgnoreProperties(ignoreUnknown=true)
@Immutable
public final class ImmutableServiceHealthKey
extends ServiceHealthKey {
    private final String serviceId;
    private final String host;
    private final Integer port;

    private ImmutableServiceHealthKey(String serviceId, String host, Integer port) {
        this.serviceId = serviceId;
        this.host = host;
        this.port = port;
    }

    @Override
    public String getServiceId() {
        return this.serviceId;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public Integer getPort() {
        return this.port;
    }

    public final ImmutableServiceHealthKey withServiceId(String value) {
        if (this.serviceId.equals(value)) {
            return this;
        }
        return new ImmutableServiceHealthKey((String)Preconditions.checkNotNull((Object)value, (Object)"serviceId"), this.host, this.port);
    }

    public final ImmutableServiceHealthKey withHost(String value) {
        if (this.host.equals(value)) {
            return this;
        }
        return new ImmutableServiceHealthKey(this.serviceId, (String)Preconditions.checkNotNull((Object)value, (Object)"host"), this.port);
    }

    public final ImmutableServiceHealthKey withPort(Integer value) {
        if (this.port.equals(value)) {
            return this;
        }
        return new ImmutableServiceHealthKey(this.serviceId, this.host, (Integer)Preconditions.checkNotNull((Object)value, (Object)"port"));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableServiceHealthKey && this.equalTo((ImmutableServiceHealthKey)another);
    }

    private boolean equalTo(ImmutableServiceHealthKey another) {
        return this.serviceId.equals(another.serviceId) && this.host.equals(another.host) && this.port.equals(another.port);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.serviceId.hashCode();
        h = h * 17 + this.host.hashCode();
        h = h * 17 + this.port.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ServiceHealthKey").omitNullValues().add("serviceId", (Object)this.serviceId).add("host", (Object)this.host).add("port", (Object)this.port).toString();
    }

    public static ImmutableServiceHealthKey copyOf(ServiceHealthKey instance) {
        if (instance instanceof ImmutableServiceHealthKey) {
            return (ImmutableServiceHealthKey)instance;
        }
        return ImmutableServiceHealthKey.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_SERVICE_ID = 1L;
        private static final long INIT_BIT_HOST = 2L;
        private static final long INIT_BIT_PORT = 4L;
        private long initBits = 7L;
        @Nullable
        private String serviceId;
        @Nullable
        private String host;
        @Nullable
        private Integer port;

        private Builder() {
        }

        public final Builder from(ServiceHealthKey instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.serviceId(instance.getServiceId());
            this.host(instance.getHost());
            this.port(instance.getPort());
            return this;
        }

        public final Builder serviceId(String serviceId) {
            this.serviceId = (String)Preconditions.checkNotNull((Object)serviceId, (Object)"serviceId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder host(String host) {
            this.host = (String)Preconditions.checkNotNull((Object)host, (Object)"host");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder port(Integer port) {
            this.port = (Integer)Preconditions.checkNotNull((Object)port, (Object)"port");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableServiceHealthKey build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableServiceHealthKey(this.serviceId, this.host, this.port);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("serviceId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("host");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("port");
            }
            return "Cannot build ServiceHealthKey, some of required attributes are not set " + attributes;
        }
    }
}

