/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.cache;

import com.google.common.primitives.Ints;
import com.orbitz.consul.HealthClient;
import com.orbitz.consul.cache.ConsulCache;
import com.orbitz.consul.cache.ServiceHealthKey;
import com.orbitz.consul.config.CacheConfig;
import com.orbitz.consul.model.health.ServiceHealth;
import com.orbitz.consul.monitoring.ClientEventHandler;
import com.orbitz.consul.option.QueryOptions;
import java.util.function.Function;

public class ServiceHealthCache
extends ConsulCache<ServiceHealthKey, ServiceHealth> {
    private ServiceHealthCache(Function<ServiceHealth, ServiceHealthKey> keyConversion, ConsulCache.CallbackConsumer<ServiceHealth> callbackConsumer, CacheConfig cacheConfig, ClientEventHandler eventHandler) {
        super(keyConversion, callbackConsumer, cacheConfig, eventHandler);
    }

    public static ServiceHealthCache newCache(HealthClient healthClient, String serviceName, boolean passing, int watchSeconds, QueryOptions queryOptions, Function<ServiceHealth, ServiceHealthKey> keyExtractor) {
        ConsulCache.CallbackConsumer<ServiceHealth> callbackConsumer = (index, callback) -> {
            QueryOptions params = ServiceHealthCache.watchParams(index, watchSeconds, queryOptions);
            if (passing) {
                healthClient.getHealthyServiceInstances(serviceName, params, callback);
            } else {
                healthClient.getAllServiceInstances(serviceName, params, callback);
            }
        };
        return new ServiceHealthCache(keyExtractor, callbackConsumer, healthClient.getConfig().getCacheConfig(), healthClient.getEventHandler());
    }

    public static ServiceHealthCache newCache(HealthClient healthClient, String serviceName, boolean passing, int watchSeconds, QueryOptions queryOptions) {
        return ServiceHealthCache.newCache(healthClient, serviceName, passing, watchSeconds, queryOptions, ServiceHealthKey::fromServiceHealth);
    }

    public static ServiceHealthCache newCache(HealthClient healthClient, String serviceName, boolean passing, QueryOptions queryOptions, int watchSeconds) {
        return ServiceHealthCache.newCache(healthClient, serviceName, passing, watchSeconds, queryOptions);
    }

    public static ServiceHealthCache newCache(HealthClient healthClient, String serviceName) {
        CacheConfig cacheConfig = healthClient.getConfig().getCacheConfig();
        int watchSeconds = Ints.checkedCast((long)cacheConfig.getWatchDuration().getSeconds());
        return ServiceHealthCache.newCache(healthClient, serviceName, true, QueryOptions.BLANK, watchSeconds);
    }
}

