/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.cache;

import com.google.common.base.Function;
import com.orbitz.consul.HealthClient;
import com.orbitz.consul.async.ConsulResponseCallback;
import com.orbitz.consul.cache.ConsulCache;
import com.orbitz.consul.cache.ServiceHealthKey;
import com.orbitz.consul.model.health.ServiceHealth;
import com.orbitz.consul.option.QueryOptions;
import java.math.BigInteger;
import java.util.List;

public class ServiceHealthCache
extends ConsulCache<ServiceHealthKey, ServiceHealth> {
    private ServiceHealthCache(Function<ServiceHealth, ServiceHealthKey> keyConversion, ConsulCache.CallbackConsumer<ServiceHealth> callbackConsumer) {
        super(keyConversion, callbackConsumer);
    }

    public static ServiceHealthCache newCache(final HealthClient healthClient, final String serviceName, final boolean passing, final int watchSeconds, final QueryOptions queryOptions, Function<ServiceHealth, ServiceHealthKey> keyExtractor) {
        ConsulCache.CallbackConsumer<ServiceHealth> callbackConsumer = new ConsulCache.CallbackConsumer<ServiceHealth>(){

            @Override
            public void consume(BigInteger index, ConsulResponseCallback<List<ServiceHealth>> callback) {
                QueryOptions params = ConsulCache.watchParams(index, watchSeconds, queryOptions);
                if (passing) {
                    healthClient.getHealthyServiceInstances(serviceName, params, callback);
                } else {
                    healthClient.getAllServiceInstances(serviceName, params, callback);
                }
            }
        };
        return new ServiceHealthCache(keyExtractor, callbackConsumer);
    }

    public static ServiceHealthCache newCache(HealthClient healthClient, String serviceName, boolean passing, int watchSeconds, QueryOptions queryOptions) {
        Function<ServiceHealth, ServiceHealthKey> keyExtractor = new Function<ServiceHealth, ServiceHealthKey>(){

            public ServiceHealthKey apply(ServiceHealth input) {
                return ServiceHealthKey.fromServiceHealth(input);
            }
        };
        return ServiceHealthCache.newCache(healthClient, serviceName, passing, watchSeconds, queryOptions, keyExtractor);
    }

    public static ServiceHealthCache newCache(HealthClient healthClient, String serviceName, boolean passing, QueryOptions queryOptions, int watchSeconds) {
        return ServiceHealthCache.newCache(healthClient, serviceName, passing, watchSeconds, queryOptions);
    }

    public static ServiceHealthCache newCache(HealthClient healthClient, String serviceName) {
        return ServiceHealthCache.newCache(healthClient, serviceName, true, QueryOptions.BLANK, 10);
    }
}

