/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul;

import com.orbitz.consul.ConsulException;
import com.orbitz.consul.NotRegisteredException;
import com.orbitz.consul.model.State;
import com.orbitz.consul.model.agent.Agent;
import com.orbitz.consul.model.agent.Check;
import com.orbitz.consul.model.agent.Member;
import com.orbitz.consul.model.agent.Registration;
import com.orbitz.consul.model.health.HealthCheck;
import com.orbitz.consul.model.health.Service;
import java.net.URL;
import java.util.List;
import java.util.Map;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

public class AgentClient {
    private WebTarget webTarget;

    AgentClient(WebTarget webTarget) {
        this.webTarget = webTarget;
    }

    public boolean isRegistered(String serviceId) {
        Map<String, Service> serviceIdToService = this.getServices();
        return serviceIdToService.containsKey(serviceId);
    }

    public void ping() {
        Response response = null;
        try {
            response = this.webTarget.path("self").request().get();
            Response.StatusType status = response.getStatusInfo();
            if (status.getStatusCode() != Response.Status.OK.getStatusCode()) {
                throw new ConsulException(String.format("Error pinging Consul: %s", status.getReasonPhrase()));
            }
        }
        catch (Exception ex) {
            throw new ConsulException("Error connecting to Consul", ex);
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
    }

    public void register(int port, long ttl, String name, String id, String ... tags) {
        Registration.Check check = new Registration.Check();
        check.setTtl(String.format("%ss", ttl));
        this.register(port, check, name, id, tags);
    }

    public void register(int port, String script, long interval, String name, String id, String ... tags) {
        Registration.Check check = new Registration.Check();
        check.setScript(script);
        check.setInterval(String.format("%ss", interval));
        this.register(port, check, name, id, tags);
    }

    public void register(int port, URL http, long interval, String name, String id, String ... tags) {
        Registration.Check check = new Registration.Check();
        check.setHttp(http.toExternalForm());
        check.setInterval(String.format("%ss", interval));
        this.register(port, check, name, id, tags);
    }

    public void register(int port, Registration.Check check, String name, String id, String ... tags) {
        Registration registration = new Registration();
        registration.setPort(port);
        registration.setCheck(check);
        registration.setName(name);
        registration.setId(id);
        registration.setTags(tags);
        this.register(registration);
    }

    public void register(Registration registration) {
        Response response = this.webTarget.path("service").path("register").request().put(Entity.entity((Object)registration, (MediaType)MediaType.APPLICATION_JSON_TYPE));
        if (response.getStatus() != Response.Status.OK.getStatusCode()) {
            throw new ConsulException((String)response.readEntity(String.class));
        }
    }

    public void deregister(String serviceId) {
        Response response = this.webTarget.path("service").path("deregister").path(serviceId).request().get();
        if (response.getStatus() != Response.Status.OK.getStatusCode()) {
            throw new ConsulException((String)response.readEntity(String.class));
        }
    }

    public void registerCheck(String checkId, String name, String script, long interval) {
        this.registerCheck(checkId, name, script, interval, null);
    }

    public void registerCheck(String checkId, String name, URL http, long interval) {
        this.registerCheck(checkId, name, http, interval, null);
    }

    public void registerCheck(String checkId, String name, String script, long interval, String notes) {
        Check check = new Check();
        check.setId(checkId);
        check.setName(name);
        check.setScript(script);
        check.setInterval(String.format("%ss", interval));
        check.setNotes(notes);
        this.registerCheck(check);
    }

    public void registerCheck(String checkId, String name, URL http, long interval, String notes) {
        Check check = new Check();
        check.setId(checkId);
        check.setName(name);
        check.setHttp(http.toExternalForm());
        check.setInterval(String.format("%ss", interval));
        check.setNotes(notes);
        this.registerCheck(check);
    }

    public void registerCheck(String checkId, String name, long ttl) {
        this.registerCheck(checkId, name, ttl, null);
    }

    public void registerCheck(String checkId, String name, long ttl, String notes) {
        Check check = new Check();
        check.setId(checkId);
        check.setName(name);
        check.setTtl(String.format("%ss", ttl));
        check.setNotes(notes);
        this.registerCheck(check);
    }

    public void registerCheck(Check check) {
        Response response = this.webTarget.path("check").path("register").request().put(Entity.entity((Object)check, (MediaType)MediaType.APPLICATION_JSON_TYPE));
        if (response.getStatus() != Response.Status.OK.getStatusCode()) {
            throw new ConsulException((String)response.readEntity(String.class));
        }
    }

    public void deregisterCheck(String checkId) {
        Response response = this.webTarget.path("check").path("deregister").path(checkId).request().get();
        if (response.getStatus() != Response.Status.OK.getStatusCode()) {
            throw new ConsulException((String)response.readEntity(String.class));
        }
    }

    public Agent getAgent() {
        return (Agent)this.webTarget.path("self").request().accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get(Agent.class);
    }

    public Map<String, HealthCheck> getChecks() {
        return (Map)this.webTarget.path("checks").request().accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get((GenericType)new GenericType<Map<String, HealthCheck>>(){});
    }

    public Map<String, Service> getServices() {
        return (Map)this.webTarget.path("services").request().accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get((GenericType)new GenericType<Map<String, Service>>(){});
    }

    public List<Member> getMembers() {
        return (List)this.webTarget.path("members").request().accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get((GenericType)new GenericType<List<Member>>(){});
    }

    public void forceLeave(String node) {
        this.webTarget.path("force-leave").path(node).request().get();
    }

    public void check(String checkId, State state, String note) throws NotRegisteredException {
        WebTarget resource = this.webTarget.path("check").path(state.getPath());
        if (note != null) {
            resource = resource.queryParam("note", new Object[]{note});
        }
        try {
            resource.path(checkId).request().get(String.class);
        }
        catch (InternalServerErrorException ex) {
            throw new NotRegisteredException();
        }
    }

    public void checkTtl(String serviceId, State state, String note) throws NotRegisteredException {
        this.check("service:" + serviceId, state, note);
    }

    public void pass(String serviceId) throws NotRegisteredException {
        this.checkTtl(serviceId, State.PASS, null);
    }

    public void pass(String serviceId, String note) throws NotRegisteredException {
        this.checkTtl(serviceId, State.PASS, note);
    }

    public void warn(String serviceId) throws NotRegisteredException {
        this.checkTtl(serviceId, State.WARN, null);
    }

    public void warn(String serviceId, String note) throws NotRegisteredException {
        this.checkTtl(serviceId, State.WARN, note);
    }

    public void fail(String serviceId) throws NotRegisteredException {
        this.checkTtl(serviceId, State.FAIL, null);
    }

    public void fail(String serviceId, String note) throws NotRegisteredException {
        this.checkTtl(serviceId, State.FAIL, note);
    }

    public void passCheck(String checkId) throws NotRegisteredException {
        this.check(checkId, State.PASS, null);
    }

    public void passCheck(String checkId, String note) throws NotRegisteredException {
        this.check(checkId, State.PASS, note);
    }

    public void warnCheck(String checkId) throws NotRegisteredException {
        this.check(checkId, State.WARN, null);
    }

    public void warnCheck(String checkId, String note) throws NotRegisteredException {
        this.check(checkId, State.WARN, note);
    }

    public void failCheck(String checkId) throws NotRegisteredException {
        this.check(checkId, State.FAIL, null);
    }

    public void failCheck(String checkId, String note) throws NotRegisteredException {
        this.check(checkId, State.FAIL, note);
    }

    public boolean join(String address) {
        return this.join(address, false);
    }

    public boolean join(String address, boolean wan) {
        WebTarget resource = this.webTarget.path("join").path(address);
        if (wan) {
            resource = resource.queryParam("wan", new Object[]{"1"});
        }
        try {
            return resource.request().get().getStatus() == Response.Status.OK.getStatusCode();
        }
        catch (InternalServerErrorException ex) {
            return false;
        }
    }
}

