/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.util;

import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.orbitz.consul.Consul;
import com.orbitz.consul.KeyValueClient;
import com.orbitz.consul.SessionClient;
import com.orbitz.consul.model.kv.Value;
import com.orbitz.consul.util.ClientUtil;

public class LeaderElectionUtil {
    Consul client;
    KeyValueClient keyValueClient;
    SessionClient sessionClient;

    public void LeaderElectionUtil() {
        this.client = Consul.newClient();
        this.keyValueClient = this.client.keyValueClient();
        this.sessionClient = this.client.sessionClient();
    }

    public static String getLeaderInfoForService(Consul client, String serviceName) {
        String leaderInfo = null;
        String key = LeaderElectionUtil.getServiceKey(serviceName);
        Optional<Value> value = client.keyValueClient().getValue(key);
        if (value.isPresent() && !Strings.isNullOrEmpty((String)((Value)value.get()).getSession())) {
            leaderInfo = LeaderElectionUtil.getLeaderInfo(value);
        }
        return leaderInfo;
    }

    private static String getLeaderInfo(Optional<Value> value) {
        return ClientUtil.decodeBase64(((Value)value.get()).getValue());
    }

    public static String electNewLeaderForService(Consul client, String serviceName, String info) {
        String key = LeaderElectionUtil.getServiceKey(serviceName);
        String sessionId = LeaderElectionUtil.createSession(client, serviceName);
        if (client.keyValueClient().acquireLock(key, info, sessionId)) {
            return info;
        }
        return LeaderElectionUtil.getLeaderInfoForService(client, serviceName);
    }

    public static boolean releaseLockForService(Consul client, String serviceName) {
        String key = LeaderElectionUtil.getServiceKey(serviceName);
        KeyValueClient kv = client.keyValueClient();
        if (kv.getValue(key).orNull() != null) {
            return kv.releaseLock(key, ((Value)kv.getValue(key).get()).getSession());
        }
        return true;
    }

    private static String createSession(Consul client, String serviceName) {
        String value = "{\"Name\":\"" + serviceName + "\"}";
        return (String)client.sessionClient().createSession(value).get();
    }

    private static String getServiceKey(String serviceName) {
        return "service/" + serviceName + "/leader";
    }
}

