/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.util;

import com.orbitz.consul.ConsulException;
import com.orbitz.consul.async.ConsulResponseCallback;
import com.orbitz.consul.model.ConsulResponse;
import com.orbitz.consul.option.CatalogOptions;
import com.orbitz.consul.option.ConsistencyMode;
import com.orbitz.consul.option.EventOptions;
import com.orbitz.consul.option.QueryOptions;
import java.util.Map;
import javax.ws.rs.ServerErrorException;
import javax.ws.rs.client.InvocationCallback;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;

public class ClientUtil {
    public static WebTarget queryParams(WebTarget webTarget, Map<String, String> params) {
        WebTarget target = webTarget;
        if (params != null) {
            for (Map.Entry<String, String> entry : params.entrySet()) {
                target = target.queryParam(entry.getKey(), new Object[]{entry.getValue()});
            }
        }
        return target;
    }

    public static WebTarget queryConfig(WebTarget webTarget, QueryOptions queryOptions) {
        if (queryOptions.isBlocking()) {
            webTarget = webTarget.queryParam("wait", new Object[]{queryOptions.getWait()}).queryParam("index", new Object[]{String.valueOf(queryOptions.getIndex())});
        }
        if (queryOptions.getConsistencyMode() == ConsistencyMode.CONSISTENT) {
            webTarget = webTarget.queryParam("consistent", new Object[0]);
        }
        if (queryOptions.getConsistencyMode() == ConsistencyMode.STALE) {
            webTarget = webTarget.queryParam("stale", new Object[0]);
        }
        if (queryOptions.hasToken()) {
            webTarget = webTarget.queryParam("token", new Object[]{queryOptions.getToken()});
        }
        return webTarget;
    }

    public static WebTarget eventConfig(WebTarget webTarget, EventOptions eventOptions) {
        if (StringUtils.isNotEmpty((CharSequence)eventOptions.getDatacenter())) {
            webTarget = webTarget.queryParam("dc", new Object[]{eventOptions.getDatacenter()});
        }
        if (StringUtils.isNotEmpty((CharSequence)eventOptions.getNodeFilter())) {
            webTarget = webTarget.queryParam("node", new Object[]{eventOptions.getNodeFilter()});
        }
        if (StringUtils.isNotEmpty((CharSequence)eventOptions.getServiceFilter())) {
            webTarget = webTarget.queryParam("service", new Object[]{eventOptions.getServiceFilter()});
        }
        if (StringUtils.isNotEmpty((CharSequence)eventOptions.getTagFilter())) {
            webTarget = webTarget.queryParam("tag", new Object[]{eventOptions.getTagFilter()});
        }
        return webTarget;
    }

    public static <T> ConsulResponse<T> response(WebTarget target, CatalogOptions catalogOptions, QueryOptions queryOptions, GenericType<T> type) {
        target = ClientUtil.catalogConfig(target, catalogOptions);
        target = ClientUtil.queryConfig(target, queryOptions);
        return ClientUtil.response(target, type);
    }

    public static <T> void response(WebTarget target, CatalogOptions catalogOptions, QueryOptions queryOptions, GenericType<T> type, ConsulResponseCallback<T> callback) {
        target = ClientUtil.catalogConfig(target, catalogOptions);
        target = ClientUtil.queryConfig(target, queryOptions);
        ClientUtil.response(target, type, callback);
    }

    private static WebTarget catalogConfig(WebTarget target, CatalogOptions catalogOptions) {
        if (catalogOptions != null) {
            if (!StringUtils.isEmpty((CharSequence)catalogOptions.getDatacenter())) {
                target = target.queryParam("dc", new Object[]{catalogOptions.getDatacenter()});
            }
            if (!StringUtils.isEmpty((CharSequence)catalogOptions.getTag())) {
                target = target.queryParam("tag", new Object[]{catalogOptions.getTag()});
            }
        }
        return target;
    }

    public static <T> ConsulResponse<T> response(WebTarget webTarget, GenericType<T> responseType) {
        Response response = webTarget.request().accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get();
        return ClientUtil.consulResponse(responseType, response);
    }

    public static <T> void response(WebTarget webTarget, final GenericType<T> responseType, final ConsulResponseCallback<T> callback) {
        webTarget.request().accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).async().get((InvocationCallback)new InvocationCallback<Response>(){

            public void completed(Response response) {
                try {
                    callback.onComplete(ClientUtil.consulResponse(responseType, response));
                }
                catch (Exception ex) {
                    callback.onFailure(ex);
                }
            }

            public void failed(Throwable throwable) {
                callback.onFailure(throwable);
            }
        });
    }

    private static <T> ConsulResponse<T> consulResponse(GenericType<T> responseType, Response response) {
        ClientUtil.handleErrors(response);
        String indexHeaderValue = response.getHeaderString("X-Consul-Index");
        String lastContactHeaderValue = response.getHeaderString("X-Consul-Lastcontact");
        String knownLeaderHeaderValue = response.getHeaderString("X-Consul-Knownleader");
        long index = Long.valueOf(indexHeaderValue);
        long lastContact = lastContactHeaderValue == null ? -1L : Long.valueOf(lastContactHeaderValue);
        boolean knownLeader = knownLeaderHeaderValue == null ? false : Boolean.valueOf(knownLeaderHeaderValue);
        ConsulResponse<Object> consulResponse = new ConsulResponse<Object>(response.readEntity(responseType), lastContact, knownLeader, index);
        response.close();
        return consulResponse;
    }

    public static String decodeBase64(String value) {
        return new String(Base64.decodeBase64((String)value));
    }

    public static void handleErrors(Response response) {
        if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
            ServerErrorException see = null;
            if (response.hasEntity()) {
                String message = (String)response.readEntity(String.class);
                see = new ServerErrorException(message, response);
            } else {
                see = new ServerErrorException(response);
            }
            response.close();
            throw new ConsulException(see.getLocalizedMessage(), (Throwable)see);
        }
    }
}

