/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul;

import com.orbitz.consul.async.ConsulResponseCallback;
import com.orbitz.consul.model.ConsulResponse;
import com.orbitz.consul.model.State;
import com.orbitz.consul.model.health.HealthCheck;
import com.orbitz.consul.model.health.ServiceHealth;
import com.orbitz.consul.option.CatalogOptions;
import com.orbitz.consul.option.CatalogOptionsBuilder;
import com.orbitz.consul.option.QueryOptions;
import com.orbitz.consul.util.ClientUtil;
import java.util.List;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;

public class HealthClient {
    private WebTarget webTarget;

    HealthClient(WebTarget webTarget) {
        this.webTarget = webTarget;
    }

    public ConsulResponse<List<HealthCheck>> getNodeChecks(String node) {
        return this.getNodeChecks(node, null, QueryOptions.BLANK);
    }

    public ConsulResponse<List<HealthCheck>> getNodeChecks(String node, CatalogOptions catalogOptions) {
        return this.getNodeChecks(node, catalogOptions, QueryOptions.BLANK);
    }

    public ConsulResponse<List<HealthCheck>> getNodeChecks(String node, QueryOptions queryOptions) {
        return this.getNodeChecks(node, null, queryOptions);
    }

    public ConsulResponse<List<HealthCheck>> getNodeChecks(String node, CatalogOptions catalogOptions, QueryOptions queryOptions) {
        return ClientUtil.response(this.webTarget.path("node").path(node), catalogOptions, queryOptions, new GenericType<List<HealthCheck>>(){});
    }

    public ConsulResponse<List<HealthCheck>> getServiceChecks(String service) {
        return this.getServiceChecks(service, null, QueryOptions.BLANK);
    }

    public ConsulResponse<List<HealthCheck>> getServiceChecks(String service, CatalogOptions catalogOptions) {
        return this.getServiceChecks(service, catalogOptions, QueryOptions.BLANK);
    }

    public ConsulResponse<List<HealthCheck>> getServiceChecks(String service, QueryOptions queryOptions) {
        return this.getServiceChecks(service, null, queryOptions);
    }

    public ConsulResponse<List<HealthCheck>> getServiceChecks(String service, CatalogOptions catalogOptions, QueryOptions queryOptions) {
        return ClientUtil.response(this.webTarget.path("checks").path(service), catalogOptions, queryOptions, new GenericType<List<HealthCheck>>(){});
    }

    public void getServiceChecks(String service, QueryOptions queryOptions, ConsulResponseCallback<List<HealthCheck>> callback) {
        ClientUtil.response(this.webTarget.path("checks").path(service), CatalogOptionsBuilder.builder().build(), queryOptions, new GenericType<List<HealthCheck>>(){}, callback);
    }

    public void getServiceChecks(String service, CatalogOptions catalogOptions, QueryOptions queryOptions, ConsulResponseCallback<List<HealthCheck>> callback) {
        ClientUtil.response(this.webTarget.path("checks").path(service), catalogOptions, queryOptions, new GenericType<List<HealthCheck>>(){}, callback);
    }

    public ConsulResponse<List<HealthCheck>> getChecksByState(State state) {
        return this.getChecksByState(state, null, QueryOptions.BLANK);
    }

    public ConsulResponse<List<HealthCheck>> getChecksByState(State state, CatalogOptions catalogOptions) {
        return this.getChecksByState(state, catalogOptions, QueryOptions.BLANK);
    }

    public ConsulResponse<List<HealthCheck>> getChecksByState(State state, QueryOptions queryOptions) {
        return this.getChecksByState(state, null, queryOptions);
    }

    public ConsulResponse<List<HealthCheck>> getChecksByState(State state, CatalogOptions catalogOptions, QueryOptions queryOptions) {
        return ClientUtil.response(this.webTarget.path("state").path(state.getName()), catalogOptions, queryOptions, new GenericType<List<HealthCheck>>(){});
    }

    public ConsulResponse<List<ServiceHealth>> getHealthyServiceInstances(String service) {
        return this.getHealthyServiceInstances(service, null, QueryOptions.BLANK);
    }

    public ConsulResponse<List<ServiceHealth>> getHealthyServiceInstances(String service, CatalogOptions catalogOptions) {
        return this.getHealthyServiceInstances(service, catalogOptions, QueryOptions.BLANK);
    }

    public ConsulResponse<List<ServiceHealth>> getHealthyServiceInstances(String service, QueryOptions queryOptions) {
        return this.getHealthyServiceInstances(service, null, queryOptions);
    }

    public ConsulResponse<List<ServiceHealth>> getHealthyServiceInstances(String service, CatalogOptions catalogOptions, QueryOptions queryOptions) {
        return ClientUtil.response(this.webTarget.path("service").path(service).queryParam("passing", new Object[]{"true"}), catalogOptions, queryOptions, new GenericType<List<ServiceHealth>>(){});
    }

    public void getHealthyServiceInstances(String service, CatalogOptions catalogOptions, QueryOptions queryOptions, ConsulResponseCallback<List<ServiceHealth>> callback) {
        ClientUtil.response(this.webTarget.path("service").path(service).queryParam("passing", new Object[]{"true"}), catalogOptions, queryOptions, new GenericType<List<ServiceHealth>>(){}, callback);
    }

    public void getHealthyServiceInstances(String service, QueryOptions queryOptions, ConsulResponseCallback<List<ServiceHealth>> callback) {
        ClientUtil.response(this.webTarget.path("service").path(service).queryParam("passing", new Object[]{"true"}), CatalogOptionsBuilder.builder().build(), queryOptions, new GenericType<List<ServiceHealth>>(){}, callback);
    }

    public ConsulResponse<List<ServiceHealth>> getAllServiceInstances(String service) {
        return this.getAllServiceInstances(service, null, QueryOptions.BLANK);
    }

    public ConsulResponse<List<ServiceHealth>> getAllServiceInstances(String service, CatalogOptions catalogOptions) {
        return this.getAllServiceInstances(service, catalogOptions, QueryOptions.BLANK);
    }

    public ConsulResponse<List<ServiceHealth>> getAllServiceInstances(String service, QueryOptions queryOptions) {
        return this.getAllServiceInstances(service, null, queryOptions);
    }

    public ConsulResponse<List<ServiceHealth>> getAllServiceInstances(String service, CatalogOptions catalogOptions, QueryOptions queryOptions) {
        return ClientUtil.response(this.webTarget.path("service").path(service), catalogOptions, queryOptions, new GenericType<List<ServiceHealth>>(){});
    }

    public void getAllServiceInstances(String service, CatalogOptions catalogOptions, QueryOptions queryOptions, ConsulResponseCallback<List<ServiceHealth>> callback) {
        ClientUtil.response(this.webTarget.path("service").path(service), catalogOptions, queryOptions, new GenericType<List<ServiceHealth>>(){}, callback);
    }

    public void getAllServiceInstances(String service, QueryOptions queryOptions, ConsulResponseCallback<List<ServiceHealth>> callback) {
        ClientUtil.response(this.webTarget.path("service").path(service), CatalogOptionsBuilder.builder().build(), queryOptions, new GenericType<List<ServiceHealth>>(){}, callback);
    }
}

