/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul;

import com.fasterxml.jackson.jaxrs.json.JacksonJaxbJsonProvider;
import com.orbitz.consul.AgentClient;
import com.orbitz.consul.CatalogClient;
import com.orbitz.consul.ConsulException;
import com.orbitz.consul.EventClient;
import com.orbitz.consul.HealthClient;
import com.orbitz.consul.KeyValueClient;
import com.orbitz.consul.SessionClient;
import com.orbitz.consul.StatusClient;
import java.net.MalformedURLException;
import java.net.URL;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;

public class Consul {
    public static final String DEFAULT_HTTP_HOST = "localhost";
    public static final int DEFAULT_HTTP_PORT = 8500;
    private AgentClient agentClient;
    private HealthClient healthClient;
    private KeyValueClient keyValueClient;
    private CatalogClient catalogClient;
    private StatusClient statusClient;
    private SessionClient sessionClient;
    private EventClient eventClient;

    private Consul(String url, ClientBuilder builder) {
        Client client = ((ClientBuilder)builder.register(JacksonJaxbJsonProvider.class)).build();
        this.agentClient = new AgentClient(client.target(url).path("v1").path("agent"));
        this.healthClient = new HealthClient(client.target(url).path("v1").path("health"));
        this.keyValueClient = new KeyValueClient(client.target(url).path("v1").path("kv"));
        this.catalogClient = new CatalogClient(client.target(url).path("v1").path("catalog"));
        this.statusClient = new StatusClient(client.target(url).path("v1").path("status"));
        this.sessionClient = new SessionClient(client.target(url).path("v1").path("session"));
        this.eventClient = new EventClient(client.target(url).path("v1").path("event"));
        this.agentClient.ping();
    }

    public static Consul newClient(String url, ClientBuilder builder) {
        return new Consul(url, builder);
    }

    public static Consul newClient(String host, int port, ClientBuilder builder) {
        try {
            return new Consul(new URL("http", host, port, "").toString(), builder);
        }
        catch (MalformedURLException e) {
            throw new ConsulException("Bad Consul URL", e);
        }
    }

    public static Consul newClient(String host, int port) {
        return Consul.newClient(host, port, ClientBuilder.newBuilder());
    }

    public static Consul newClient() {
        return Consul.newClient(DEFAULT_HTTP_HOST, 8500);
    }

    public AgentClient agentClient() {
        return this.agentClient;
    }

    public CatalogClient catalogClient() {
        return this.catalogClient;
    }

    public HealthClient healthClient() {
        return this.healthClient;
    }

    public KeyValueClient keyValueClient() {
        return this.keyValueClient;
    }

    public StatusClient statusClient() {
        return this.statusClient;
    }

    public SessionClient sessionClient() {
        return this.sessionClient;
    }

    public EventClient eventClient() {
        return this.eventClient;
    }
}

