/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul;

import com.orbitz.consul.model.ConsulResponse;
import com.orbitz.consul.model.catalog.CatalogNode;
import com.orbitz.consul.model.catalog.CatalogService;
import com.orbitz.consul.model.health.Node;
import com.orbitz.consul.option.CatalogOptions;
import com.orbitz.consul.option.QueryOptions;
import com.orbitz.consul.util.ClientUtil;
import java.util.List;
import java.util.Map;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;

public class CatalogClient {
    private WebTarget webTarget;

    CatalogClient(WebTarget webTarget) {
        this.webTarget = webTarget;
    }

    public List<String> getDatacenters() {
        return (List)this.webTarget.path("datacenters").request().accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get((GenericType)new GenericType<List<String>>(){});
    }

    public ConsulResponse<List<Node>> getNodes() {
        return this.getNodes(null, QueryOptions.BLANK);
    }

    public ConsulResponse<List<Node>> getNodes(CatalogOptions catalogOptions) {
        return this.getNodes(catalogOptions, QueryOptions.BLANK);
    }

    public ConsulResponse<List<Node>> getNodes(QueryOptions queryOptions) {
        return this.getNodes(null, queryOptions);
    }

    public ConsulResponse<List<Node>> getNodes(CatalogOptions catalogOptions, QueryOptions queryOptions) {
        return ClientUtil.response(this.webTarget.path("nodes"), catalogOptions, queryOptions, new GenericType<List<Node>>(){});
    }

    public ConsulResponse<Map<String, List<String>>> getServices() {
        return this.getServices(null, QueryOptions.BLANK);
    }

    public ConsulResponse<Map<String, List<String>>> getServices(CatalogOptions catalogOptions) {
        return this.getServices(catalogOptions, QueryOptions.BLANK);
    }

    public ConsulResponse<Map<String, List<String>>> getServices(QueryOptions queryOptions) {
        return this.getServices(null, queryOptions);
    }

    public ConsulResponse<Map<String, List<String>>> getServices(CatalogOptions catalogOptions, QueryOptions queryOptions) {
        return ClientUtil.response(this.webTarget.path("services"), catalogOptions, queryOptions, new GenericType<Map<String, List<String>>>(){});
    }

    public ConsulResponse<List<CatalogService>> getService(String service) {
        return this.getService(service, null, QueryOptions.BLANK);
    }

    public ConsulResponse<List<CatalogService>> getService(String service, CatalogOptions catalogOptions) {
        return this.getService(service, catalogOptions, QueryOptions.BLANK);
    }

    public ConsulResponse<List<CatalogService>> getService(String service, QueryOptions queryOptions) {
        return this.getService(service, null, queryOptions);
    }

    public ConsulResponse<List<CatalogService>> getService(String service, CatalogOptions catalogOptions, QueryOptions queryOptions) {
        return ClientUtil.response(this.webTarget.path("service").path(service), catalogOptions, queryOptions, new GenericType<List<CatalogService>>(){});
    }

    public ConsulResponse<CatalogNode> getNode(String node) {
        return this.getNode(node, null, QueryOptions.BLANK);
    }

    public ConsulResponse<CatalogNode> getNode(String node, CatalogOptions catalogOptions) {
        return this.getNode(node, catalogOptions, QueryOptions.BLANK);
    }

    public ConsulResponse<CatalogNode> getNode(String node, QueryOptions queryOptions) {
        return this.getNode(node, null, queryOptions);
    }

    public ConsulResponse<CatalogNode> getNode(String node, CatalogOptions catalogOptions, QueryOptions queryOptions) {
        return ClientUtil.response(this.webTarget.path("node").path(node), catalogOptions, queryOptions, new GenericType<CatalogNode>(){});
    }
}

