package com.orbitz.consul.model.session;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Generated;

/**
 * Immutable implementation of {@link Session}.
 * <p>
 * Use builder to create immutable instances:
 * {@code ImmutableSession.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "Session"})
public final class ImmutableSession extends Session {
  private final Optional<String> lockDelay;
  private final Optional<String> name;
  private final Optional<String> node;
  private final ImmutableList<String> checks;
  private final Optional<String> behavior;
  private final Optional<String> ttl;

  private ImmutableSession(
      Optional<String> lockDelay,
      Optional<String> name,
      Optional<String> node,
      ImmutableList<String> checks,
      Optional<String> behavior,
      Optional<String> ttl) {
    this.lockDelay = lockDelay;
    this.name = name;
    this.node = node;
    this.checks = checks;
    this.behavior = behavior;
    this.ttl = ttl;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code lockDelay} attribute
   */
  @JsonProperty("LockDelay")
  @Override
  public Optional<String> getLockDelay() {
    return lockDelay;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code name} attribute
   */
  @JsonProperty("Name")
  @Override
  public Optional<String> getName() {
    return name;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code node} attribute
   */
  @JsonProperty("Node")
  @Override
  public Optional<String> getNode() {
    return node;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code checks} attribute
   */
  @JsonProperty("Checks")
  @Override
  public ImmutableList<String> getChecks() {
    return checks;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code behavior} attribute
   */
  @JsonProperty("Behavior")
  @Override
  public Optional<String> getBehavior() {
    return behavior;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code ttl} attribute
   */
  @JsonProperty("TTL")
  @Override
  public Optional<String> getTtl() {
    return ttl;
  }
  
  /**
   * Copy current immutable object by setting present value for optional {@link Session#getLockDelay() lockDelay}.
   * @param value value for lockDelay
   * @return modified copy of {@code this} object
   */
  public final ImmutableSession withLockDelay(String value) {
    Optional<String> newValue = Optional.of(value);
    return new ImmutableSession(newValue, this.name, this.node, this.checks, this.behavior, this.ttl);
  }
  
  /**
   * Copy current immutable object by setting optional value for {@link Session#getLockDelay() lockDelay}.
   * Shallow reference equality check on optional value is used to prevent copying of the same value by returning {@code this}.
   * @param optional value for lockDelay
   * @return modified copy of {@code this} object
   */
  public final ImmutableSession withLockDelay(Optional<String> optional) {
    if (this.lockDelay == optional) {
      return this;
    }
    Optional<String> newValue = Preconditions.checkNotNull(optional);
    return new ImmutableSession(newValue, this.name, this.node, this.checks, this.behavior, this.ttl);
  }
  
  /**
   * Copy current immutable object by setting present value for optional {@link Session#getName() name}.
   * @param value value for name
   * @return modified copy of {@code this} object
   */
  public final ImmutableSession withName(String value) {
    Optional<String> newValue = Optional.of(value);
    return new ImmutableSession(this.lockDelay, newValue, this.node, this.checks, this.behavior, this.ttl);
  }
  
  /**
   * Copy current immutable object by setting optional value for {@link Session#getName() name}.
   * Shallow reference equality check on optional value is used to prevent copying of the same value by returning {@code this}.
   * @param optional value for name
   * @return modified copy of {@code this} object
   */
  public final ImmutableSession withName(Optional<String> optional) {
    if (this.name == optional) {
      return this;
    }
    Optional<String> newValue = Preconditions.checkNotNull(optional);
    return new ImmutableSession(this.lockDelay, newValue, this.node, this.checks, this.behavior, this.ttl);
  }
  
  /**
   * Copy current immutable object by setting present value for optional {@link Session#getNode() node}.
   * @param value value for node
   * @return modified copy of {@code this} object
   */
  public final ImmutableSession withNode(String value) {
    Optional<String> newValue = Optional.of(value);
    return new ImmutableSession(this.lockDelay, this.name, newValue, this.checks, this.behavior, this.ttl);
  }
  
  /**
   * Copy current immutable object by setting optional value for {@link Session#getNode() node}.
   * Shallow reference equality check on optional value is used to prevent copying of the same value by returning {@code this}.
   * @param optional value for node
   * @return modified copy of {@code this} object
   */
  public final ImmutableSession withNode(Optional<String> optional) {
    if (this.node == optional) {
      return this;
    }
    Optional<String> newValue = Preconditions.checkNotNull(optional);
    return new ImmutableSession(this.lockDelay, this.name, newValue, this.checks, this.behavior, this.ttl);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link Session#getChecks() checks}.
   * @param elements elements to set
   * @return modified copy of {@code this} object
   */
  public final ImmutableSession withChecks(String... elements) {
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableSession(this.lockDelay, this.name, this.node, newValue, this.behavior, this.ttl);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link Session#getChecks() checks}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements iterable of checks elements to set
   * @return modified copy of {@code this} object
   */
  public final ImmutableSession withChecks(Iterable<String> elements) {
    if (this.checks == elements) {
      return this;
    }
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableSession(this.lockDelay, this.name, this.node, newValue, this.behavior, this.ttl);
  }
  
  /**
   * Copy current immutable object by setting present value for optional {@link Session#getBehavior() behavior}.
   * @param value value for behavior
   * @return modified copy of {@code this} object
   */
  public final ImmutableSession withBehavior(String value) {
    Optional<String> newValue = Optional.of(value);
    return new ImmutableSession(this.lockDelay, this.name, this.node, this.checks, newValue, this.ttl);
  }
  
  /**
   * Copy current immutable object by setting optional value for {@link Session#getBehavior() behavior}.
   * Shallow reference equality check on optional value is used to prevent copying of the same value by returning {@code this}.
   * @param optional value for behavior
   * @return modified copy of {@code this} object
   */
  public final ImmutableSession withBehavior(Optional<String> optional) {
    if (this.behavior == optional) {
      return this;
    }
    Optional<String> newValue = Preconditions.checkNotNull(optional);
    return new ImmutableSession(this.lockDelay, this.name, this.node, this.checks, newValue, this.ttl);
  }
  
  /**
   * Copy current immutable object by setting present value for optional {@link Session#getTtl() ttl}.
   * @param value value for ttl
   * @return modified copy of {@code this} object
   */
  public final ImmutableSession withTtl(String value) {
    Optional<String> newValue = Optional.of(value);
    return new ImmutableSession(this.lockDelay, this.name, this.node, this.checks, this.behavior, newValue);
  }
  
  /**
   * Copy current immutable object by setting optional value for {@link Session#getTtl() ttl}.
   * Shallow reference equality check on optional value is used to prevent copying of the same value by returning {@code this}.
   * @param optional value for ttl
   * @return modified copy of {@code this} object
   */
  public final ImmutableSession withTtl(Optional<String> optional) {
    if (this.ttl == optional) {
      return this;
    }
    Optional<String> newValue = Preconditions.checkNotNull(optional);
    return new ImmutableSession(this.lockDelay, this.name, this.node, this.checks, this.behavior, newValue);
  }
  
  /**
   * This instance is equal to instances of {@code ImmutableSession} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    return this == another
        || (another instanceof ImmutableSession && equalTo((ImmutableSession) another));
  }
  
  private boolean equalTo(ImmutableSession another) {
    return lockDelay.equals(another.lockDelay)
        && name.equals(another.name)
        && node.equals(another.node)
        && checks.equals(another.checks)
        && behavior.equals(another.behavior)
        && ttl.equals(another.ttl);
  }
  
  /**
   * Computes hash code from attributes: {@code lockDelay}, {@code name}, {@code node}, {@code checks}, {@code behavior}, {@code ttl}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + lockDelay.hashCode();
    h = h * 17 + name.hashCode();
    h = h * 17 + node.hashCode();
    h = h * 17 + checks.hashCode();
    h = h * 17 + behavior.hashCode();
    h = h * 17 + ttl.hashCode();
    return h;
  }
  
  /**
   * Prints immutable value {@code Session{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Session")
        .add("lockDelay", lockDelay)
        .add("name", name)
        .add("node", node)
        .add("checks", checks)
        .add("behavior", behavior)
        .add("ttl", ttl)
        .toString();
  }
  
  @JsonCreator
  public static ImmutableSession fromAllAttributes(
      @JsonProperty("LockDelay") Optional<String> lockDelay,
      @JsonProperty("Name") Optional<String> name,
      @JsonProperty("Node") Optional<String> node,
      @JsonProperty("Checks") List<String> checks,
      @JsonProperty("Behavior") Optional<String> behavior,
      @JsonProperty("TTL") Optional<String> ttl) {
    ImmutableSession.Builder builder = ImmutableSession.builder();
    if (lockDelay != null) {
      builder.lockDelay(lockDelay);
    }
    if (name != null) {
      builder.name(name);
    }
    if (node != null) {
      builder.node(node);
    }
    if (checks != null) {
      builder.addAllChecks(checks);
    }
    if (behavior != null) {
      builder.behavior(behavior);
    }
    if (ttl != null) {
      builder.ttl(ttl);
    }
    return builder.build();
  }
  
  /**
   * Creates immutable copy of {@link Session}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance instance to copy
   * @return copied immutable Session instance
   */
  public static ImmutableSession copyOf(Session instance) {
    if (instance instanceof ImmutableSession) {
      return (ImmutableSession) instance;
    }
    return ImmutableSession.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates builder for {@link com.orbitz.consul.model.session.ImmutableSession}.
   * @return new ImmutableSession builder
   */
  public static ImmutableSession.Builder builder() {
    return new ImmutableSession.Builder();
  }
  
  /**
   * Builds instances of {@link com.orbitz.consul.model.session.ImmutableSession}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  public static final class Builder {
  
    private Optional<String> lockDelay = Optional.absent();
    private Optional<String> name = Optional.absent();
    private Optional<String> node = Optional.absent();
    private ImmutableList.Builder<String> checksBuilder = ImmutableList.builder();
    private Optional<String> behavior = Optional.absent();
    private Optional<String> ttl = Optional.absent();
    private Builder() {}
  
    /**
     * Fill builder with attribute values from provided {@link Session} instance.
     * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
     * Instance's absent optional values will not be copied (will not override current).
     * Collection elements and entries will be added, not replaced.
     * @param instance instance to copy values from
     * @return {@code this} builder for chained invocation
     */
    public final Builder from(Session instance) {
      Preconditions.checkNotNull(instance);
      Optional<String> lockDelayOptional = instance.getLockDelay();
      if (lockDelayOptional.isPresent()) {
        lockDelay(lockDelayOptional);
      }
      Optional<String> nameOptional = instance.getName();
      if (nameOptional.isPresent()) {
        name(nameOptional);
      }
      Optional<String> nodeOptional = instance.getNode();
      if (nodeOptional.isPresent()) {
        node(nodeOptional);
      }
      addAllChecks(instance.getChecks());
      Optional<String> behaviorOptional = instance.getBehavior();
      if (behaviorOptional.isPresent()) {
        behavior(behaviorOptional);
      }
      Optional<String> ttlOptional = instance.getTtl();
      if (ttlOptional.isPresent()) {
        ttl(ttlOptional);
      }
      return this;
    }
  
    /**
     * Initializes present value for optional {@link Session#getLockDelay() lockDelay}.
     * @param lockDelay value for lockDelay
     * @return {@code this} builder for chained invocation
     */
    public final Builder lockDelay(String lockDelay) {
      this.lockDelay = Optional.of(lockDelay);
      return this;
    }
  
    /**
     * Initializes optional value for {@link Session#getLockDelay() lockDelay}.
     * @param lockDelay value for lockDelay
     * @return {@code this} builder for chained invocation
     */
    public final Builder lockDelay(Optional<String> lockDelay) {
      this.lockDelay = Preconditions.checkNotNull(lockDelay);
      return this;
    }
  
    /**
     * Initializes present value for optional {@link Session#getName() name}.
     * @param name value for name
     * @return {@code this} builder for chained invocation
     */
    public final Builder name(String name) {
      this.name = Optional.of(name);
      return this;
    }
  
    /**
     * Initializes optional value for {@link Session#getName() name}.
     * @param name value for name
     * @return {@code this} builder for chained invocation
     */
    public final Builder name(Optional<String> name) {
      this.name = Preconditions.checkNotNull(name);
      return this;
    }
  
    /**
     * Initializes present value for optional {@link Session#getNode() node}.
     * @param node value for node
     * @return {@code this} builder for chained invocation
     */
    public final Builder node(String node) {
      this.node = Optional.of(node);
      return this;
    }
  
    /**
     * Initializes optional value for {@link Session#getNode() node}.
     * @param node value for node
     * @return {@code this} builder for chained invocation
     */
    public final Builder node(Optional<String> node) {
      this.node = Preconditions.checkNotNull(node);
      return this;
    }
  
    /**
     * Adds one element to {@link Session#getChecks() checks} list.
     * @param element checks element
     * @return {@code this} builder for chained invocation
     */
    public final Builder addChecks(String element) {
      checksBuilder.add(element);
      return this;
    }
  
    /**
     * Adds elements to {@link Session#getChecks() checks} list.
     * @param elements array of checks elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addChecks(String... elements) {
      checksBuilder.add(elements);
      return this;
    }
  
    /**
     * Sets or replaces all elements for {@link Session#getChecks() checks} list.
     * @param elements iterable of checks elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder checks(Iterable<String> elements) {
      checksBuilder = ImmutableList.builder();
      return addAllChecks(elements);
    }
  
    /**
     * Adds elements to {@link Session#getChecks() checks} list.
     * @param elements iterable of checks elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addAllChecks(Iterable<String> elements) {
      checksBuilder.addAll(elements);
      return this;
    }
  
    /**
     * Initializes present value for optional {@link Session#getBehavior() behavior}.
     * @param behavior value for behavior
     * @return {@code this} builder for chained invocation
     */
    public final Builder behavior(String behavior) {
      this.behavior = Optional.of(behavior);
      return this;
    }
  
    /**
     * Initializes optional value for {@link Session#getBehavior() behavior}.
     * @param behavior value for behavior
     * @return {@code this} builder for chained invocation
     */
    public final Builder behavior(Optional<String> behavior) {
      this.behavior = Preconditions.checkNotNull(behavior);
      return this;
    }
  
    /**
     * Initializes present value for optional {@link Session#getTtl() ttl}.
     * @param ttl value for ttl
     * @return {@code this} builder for chained invocation
     */
    public final Builder ttl(String ttl) {
      this.ttl = Optional.of(ttl);
      return this;
    }
  
    /**
     * Initializes optional value for {@link Session#getTtl() ttl}.
     * @param ttl value for ttl
     * @return {@code this} builder for chained invocation
     */
    public final Builder ttl(Optional<String> ttl) {
      this.ttl = Preconditions.checkNotNull(ttl);
      return this;
    }
  
    /**
     * Builds new {@link com.orbitz.consul.model.session.ImmutableSession}.
     * @return immutable instance of Session
     */
    public ImmutableSession build() {
      return new ImmutableSession(lockDelay, name, node, checksBuilder.build(), behavior, ttl);
    }
  }
}
