package com.orbitz.consul.option;

import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import javax.annotation.Generated;

/**
 * Immutable implementation of {@link PutOptions}.
 * <p>
 * Use builder to create immutable instances:
 * {@code ImmutablePutOptions.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "PutOptions"})
public final class ImmutablePutOptions extends PutOptions {
  private final Optional<Integer> cas;
  private final Optional<String> acquire;
  private final Optional<String> release;
  private final Optional<String> dc;

  private ImmutablePutOptions(
      Optional<Integer> cas,
      Optional<String> acquire,
      Optional<String> release,
      Optional<String> dc) {
    this.cas = cas;
    this.acquire = acquire;
    this.release = release;
    this.dc = dc;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code cas} attribute
   */
  @Override
  public Optional<Integer> getCas() {
    return cas;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code acquire} attribute
   */
  @Override
  public Optional<String> getAcquire() {
    return acquire;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code release} attribute
   */
  @Override
  public Optional<String> getRelease() {
    return release;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code dc} attribute
   */
  @Override
  public Optional<String> getDc() {
    return dc;
  }
  
  /**
   * Copy current immutable object by setting present value for optional {@link PutOptions#getCas() cas}.
   * @param value value for cas
   * @return modified copy of {@code this} object
   */
  public final ImmutablePutOptions withCas(int value) {
    Optional<Integer> newValue = Optional.of(value);
    return new ImmutablePutOptions(newValue, this.acquire, this.release, this.dc);
  }
  
  /**
   * Copy current immutable object by setting optional value for {@link PutOptions#getCas() cas}.
   * Shallow reference equality check on optional value is used to prevent copying of the same value by returning {@code this}.
   * @param optional value for cas
   * @return modified copy of {@code this} object
   */
  public final ImmutablePutOptions withCas(Optional<Integer> optional) {
    if (this.cas == optional) {
      return this;
    }
    Optional<Integer> newValue = Preconditions.checkNotNull(optional);
    return new ImmutablePutOptions(newValue, this.acquire, this.release, this.dc);
  }
  
  /**
   * Copy current immutable object by setting present value for optional {@link PutOptions#getAcquire() acquire}.
   * @param value value for acquire
   * @return modified copy of {@code this} object
   */
  public final ImmutablePutOptions withAcquire(String value) {
    Optional<String> newValue = Optional.of(value);
    return new ImmutablePutOptions(this.cas, newValue, this.release, this.dc);
  }
  
  /**
   * Copy current immutable object by setting optional value for {@link PutOptions#getAcquire() acquire}.
   * Shallow reference equality check on optional value is used to prevent copying of the same value by returning {@code this}.
   * @param optional value for acquire
   * @return modified copy of {@code this} object
   */
  public final ImmutablePutOptions withAcquire(Optional<String> optional) {
    if (this.acquire == optional) {
      return this;
    }
    Optional<String> newValue = Preconditions.checkNotNull(optional);
    return new ImmutablePutOptions(this.cas, newValue, this.release, this.dc);
  }
  
  /**
   * Copy current immutable object by setting present value for optional {@link PutOptions#getRelease() release}.
   * @param value value for release
   * @return modified copy of {@code this} object
   */
  public final ImmutablePutOptions withRelease(String value) {
    Optional<String> newValue = Optional.of(value);
    return new ImmutablePutOptions(this.cas, this.acquire, newValue, this.dc);
  }
  
  /**
   * Copy current immutable object by setting optional value for {@link PutOptions#getRelease() release}.
   * Shallow reference equality check on optional value is used to prevent copying of the same value by returning {@code this}.
   * @param optional value for release
   * @return modified copy of {@code this} object
   */
  public final ImmutablePutOptions withRelease(Optional<String> optional) {
    if (this.release == optional) {
      return this;
    }
    Optional<String> newValue = Preconditions.checkNotNull(optional);
    return new ImmutablePutOptions(this.cas, this.acquire, newValue, this.dc);
  }
  
  /**
   * Copy current immutable object by setting present value for optional {@link PutOptions#getDc() dc}.
   * @param value value for dc
   * @return modified copy of {@code this} object
   */
  public final ImmutablePutOptions withDc(String value) {
    Optional<String> newValue = Optional.of(value);
    return new ImmutablePutOptions(this.cas, this.acquire, this.release, newValue);
  }
  
  /**
   * Copy current immutable object by setting optional value for {@link PutOptions#getDc() dc}.
   * Shallow reference equality check on optional value is used to prevent copying of the same value by returning {@code this}.
   * @param optional value for dc
   * @return modified copy of {@code this} object
   */
  public final ImmutablePutOptions withDc(Optional<String> optional) {
    if (this.dc == optional) {
      return this;
    }
    Optional<String> newValue = Preconditions.checkNotNull(optional);
    return new ImmutablePutOptions(this.cas, this.acquire, this.release, newValue);
  }
  
  /**
   * This instance is equal to instances of {@code ImmutablePutOptions} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    return this == another
        || (another instanceof ImmutablePutOptions && equalTo((ImmutablePutOptions) another));
  }
  
  private boolean equalTo(ImmutablePutOptions another) {
    return cas.equals(another.cas)
        && acquire.equals(another.acquire)
        && release.equals(another.release)
        && dc.equals(another.dc);
  }
  
  /**
   * Computes hash code from attributes: {@code cas}, {@code acquire}, {@code release}, {@code dc}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + cas.hashCode();
    h = h * 17 + acquire.hashCode();
    h = h * 17 + release.hashCode();
    h = h * 17 + dc.hashCode();
    return h;
  }
  
  /**
   * Prints immutable value {@code PutOptions{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("PutOptions")
        .add("cas", cas)
        .add("acquire", acquire)
        .add("release", release)
        .add("dc", dc)
        .toString();
  }
  
  /**
   * Creates immutable copy of {@link PutOptions}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance instance to copy
   * @return copied immutable PutOptions instance
   */
  public static ImmutablePutOptions copyOf(PutOptions instance) {
    if (instance instanceof ImmutablePutOptions) {
      return (ImmutablePutOptions) instance;
    }
    return ImmutablePutOptions.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates builder for {@link com.orbitz.consul.option.ImmutablePutOptions}.
   * @return new ImmutablePutOptions builder
   */
  public static ImmutablePutOptions.Builder builder() {
    return new ImmutablePutOptions.Builder();
  }
  
  /**
   * Builds instances of {@link com.orbitz.consul.option.ImmutablePutOptions}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  public static final class Builder {
  
    private Optional<Integer> cas = Optional.absent();
    private Optional<String> acquire = Optional.absent();
    private Optional<String> release = Optional.absent();
    private Optional<String> dc = Optional.absent();
    private Builder() {}
  
    /**
     * Fill builder with attribute values from provided {@link PutOptions} instance.
     * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
     * Instance's absent optional values will not be copied (will not override current).
     * Collection elements and entries will be added, not replaced.
     * @param instance instance to copy values from
     * @return {@code this} builder for chained invocation
     */
    public final Builder from(PutOptions instance) {
      Preconditions.checkNotNull(instance);
      Optional<Integer> casOptional = instance.getCas();
      if (casOptional.isPresent()) {
        cas(casOptional);
      }
      Optional<String> acquireOptional = instance.getAcquire();
      if (acquireOptional.isPresent()) {
        acquire(acquireOptional);
      }
      Optional<String> releaseOptional = instance.getRelease();
      if (releaseOptional.isPresent()) {
        release(releaseOptional);
      }
      Optional<String> dcOptional = instance.getDc();
      if (dcOptional.isPresent()) {
        dc(dcOptional);
      }
      return this;
    }
  
    /**
     * Initializes present value for optional {@link PutOptions#getCas() cas}.
     * @param cas value for cas
     * @return {@code this} builder for chained invocation
     */
    public final Builder cas(int cas) {
      this.cas = Optional.of(cas);
      return this;
    }
  
    /**
     * Initializes optional value for {@link PutOptions#getCas() cas}.
     * @param cas value for cas
     * @return {@code this} builder for chained invocation
     */
    public final Builder cas(Optional<Integer> cas) {
      this.cas = Preconditions.checkNotNull(cas);
      return this;
    }
  
    /**
     * Initializes present value for optional {@link PutOptions#getAcquire() acquire}.
     * @param acquire value for acquire
     * @return {@code this} builder for chained invocation
     */
    public final Builder acquire(String acquire) {
      this.acquire = Optional.of(acquire);
      return this;
    }
  
    /**
     * Initializes optional value for {@link PutOptions#getAcquire() acquire}.
     * @param acquire value for acquire
     * @return {@code this} builder for chained invocation
     */
    public final Builder acquire(Optional<String> acquire) {
      this.acquire = Preconditions.checkNotNull(acquire);
      return this;
    }
  
    /**
     * Initializes present value for optional {@link PutOptions#getRelease() release}.
     * @param release value for release
     * @return {@code this} builder for chained invocation
     */
    public final Builder release(String release) {
      this.release = Optional.of(release);
      return this;
    }
  
    /**
     * Initializes optional value for {@link PutOptions#getRelease() release}.
     * @param release value for release
     * @return {@code this} builder for chained invocation
     */
    public final Builder release(Optional<String> release) {
      this.release = Preconditions.checkNotNull(release);
      return this;
    }
  
    /**
     * Initializes present value for optional {@link PutOptions#getDc() dc}.
     * @param dc value for dc
     * @return {@code this} builder for chained invocation
     */
    public final Builder dc(String dc) {
      this.dc = Optional.of(dc);
      return this;
    }
  
    /**
     * Initializes optional value for {@link PutOptions#getDc() dc}.
     * @param dc value for dc
     * @return {@code this} builder for chained invocation
     */
    public final Builder dc(Optional<String> dc) {
      this.dc = Preconditions.checkNotNull(dc);
      return this;
    }
  
    /**
     * Builds new {@link com.orbitz.consul.option.ImmutablePutOptions}.
     * @return immutable instance of PutOptions
     */
    public ImmutablePutOptions build() {
      return new ImmutablePutOptions(cas, acquire, release, dc);
    }
  }
}
