package com.orbitz.consul.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.orbitz.consul.model.event.Event;
import java.math.BigInteger;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;

/**
 * Immutable implementation of {@link EventResponse}.
 * <p>
 * Use builder to create immutable instances:
 * {@code ImmutableEventResponse.builder()}.
 * Use static factory method to create immutable instances:
 * {@code ImmutableEventResponse.of()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "EventResponse"})
public final class ImmutableEventResponse extends EventResponse {
  private final ImmutableList<Event> events;
  private final BigInteger index;

  private ImmutableEventResponse(Iterable<? extends Event> events, BigInteger index) {
    this.events = ImmutableList.copyOf(events);
    this.index = Preconditions.checkNotNull(index);
  }

  private ImmutableEventResponse(
      ImmutableEventResponse original,
      ImmutableList<Event> events,
      BigInteger index) {
    this.events = events;
    this.index = index;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code events} attribute
   */
  @JsonProperty("events")
  @Override
  public ImmutableList<Event> getEvents() {
    return events;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code index} attribute
   */
  @JsonProperty("index")
  @Override
  public BigInteger getIndex() {
    return index;
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link EventResponse#getEvents() events}.
   * @param elements elements to set
   * @return modified copy of {@code this} object
   */
  public final ImmutableEventResponse withEvents(Event... elements) {
    ImmutableList<Event> newValue = ImmutableList.copyOf(elements);
    return new ImmutableEventResponse(this, newValue, this.index);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link EventResponse#getEvents() events}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements iterable of events elements to set
   * @return modified copy of {@code this} object
   */
  public final ImmutableEventResponse withEvents(Iterable<? extends Event> elements) {
    if (this.events == elements) {
      return this;
    }
    ImmutableList<Event> newValue = ImmutableList.copyOf(elements);
    return new ImmutableEventResponse(this, newValue, this.index);
  }
  
  /**
   * Copy current immutable object by setting value for {@link EventResponse#getIndex() index}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for index
   * @return modified copy of the {@code this} object
   */
  public final ImmutableEventResponse withIndex(BigInteger value) {
    if (this.index == value) {
      return this;
    }
    BigInteger newValue = Preconditions.checkNotNull(value);
    return new ImmutableEventResponse(this, this.events, newValue);
  }
  
  /**
   * This instance is equal to instances of {@code ImmutableEventResponse} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    return this == another
        || (another instanceof ImmutableEventResponse && equalTo((ImmutableEventResponse) another));
  }
  
  private boolean equalTo(ImmutableEventResponse another) {
    return events.equals(another.events)
        && index.equals(another.index);
  }
  
  /**
   * Computes hash code from attributes: {@code events}, {@code index}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + events.hashCode();
    h = h * 17 + index.hashCode();
    return h;
  }
  
  /**
   * Prints immutable value {@code EventResponse{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("EventResponse")
        .add("events", events)
        .add("index", index)
        .toString();
  }
  
  @JsonCreator
  public static ImmutableEventResponse fromAllAttributes(
      @JsonProperty("events") List<Event> events,
      @JsonProperty("index") BigInteger index) {
    ImmutableEventResponse.Builder builder = ImmutableEventResponse.builder();
    if (events != null) {
      builder.addAllEvents(events);
    }
    if (index != null) {
      builder.index(index);
    }
    return builder.build();
  }

  /**
   * Construct new immutable {@code EventResponse} instance.
   * @param events value for {@code events}
   * @param index value for {@code index}
   * @return immutable EventResponse instance
   */
  public static com.orbitz.consul.model.ImmutableEventResponse of(List<Event> events, BigInteger index) {
    return of((Iterable<? extends Event>) events, index);
  }

  /**
   * Construct new immutable {@code EventResponse} instance.
   * @param events value for {@code events}
   * @param index value for {@code index}
   * @return immutable EventResponse instance
   */
  public static com.orbitz.consul.model.ImmutableEventResponse of(Iterable<? extends Event> events, BigInteger index) {
    return new ImmutableEventResponse(events, index);
  }
  
  /**
   * Creates immutable copy of {@link EventResponse}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance instance to copy
   * @return copied immutable EventResponse instance
   */
  public static ImmutableEventResponse copyOf(EventResponse instance) {
    if (instance instanceof ImmutableEventResponse) {
      return (ImmutableEventResponse) instance;
    }
    return ImmutableEventResponse.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates builder for {@link com.orbitz.consul.model.ImmutableEventResponse}.
   * @return new ImmutableEventResponse builder
   */
  public static ImmutableEventResponse.Builder builder() {
    return new ImmutableEventResponse.Builder();
  }
  
  /**
   * Builds instances of {@link com.orbitz.consul.model.ImmutableEventResponse}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INITIALIZED_BITSET_ALL = 0x1;
    private static final long INITIALIZED_BIT_INDEX = 0x1L;
    private long initializedBitset;
  
    private ImmutableList.Builder<Event> eventsBuilder = ImmutableList.builder();
    private BigInteger index;
    private Builder() {}
  
    /**
     * Fill builder with attribute values from provided {@link EventResponse} instance.
     * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
     * Instance's absent optional values will not be copied (will not override current).
     * Collection elements and entries will be added, not replaced.
     * @param instance instance to copy values from
     * @return {@code this} builder for chained invocation
     */
    public final Builder from(EventResponse instance) {
      Preconditions.checkNotNull(instance);
      addAllEvents(instance.getEvents());
      index(instance.getIndex());
      return this;
    }
  
    /**
     * Adds one element to {@link EventResponse#getEvents() events} list.
     * @param element events element
     * @return {@code this} builder for chained invocation
     */
    public final Builder addEvents(Event element) {
      eventsBuilder.add(element);
      return this;
    }
  
    /**
     * Adds elements to {@link EventResponse#getEvents() events} list.
     * @param elements array of events elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addEvents(Event... elements) {
      eventsBuilder.add(elements);
      return this;
    }
  
    /**
     * Sets or replaces all elements for {@link EventResponse#getEvents() events} list.
     * @param elements iterable of events elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder events(Iterable<? extends Event> elements) {
      eventsBuilder = ImmutableList.builder();
      return addAllEvents(elements);
    }
  
    /**
     * Adds elements to {@link EventResponse#getEvents() events} list.
     * @param elements iterable of events elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addAllEvents(Iterable<? extends Event> elements) {
      eventsBuilder.addAll(elements);
      return this;
    }
  
    /**
     * Initializes value for {@link EventResponse#getIndex() index}.
     * @param index value for index
     * @return {@code this} builder for chained invocation
     */
    public final Builder index(BigInteger index) {
      this.index = Preconditions.checkNotNull(index);
      initializedBitset |= INITIALIZED_BIT_INDEX;
      return this;
    }
  
    /**
     * Builds new {@link com.orbitz.consul.model.ImmutableEventResponse}.
     * @return immutable instance of EventResponse
     */
    public ImmutableEventResponse build() {
      checkRequiredAttributes();
      return new ImmutableEventResponse(null, eventsBuilder.build(), index);
    }
  
    private boolean indexIsSet() {
      return (initializedBitset & INITIALIZED_BIT_INDEX) != 0;
    }
  
    private void checkRequiredAttributes() {
      if (initializedBitset != INITIALIZED_BITSET_ALL) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }
  
    private String formatRequiredAttributesMessage() {
      Collection<String> attributes = Lists.newArrayList();
      if (!indexIsSet()) {
        attributes.add("index");
      }
      return "Cannot build EventResponse, some of required attributes are not set " + attributes;
    }
  }
}
