package com.orbitz.consul.model.session;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.Collection;
import javax.annotation.Generated;

/**
 * Immutable implementation of {@link SessionCreatedResponse}.
 * <p>
 * Use builder to create immutable instances:
 * {@code ImmutableSessionCreatedResponse.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "SessionCreatedResponse"})
public final class ImmutableSessionCreatedResponse
    extends SessionCreatedResponse {
  private final String id;

  private ImmutableSessionCreatedResponse(String id) {
    this.id = id;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code id} attribute
   */
  @JsonProperty("ID")
  @Override
  public String getId() {
    return id;
  }
  
  /**
   * Copy current immutable object by setting value for {@link SessionCreatedResponse#getId() id}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for id
   * @return modified copy of the {@code this} object
   */
  public final ImmutableSessionCreatedResponse withId(String value) {
    if (this.id == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new ImmutableSessionCreatedResponse(newValue);
  }
  
  /**
   * This instance is equal to instances of {@code ImmutableSessionCreatedResponse} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    return this == another
        || (another instanceof ImmutableSessionCreatedResponse && equalTo((ImmutableSessionCreatedResponse) another));
  }
  
  private boolean equalTo(ImmutableSessionCreatedResponse another) {
    return id.equals(another.id);
  }
  
  /**
   * Computes hash code from attributes: {@code id}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + id.hashCode();
    return h;
  }
  
  /**
   * Prints immutable value {@code SessionCreatedResponse{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("SessionCreatedResponse")
        .add("id", id)
        .toString();
  }
  
  @JsonCreator
  public static ImmutableSessionCreatedResponse fromAllAttributes(
      @JsonProperty("ID") String id) {
    ImmutableSessionCreatedResponse.Builder builder = ImmutableSessionCreatedResponse.builder();
    if (id != null) {
      builder.id(id);
    }
    return builder.build();
  }
  
  /**
   * Creates immutable copy of {@link SessionCreatedResponse}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance instance to copy
   * @return copied immutable SessionCreatedResponse instance
   */
  public static ImmutableSessionCreatedResponse copyOf(SessionCreatedResponse instance) {
    if (instance instanceof ImmutableSessionCreatedResponse) {
      return (ImmutableSessionCreatedResponse) instance;
    }
    return ImmutableSessionCreatedResponse.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates builder for {@link com.orbitz.consul.model.session.ImmutableSessionCreatedResponse}.
   * @return new ImmutableSessionCreatedResponse builder
   */
  public static ImmutableSessionCreatedResponse.Builder builder() {
    return new ImmutableSessionCreatedResponse.Builder();
  }
  
  /**
   * Builds instances of {@link com.orbitz.consul.model.session.ImmutableSessionCreatedResponse}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INITIALIZED_BITSET_ALL = 0x1;
    private static final long INITIALIZED_BIT_ID = 0x1L;
    private long initializedBitset;
  
    private String id;
    private Builder() {}
  
    /**
     * Fill builder with attribute values from provided {@link SessionCreatedResponse} instance.
     * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
     * Instance's absent optional values will not be copied (will not override current).
     * Collection elements and entries will be added, not replaced.
     * @param instance instance to copy values from
     * @return {@code this} builder for chained invocation
     */
    public final Builder from(SessionCreatedResponse instance) {
      Preconditions.checkNotNull(instance);
      id(instance.getId());
      return this;
    }
  
    /**
     * Initializes value for {@link SessionCreatedResponse#getId() id}.
     * @param id value for id
     * @return {@code this} builder for chained invocation
     */
    public final Builder id(String id) {
      this.id = Preconditions.checkNotNull(id);
      initializedBitset |= INITIALIZED_BIT_ID;
      return this;
    }
  
    /**
     * Builds new {@link com.orbitz.consul.model.session.ImmutableSessionCreatedResponse}.
     * @return immutable instance of SessionCreatedResponse
     */
    public ImmutableSessionCreatedResponse build() {
      checkRequiredAttributes();
      return new ImmutableSessionCreatedResponse(id);
    }
  
    private boolean idIsSet() {
      return (initializedBitset & INITIALIZED_BIT_ID) != 0;
    }
  
    private void checkRequiredAttributes() {
      if (initializedBitset != INITIALIZED_BITSET_ALL) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }
  
    private String formatRequiredAttributesMessage() {
      Collection<String> attributes = Lists.newArrayList();
      if (!idIsSet()) {
        attributes.add("id");
      }
      return "Cannot build SessionCreatedResponse, some of required attributes are not set " + attributes;
    }
  }
}
