/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.option;

import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.orbitz.consul.option.PutOptions;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutablePutOptions
extends PutOptions {
    private final Optional<Long> cas;
    private final Optional<String> acquire;
    private final Optional<String> release;
    private final Optional<String> dc;
    private final Optional<String> token;

    private ImmutablePutOptions(Optional<Long> cas, Optional<String> acquire, Optional<String> release, Optional<String> dc, Optional<String> token) {
        this.cas = cas;
        this.acquire = acquire;
        this.release = release;
        this.dc = dc;
        this.token = token;
    }

    @Override
    public Optional<Long> getCas() {
        return this.cas;
    }

    @Override
    public Optional<String> getAcquire() {
        return this.acquire;
    }

    @Override
    public Optional<String> getRelease() {
        return this.release;
    }

    @Override
    public Optional<String> getDc() {
        return this.dc;
    }

    @Override
    public Optional<String> getToken() {
        return this.token;
    }

    public final ImmutablePutOptions withCas(long value) {
        Optional newValue = Optional.of((Object)value);
        if (this.cas.equals((Object)newValue)) {
            return this;
        }
        return new ImmutablePutOptions((Optional<Long>)newValue, this.acquire, this.release, this.dc, this.token);
    }

    public final ImmutablePutOptions withCas(Optional<Long> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"cas");
        if (this.cas.equals((Object)value)) {
            return this;
        }
        return new ImmutablePutOptions((Optional<Long>)value, this.acquire, this.release, this.dc, this.token);
    }

    public final ImmutablePutOptions withAcquire(String value) {
        Optional newValue = Optional.of((Object)value);
        if (this.acquire.equals((Object)newValue)) {
            return this;
        }
        return new ImmutablePutOptions(this.cas, (Optional<String>)newValue, this.release, this.dc, this.token);
    }

    public final ImmutablePutOptions withAcquire(Optional<String> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"acquire");
        if (this.acquire.equals((Object)value)) {
            return this;
        }
        return new ImmutablePutOptions(this.cas, (Optional<String>)value, this.release, this.dc, this.token);
    }

    public final ImmutablePutOptions withRelease(String value) {
        Optional newValue = Optional.of((Object)value);
        if (this.release.equals((Object)newValue)) {
            return this;
        }
        return new ImmutablePutOptions(this.cas, this.acquire, (Optional<String>)newValue, this.dc, this.token);
    }

    public final ImmutablePutOptions withRelease(Optional<String> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"release");
        if (this.release.equals((Object)value)) {
            return this;
        }
        return new ImmutablePutOptions(this.cas, this.acquire, (Optional<String>)value, this.dc, this.token);
    }

    public final ImmutablePutOptions withDc(String value) {
        Optional newValue = Optional.of((Object)value);
        if (this.dc.equals((Object)newValue)) {
            return this;
        }
        return new ImmutablePutOptions(this.cas, this.acquire, this.release, (Optional<String>)newValue, this.token);
    }

    public final ImmutablePutOptions withDc(Optional<String> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"dc");
        if (this.dc.equals((Object)value)) {
            return this;
        }
        return new ImmutablePutOptions(this.cas, this.acquire, this.release, (Optional<String>)value, this.token);
    }

    public final ImmutablePutOptions withToken(String value) {
        Optional newValue = Optional.of((Object)value);
        if (this.token.equals((Object)newValue)) {
            return this;
        }
        return new ImmutablePutOptions(this.cas, this.acquire, this.release, this.dc, (Optional<String>)newValue);
    }

    public final ImmutablePutOptions withToken(Optional<String> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"token");
        if (this.token.equals((Object)value)) {
            return this;
        }
        return new ImmutablePutOptions(this.cas, this.acquire, this.release, this.dc, (Optional<String>)value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePutOptions && this.equalTo((ImmutablePutOptions)another);
    }

    private boolean equalTo(ImmutablePutOptions another) {
        return this.cas.equals(another.cas) && this.acquire.equals(another.acquire) && this.release.equals(another.release) && this.dc.equals(another.dc) && this.token.equals(another.token);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.cas.hashCode();
        h = h * 17 + this.acquire.hashCode();
        h = h * 17 + this.release.hashCode();
        h = h * 17 + this.dc.hashCode();
        h = h * 17 + this.token.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"PutOptions").omitNullValues().add("cas", this.cas.orNull()).add("acquire", this.acquire.orNull()).add("release", this.release.orNull()).add("dc", this.dc.orNull()).add("token", this.token.orNull()).toString();
    }

    public static ImmutablePutOptions copyOf(PutOptions instance) {
        if (instance instanceof ImmutablePutOptions) {
            return (ImmutablePutOptions)instance;
        }
        return ImmutablePutOptions.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private Optional<Long> cas = Optional.absent();
        private Optional<String> acquire = Optional.absent();
        private Optional<String> release = Optional.absent();
        private Optional<String> dc = Optional.absent();
        private Optional<String> token = Optional.absent();

        private Builder() {
        }

        public final Builder from(PutOptions instance) {
            Optional<String> tokenOptional;
            Optional<String> dcOptional;
            Optional<String> releaseOptional;
            Optional<String> acquireOptional;
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            Optional<Long> casOptional = instance.getCas();
            if (casOptional.isPresent()) {
                this.cas(casOptional);
            }
            if ((acquireOptional = instance.getAcquire()).isPresent()) {
                this.acquire(acquireOptional);
            }
            if ((releaseOptional = instance.getRelease()).isPresent()) {
                this.release(releaseOptional);
            }
            if ((dcOptional = instance.getDc()).isPresent()) {
                this.dc(dcOptional);
            }
            if ((tokenOptional = instance.getToken()).isPresent()) {
                this.token(tokenOptional);
            }
            return this;
        }

        public final Builder cas(long cas) {
            this.cas = Optional.of((Object)cas);
            return this;
        }

        public final Builder cas(Optional<Long> cas) {
            this.cas = (Optional)Preconditions.checkNotNull(cas, (Object)"cas");
            return this;
        }

        public final Builder acquire(String acquire) {
            this.acquire = Optional.of((Object)acquire);
            return this;
        }

        public final Builder acquire(Optional<String> acquire) {
            this.acquire = (Optional)Preconditions.checkNotNull(acquire, (Object)"acquire");
            return this;
        }

        public final Builder release(String release) {
            this.release = Optional.of((Object)release);
            return this;
        }

        public final Builder release(Optional<String> release) {
            this.release = (Optional)Preconditions.checkNotNull(release, (Object)"release");
            return this;
        }

        public final Builder dc(String dc) {
            this.dc = Optional.of((Object)dc);
            return this;
        }

        public final Builder dc(Optional<String> dc) {
            this.dc = (Optional)Preconditions.checkNotNull(dc, (Object)"dc");
            return this;
        }

        public final Builder token(String token) {
            this.token = Optional.of((Object)token);
            return this;
        }

        public final Builder token(Optional<String> token) {
            this.token = (Optional)Preconditions.checkNotNull(token, (Object)"token");
            return this;
        }

        public ImmutablePutOptions build() {
            return new ImmutablePutOptions(this.cas, this.acquire, this.release, this.dc, this.token);
        }
    }
}

