/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.model.catalog;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.orbitz.consul.model.catalog.CatalogDeregistration;
import com.orbitz.consul.model.catalog.WriteRequest;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@JsonIgnoreProperties(ignoreUnknown=true)
@Immutable
public final class ImmutableCatalogDeregistration
extends CatalogDeregistration {
    private final String datacenter;
    private final String node;
    private final Optional<String> checkId;
    private final Optional<String> serviceId;
    private final Optional<WriteRequest> writeRequest;

    private ImmutableCatalogDeregistration(String datacenter, String node, Optional<String> checkId, Optional<String> serviceId, Optional<WriteRequest> writeRequest) {
        this.datacenter = datacenter;
        this.node = node;
        this.checkId = checkId;
        this.serviceId = serviceId;
        this.writeRequest = writeRequest;
    }

    @Override
    @JsonProperty(value="Datacenter")
    public String datacenter() {
        return this.datacenter;
    }

    @Override
    @JsonProperty(value="Node")
    public String node() {
        return this.node;
    }

    @Override
    @JsonProperty(value="CheckID")
    public Optional<String> checkId() {
        return this.checkId;
    }

    @Override
    @JsonProperty(value="ServiceID")
    public Optional<String> serviceId() {
        return this.serviceId;
    }

    @Override
    @JsonProperty(value="WriteRequest")
    public Optional<WriteRequest> writeRequest() {
        return this.writeRequest;
    }

    public final ImmutableCatalogDeregistration withDatacenter(String value) {
        if (this.datacenter.equals(value)) {
            return this;
        }
        return new ImmutableCatalogDeregistration((String)Preconditions.checkNotNull((Object)value, (Object)"datacenter"), this.node, this.checkId, this.serviceId, this.writeRequest);
    }

    public final ImmutableCatalogDeregistration withNode(String value) {
        if (this.node.equals(value)) {
            return this;
        }
        return new ImmutableCatalogDeregistration(this.datacenter, (String)Preconditions.checkNotNull((Object)value, (Object)"node"), this.checkId, this.serviceId, this.writeRequest);
    }

    public final ImmutableCatalogDeregistration withCheckId(String value) {
        Optional newValue = Optional.of((Object)value);
        if (this.checkId.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableCatalogDeregistration(this.datacenter, this.node, (Optional<String>)newValue, this.serviceId, this.writeRequest);
    }

    public final ImmutableCatalogDeregistration withCheckId(Optional<String> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"checkId");
        if (this.checkId.equals((Object)value)) {
            return this;
        }
        return new ImmutableCatalogDeregistration(this.datacenter, this.node, (Optional<String>)value, this.serviceId, this.writeRequest);
    }

    public final ImmutableCatalogDeregistration withServiceId(String value) {
        Optional newValue = Optional.of((Object)value);
        if (this.serviceId.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableCatalogDeregistration(this.datacenter, this.node, this.checkId, (Optional<String>)newValue, this.writeRequest);
    }

    public final ImmutableCatalogDeregistration withServiceId(Optional<String> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"serviceId");
        if (this.serviceId.equals((Object)value)) {
            return this;
        }
        return new ImmutableCatalogDeregistration(this.datacenter, this.node, this.checkId, (Optional<String>)value, this.writeRequest);
    }

    public final ImmutableCatalogDeregistration withWriteRequest(WriteRequest value) {
        Optional newValue = Optional.of((Object)value);
        if (this.writeRequest.isPresent() && this.writeRequest.get() == value) {
            return this;
        }
        return new ImmutableCatalogDeregistration(this.datacenter, this.node, this.checkId, this.serviceId, (Optional<WriteRequest>)newValue);
    }

    public final ImmutableCatalogDeregistration withWriteRequest(Optional<WriteRequest> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"writeRequest");
        if (!this.writeRequest.isPresent() && !value.isPresent()) {
            return this;
        }
        if (this.writeRequest.isPresent() && value.isPresent() && this.writeRequest.get() == value.get()) {
            return this;
        }
        return new ImmutableCatalogDeregistration(this.datacenter, this.node, this.checkId, this.serviceId, (Optional<WriteRequest>)value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCatalogDeregistration && this.equalTo((ImmutableCatalogDeregistration)another);
    }

    private boolean equalTo(ImmutableCatalogDeregistration another) {
        return this.datacenter.equals(another.datacenter) && this.node.equals(another.node) && this.checkId.equals(another.checkId) && this.serviceId.equals(another.serviceId) && this.writeRequest.equals(another.writeRequest);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.datacenter.hashCode();
        h = h * 17 + this.node.hashCode();
        h = h * 17 + this.checkId.hashCode();
        h = h * 17 + this.serviceId.hashCode();
        h = h * 17 + this.writeRequest.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"CatalogDeregistration").omitNullValues().add("datacenter", (Object)this.datacenter).add("node", (Object)this.node).add("checkId", this.checkId.orNull()).add("serviceId", this.serviceId.orNull()).add("writeRequest", this.writeRequest.orNull()).toString();
    }

    @Deprecated
    @JsonCreator
    static ImmutableCatalogDeregistration fromJson(Json json) {
        Builder builder = ImmutableCatalogDeregistration.builder();
        if (json.datacenter != null) {
            builder.datacenter(json.datacenter);
        }
        if (json.node != null) {
            builder.node(json.node);
        }
        if (json.checkId != null) {
            builder.checkId(json.checkId);
        }
        if (json.serviceId != null) {
            builder.serviceId(json.serviceId);
        }
        if (json.writeRequest != null) {
            builder.writeRequest(json.writeRequest);
        }
        return builder.build();
    }

    public static ImmutableCatalogDeregistration copyOf(CatalogDeregistration instance) {
        if (instance instanceof ImmutableCatalogDeregistration) {
            return (ImmutableCatalogDeregistration)instance;
        }
        return ImmutableCatalogDeregistration.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_DATACENTER = 1L;
        private static final long INIT_BIT_NODE = 2L;
        private long initBits = 3L;
        @Nullable
        private String datacenter;
        @Nullable
        private String node;
        private Optional<String> checkId = Optional.absent();
        private Optional<String> serviceId = Optional.absent();
        private Optional<WriteRequest> writeRequest = Optional.absent();

        private Builder() {
        }

        public final Builder from(CatalogDeregistration instance) {
            Optional<WriteRequest> writeRequestOptional;
            Optional<String> serviceIdOptional;
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.datacenter(instance.datacenter());
            this.node(instance.node());
            Optional<String> checkIdOptional = instance.checkId();
            if (checkIdOptional.isPresent()) {
                this.checkId(checkIdOptional);
            }
            if ((serviceIdOptional = instance.serviceId()).isPresent()) {
                this.serviceId(serviceIdOptional);
            }
            if ((writeRequestOptional = instance.writeRequest()).isPresent()) {
                this.writeRequest(writeRequestOptional);
            }
            return this;
        }

        public final Builder datacenter(String datacenter) {
            this.datacenter = (String)Preconditions.checkNotNull((Object)datacenter, (Object)"datacenter");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder node(String node) {
            this.node = (String)Preconditions.checkNotNull((Object)node, (Object)"node");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder checkId(String checkId) {
            this.checkId = Optional.of((Object)checkId);
            return this;
        }

        public final Builder checkId(Optional<String> checkId) {
            this.checkId = (Optional)Preconditions.checkNotNull(checkId, (Object)"checkId");
            return this;
        }

        public final Builder serviceId(String serviceId) {
            this.serviceId = Optional.of((Object)serviceId);
            return this;
        }

        public final Builder serviceId(Optional<String> serviceId) {
            this.serviceId = (Optional)Preconditions.checkNotNull(serviceId, (Object)"serviceId");
            return this;
        }

        public final Builder writeRequest(WriteRequest writeRequest) {
            this.writeRequest = Optional.of((Object)writeRequest);
            return this;
        }

        public final Builder writeRequest(Optional<WriteRequest> writeRequest) {
            this.writeRequest = (Optional)Preconditions.checkNotNull(writeRequest, (Object)"writeRequest");
            return this;
        }

        public ImmutableCatalogDeregistration build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCatalogDeregistration(this.datacenter, this.node, this.checkId, this.serviceId, this.writeRequest);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("datacenter");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("node");
            }
            return "Cannot build CatalogDeregistration, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    static final class Json
    extends CatalogDeregistration {
        @Nullable
        String datacenter;
        @Nullable
        String node;
        Optional<String> checkId = Optional.absent();
        Optional<String> serviceId = Optional.absent();
        Optional<WriteRequest> writeRequest = Optional.absent();

        Json() {
        }

        @JsonProperty(value="Datacenter")
        public void setDatacenter(String datacenter) {
            this.datacenter = datacenter;
        }

        @JsonProperty(value="Node")
        public void setNode(String node) {
            this.node = node;
        }

        @JsonProperty(value="CheckID")
        public void setCheckId(Optional<String> checkId) {
            this.checkId = checkId;
        }

        @JsonProperty(value="ServiceID")
        public void setServiceId(Optional<String> serviceId) {
            this.serviceId = serviceId;
        }

        @JsonProperty(value="WriteRequest")
        public void setWriteRequest(Optional<WriteRequest> writeRequest) {
            this.writeRequest = writeRequest;
        }

        @Override
        public String datacenter() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String node() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> checkId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> serviceId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<WriteRequest> writeRequest() {
            throw new UnsupportedOperationException();
        }
    }
}

