/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul;

import com.orbitz.consul.async.ConsulResponseCallback;
import com.orbitz.consul.model.ConsulResponse;
import com.orbitz.consul.model.catalog.CatalogDeregistration;
import com.orbitz.consul.model.catalog.CatalogNode;
import com.orbitz.consul.model.catalog.CatalogRegistration;
import com.orbitz.consul.model.catalog.CatalogService;
import com.orbitz.consul.model.health.Node;
import com.orbitz.consul.option.QueryOptions;
import com.orbitz.consul.util.Http;
import java.util.List;
import java.util.Map;
import retrofit2.Call;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.QueryMap;

public class CatalogClient {
    private final Api api;

    CatalogClient(Retrofit retrofit) {
        this.api = (Api)retrofit.create(Api.class);
    }

    public List<String> getDatacenters() {
        return Http.extract(this.api.getDatacenters(), new Integer[0]);
    }

    public ConsulResponse<List<Node>> getNodes() {
        return this.getNodes(QueryOptions.BLANK);
    }

    public ConsulResponse<List<Node>> getNodes(QueryOptions queryOptions) {
        return Http.extractConsulResponse(this.api.getNodes(queryOptions.toQuery(), queryOptions.getTag(), queryOptions.getNodeMeta()), new Integer[0]);
    }

    public void getNodes(QueryOptions queryOptions, ConsulResponseCallback<List<Node>> callback) {
        Http.extractConsulResponse(this.api.getNodes(queryOptions.toQuery(), queryOptions.getTag(), queryOptions.getNodeMeta()), callback, new Integer[0]);
    }

    public ConsulResponse<Map<String, List<String>>> getServices() {
        return this.getServices(QueryOptions.BLANK);
    }

    public ConsulResponse<Map<String, List<String>>> getServices(QueryOptions queryOptions) {
        return Http.extractConsulResponse(this.api.getServices(queryOptions.toQuery(), queryOptions.getTag(), queryOptions.getNodeMeta()), new Integer[0]);
    }

    public ConsulResponse<List<CatalogService>> getService(String service) {
        return this.getService(service, QueryOptions.BLANK);
    }

    public ConsulResponse<List<CatalogService>> getService(String service, QueryOptions queryOptions) {
        return Http.extractConsulResponse(this.api.getService(service, queryOptions.toQuery(), queryOptions.getTag(), queryOptions.getNodeMeta()), new Integer[0]);
    }

    public ConsulResponse<CatalogNode> getNode(String node) {
        return this.getNode(node, QueryOptions.BLANK);
    }

    public ConsulResponse<CatalogNode> getNode(String node, QueryOptions queryOptions) {
        return Http.extractConsulResponse(this.api.getNode(node, queryOptions.toQuery(), queryOptions.getTag(), queryOptions.getNodeMeta()), new Integer[0]);
    }

    public void register(CatalogRegistration registration) {
        Http.handle(this.api.register(registration), new Integer[0]);
    }

    public void deregister(CatalogDeregistration deregistration) {
        Http.handle(this.api.deregister(deregistration), new Integer[0]);
    }

    static interface Api {
        @GET(value="catalog/datacenters")
        public Call<List<String>> getDatacenters();

        @GET(value="catalog/nodes")
        public Call<List<Node>> getNodes(@QueryMap Map<String, Object> var1, @Query(value="tag") List<String> var2, @Query(value="node-meta") List<String> var3);

        @GET(value="catalog/node/{node}")
        public Call<CatalogNode> getNode(@Path(value="node") String var1, @QueryMap Map<String, Object> var2, @Query(value="tag") List<String> var3, @Query(value="node-meta") List<String> var4);

        @GET(value="catalog/services")
        public Call<Map<String, List<String>>> getServices(@QueryMap Map<String, Object> var1, @Query(value="tag") List<String> var2, @Query(value="node-meta") List<String> var3);

        @GET(value="catalog/service/{service}")
        public Call<List<CatalogService>> getService(@Path(value="service") String var1, @QueryMap Map<String, Object> var2, @Query(value="tag") List<String> var3, @Query(value="node-meta") List<String> var4);

        @PUT(value="catalog/register")
        public Call<Void> register(@Body CatalogRegistration var1);

        @PUT(value="catalog/deregister")
        public Call<Void> deregister(@Body CatalogDeregistration var1);
    }
}

