/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.model.health;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.orbitz.consul.model.catalog.TaggedAddresses;
import com.orbitz.consul.model.health.Node;
import java.util.ArrayList;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@JsonIgnoreProperties(ignoreUnknown=true)
@Immutable
public final class ImmutableNode
extends Node {
    private final String node;
    private final String address;
    private final Optional<String> datacenter;
    private final Optional<TaggedAddresses> taggedAddresses;
    private final Optional<Map<String, String>> nodeMeta;

    private ImmutableNode(String node, String address, Optional<String> datacenter, Optional<TaggedAddresses> taggedAddresses, Optional<Map<String, String>> nodeMeta) {
        this.node = node;
        this.address = address;
        this.datacenter = datacenter;
        this.taggedAddresses = taggedAddresses;
        this.nodeMeta = nodeMeta;
    }

    @Override
    @JsonProperty(value="Node")
    public String getNode() {
        return this.node;
    }

    @Override
    @JsonProperty(value="Address")
    public String getAddress() {
        return this.address;
    }

    @Override
    @JsonProperty(value="Datacenter")
    public Optional<String> getDatacenter() {
        return this.datacenter;
    }

    @Override
    @JsonProperty(value="TaggedAddresses")
    public Optional<TaggedAddresses> getTaggedAddresses() {
        return this.taggedAddresses;
    }

    @Override
    @JsonProperty(value="Meta")
    public Optional<Map<String, String>> getNodeMeta() {
        return this.nodeMeta;
    }

    public final ImmutableNode withNode(String value) {
        if (this.node.equals(value)) {
            return this;
        }
        return new ImmutableNode((String)Preconditions.checkNotNull((Object)value, (Object)"node"), this.address, this.datacenter, this.taggedAddresses, this.nodeMeta);
    }

    public final ImmutableNode withAddress(String value) {
        if (this.address.equals(value)) {
            return this;
        }
        return new ImmutableNode(this.node, (String)Preconditions.checkNotNull((Object)value, (Object)"address"), this.datacenter, this.taggedAddresses, this.nodeMeta);
    }

    public final ImmutableNode withDatacenter(String value) {
        Optional newValue = Optional.of((Object)value);
        if (this.datacenter.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableNode(this.node, this.address, (Optional<String>)newValue, this.taggedAddresses, this.nodeMeta);
    }

    public final ImmutableNode withDatacenter(Optional<String> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"datacenter");
        if (this.datacenter.equals((Object)value)) {
            return this;
        }
        return new ImmutableNode(this.node, this.address, (Optional<String>)value, this.taggedAddresses, this.nodeMeta);
    }

    public final ImmutableNode withTaggedAddresses(TaggedAddresses value) {
        Optional newValue = Optional.of((Object)value);
        if (this.taggedAddresses.isPresent() && this.taggedAddresses.get() == value) {
            return this;
        }
        return new ImmutableNode(this.node, this.address, this.datacenter, (Optional<TaggedAddresses>)newValue, this.nodeMeta);
    }

    public final ImmutableNode withTaggedAddresses(Optional<TaggedAddresses> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"taggedAddresses");
        if (!this.taggedAddresses.isPresent() && !value.isPresent()) {
            return this;
        }
        if (this.taggedAddresses.isPresent() && value.isPresent() && this.taggedAddresses.get() == value.get()) {
            return this;
        }
        return new ImmutableNode(this.node, this.address, this.datacenter, (Optional<TaggedAddresses>)value, this.nodeMeta);
    }

    public final ImmutableNode withNodeMeta(Map<String, String> value) {
        Optional newValue = Optional.of(value);
        if (this.nodeMeta.isPresent() && this.nodeMeta.get() == value) {
            return this;
        }
        return new ImmutableNode(this.node, this.address, this.datacenter, this.taggedAddresses, (Optional<Map<String, String>>)newValue);
    }

    public final ImmutableNode withNodeMeta(Optional<Map<String, String>> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"nodeMeta");
        if (!this.nodeMeta.isPresent() && !value.isPresent()) {
            return this;
        }
        if (this.nodeMeta.isPresent() && value.isPresent() && this.nodeMeta.get() == value.get()) {
            return this;
        }
        return new ImmutableNode(this.node, this.address, this.datacenter, this.taggedAddresses, (Optional<Map<String, String>>)value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableNode && this.equalTo((ImmutableNode)another);
    }

    private boolean equalTo(ImmutableNode another) {
        return this.node.equals(another.node) && this.address.equals(another.address) && this.datacenter.equals(another.datacenter) && this.taggedAddresses.equals(another.taggedAddresses) && this.nodeMeta.equals(another.nodeMeta);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.node.hashCode();
        h = h * 17 + this.address.hashCode();
        h = h * 17 + this.datacenter.hashCode();
        h = h * 17 + this.taggedAddresses.hashCode();
        h = h * 17 + this.nodeMeta.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Node").omitNullValues().add("node", (Object)this.node).add("address", (Object)this.address).add("datacenter", this.datacenter.orNull()).add("taggedAddresses", this.taggedAddresses.orNull()).add("nodeMeta", this.nodeMeta.orNull()).toString();
    }

    @Deprecated
    @JsonCreator
    static ImmutableNode fromJson(Json json) {
        Builder builder = ImmutableNode.builder();
        if (json.node != null) {
            builder.node(json.node);
        }
        if (json.address != null) {
            builder.address(json.address);
        }
        if (json.datacenter != null) {
            builder.datacenter(json.datacenter);
        }
        if (json.taggedAddresses != null) {
            builder.taggedAddresses(json.taggedAddresses);
        }
        if (json.nodeMeta != null) {
            builder.nodeMeta(json.nodeMeta);
        }
        return builder.build();
    }

    public static ImmutableNode copyOf(Node instance) {
        if (instance instanceof ImmutableNode) {
            return (ImmutableNode)instance;
        }
        return ImmutableNode.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NODE = 1L;
        private static final long INIT_BIT_ADDRESS = 2L;
        private long initBits = 3L;
        @Nullable
        private String node;
        @Nullable
        private String address;
        private Optional<String> datacenter = Optional.absent();
        private Optional<TaggedAddresses> taggedAddresses = Optional.absent();
        private Optional<Map<String, String>> nodeMeta = Optional.absent();

        private Builder() {
        }

        public final Builder from(Node instance) {
            Optional<Map<String, String>> nodeMetaOptional;
            Optional<TaggedAddresses> taggedAddressesOptional;
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.node(instance.getNode());
            this.address(instance.getAddress());
            Optional<String> datacenterOptional = instance.getDatacenter();
            if (datacenterOptional.isPresent()) {
                this.datacenter(datacenterOptional);
            }
            if ((taggedAddressesOptional = instance.getTaggedAddresses()).isPresent()) {
                this.taggedAddresses(taggedAddressesOptional);
            }
            if ((nodeMetaOptional = instance.getNodeMeta()).isPresent()) {
                this.nodeMeta(nodeMetaOptional);
            }
            return this;
        }

        public final Builder node(String node) {
            this.node = (String)Preconditions.checkNotNull((Object)node, (Object)"node");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder address(String address) {
            this.address = (String)Preconditions.checkNotNull((Object)address, (Object)"address");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder datacenter(String datacenter) {
            this.datacenter = Optional.of((Object)datacenter);
            return this;
        }

        public final Builder datacenter(Optional<String> datacenter) {
            this.datacenter = (Optional)Preconditions.checkNotNull(datacenter, (Object)"datacenter");
            return this;
        }

        public final Builder taggedAddresses(TaggedAddresses taggedAddresses) {
            this.taggedAddresses = Optional.of((Object)taggedAddresses);
            return this;
        }

        public final Builder taggedAddresses(Optional<TaggedAddresses> taggedAddresses) {
            this.taggedAddresses = (Optional)Preconditions.checkNotNull(taggedAddresses, (Object)"taggedAddresses");
            return this;
        }

        public final Builder nodeMeta(Map<String, String> nodeMeta) {
            this.nodeMeta = Optional.of(nodeMeta);
            return this;
        }

        public final Builder nodeMeta(Optional<Map<String, String>> nodeMeta) {
            this.nodeMeta = (Optional)Preconditions.checkNotNull(nodeMeta, (Object)"nodeMeta");
            return this;
        }

        public ImmutableNode build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableNode(this.node, this.address, this.datacenter, this.taggedAddresses, this.nodeMeta);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("node");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("address");
            }
            return "Cannot build Node, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    static final class Json
    extends Node {
        @Nullable
        String node;
        @Nullable
        String address;
        Optional<String> datacenter = Optional.absent();
        Optional<TaggedAddresses> taggedAddresses = Optional.absent();
        Optional<Map<String, String>> nodeMeta = Optional.absent();

        Json() {
        }

        @JsonProperty(value="Node")
        public void setNode(String node) {
            this.node = node;
        }

        @JsonProperty(value="Address")
        public void setAddress(String address) {
            this.address = address;
        }

        @JsonProperty(value="Datacenter")
        public void setDatacenter(Optional<String> datacenter) {
            this.datacenter = datacenter;
        }

        @JsonProperty(value="TaggedAddresses")
        public void setTaggedAddresses(Optional<TaggedAddresses> taggedAddresses) {
            this.taggedAddresses = taggedAddresses;
        }

        @JsonProperty(value="Meta")
        public void setNodeMeta(Optional<Map<String, String>> nodeMeta) {
            this.nodeMeta = nodeMeta;
        }

        @Override
        public String getNode() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getAddress() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getDatacenter() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<TaggedAddresses> getTaggedAddresses() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Map<String, String>> getNodeMeta() {
            throw new UnsupportedOperationException();
        }
    }
}

