package com.orbitz.consul.option;

import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.primitives.Booleans;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link QueryOptions}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableQueryOptions.builder()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "QueryOptions"})
@Immutable
public final class ImmutableQueryOptions extends QueryOptions {
  private final Optional<String> wait;
  private final Optional<String> token;
  private final Optional<BigInteger> index;
  private final Optional<String> near;
  private final Optional<String> datacenter;
  private final ImmutableList<String> nodeMeta;
  private final ImmutableList<String> tag;
  private final ConsistencyMode consistencyMode;
  private final boolean isBlocking;
  private final boolean hasToken;
  private final List<String> nodeMetaQuery;
  private final List<String> tagsQuery;

  private ImmutableQueryOptions(ImmutableQueryOptions.Builder builder) {
    this.wait = builder.wait;
    this.token = builder.token;
    this.index = builder.index;
    this.near = builder.near;
    this.datacenter = builder.datacenter;
    this.nodeMeta = builder.nodeMetaBuilder.build();
    this.tag = builder.tagBuilder.build();
    if (builder.consistencyMode != null) {
      initShim.consistencyMode(builder.consistencyMode);
    }
    this.consistencyMode = initShim.getConsistencyMode();
    this.isBlocking = initShim.isBlocking();
    this.hasToken = initShim.hasToken();
    this.nodeMetaQuery = initShim.getNodeMetaQuery();
    this.tagsQuery = initShim.getTagsQuery();
    this.initShim = null;
  }

  private ImmutableQueryOptions(
      Optional<String> wait,
      Optional<String> token,
      Optional<BigInteger> index,
      Optional<String> near,
      Optional<String> datacenter,
      ImmutableList<String> nodeMeta,
      ImmutableList<String> tag,
      ConsistencyMode consistencyMode) {
    this.wait = wait;
    this.token = token;
    this.index = index;
    this.near = near;
    this.datacenter = datacenter;
    this.nodeMeta = nodeMeta;
    this.tag = tag;
    this.consistencyMode = consistencyMode;
    initShim.consistencyMode(consistencyMode);
    this.isBlocking = initShim.isBlocking();
    this.hasToken = initShim.hasToken();
    this.nodeMetaQuery = initShim.getNodeMetaQuery();
    this.tagsQuery = initShim.getTagsQuery();
    this.initShim = null;
  }

  private static final int STAGE_INITIALIZING = -1;
  private static final int STAGE_UNINITIALIZED = 0;
  private static final int STAGE_INITIALIZED = 1;
  private transient volatile InitShim initShim = new InitShim();

  private final class InitShim {
    private ConsistencyMode consistencyMode;
    private byte consistencyModeStage;

    ConsistencyMode getConsistencyMode() {
      if (consistencyModeStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (consistencyModeStage == STAGE_UNINITIALIZED) {
        consistencyModeStage = STAGE_INITIALIZING;
        this.consistencyMode = Preconditions.checkNotNull(ImmutableQueryOptions.super.getConsistencyMode(), "consistencyMode");
        consistencyModeStage = STAGE_INITIALIZED;
      }
      return consistencyMode;
    }

    ConsistencyMode consistencyMode(ConsistencyMode value) {
      this.consistencyMode = value;
      consistencyModeStage = STAGE_INITIALIZED;
      return value;
    }
    private boolean isBlocking;
    private byte isBlockingStage;

    boolean isBlocking() {
      if (isBlockingStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (isBlockingStage == STAGE_UNINITIALIZED) {
        isBlockingStage = STAGE_INITIALIZING;
        this.isBlocking = ImmutableQueryOptions.super.isBlocking();
        isBlockingStage = STAGE_INITIALIZED;
      }
      return isBlocking;
    }
    private boolean hasToken;
    private byte hasTokenStage;

    boolean hasToken() {
      if (hasTokenStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (hasTokenStage == STAGE_UNINITIALIZED) {
        hasTokenStage = STAGE_INITIALIZING;
        this.hasToken = ImmutableQueryOptions.super.hasToken();
        hasTokenStage = STAGE_INITIALIZED;
      }
      return hasToken;
    }
    private List<String> nodeMetaQuery;
    private byte nodeMetaQueryStage;

    List<String> getNodeMetaQuery() {
      if (nodeMetaQueryStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (nodeMetaQueryStage == STAGE_UNINITIALIZED) {
        nodeMetaQueryStage = STAGE_INITIALIZING;
        this.nodeMetaQuery = Preconditions.checkNotNull(ImmutableQueryOptions.super.getNodeMetaQuery(), "nodeMetaQuery");
        nodeMetaQueryStage = STAGE_INITIALIZED;
      }
      return nodeMetaQuery;
    }
    private List<String> tagsQuery;
    private byte tagsQueryStage;

    List<String> getTagsQuery() {
      if (tagsQueryStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (tagsQueryStage == STAGE_UNINITIALIZED) {
        tagsQueryStage = STAGE_INITIALIZING;
        this.tagsQuery = Preconditions.checkNotNull(ImmutableQueryOptions.super.getTagsQuery(), "tagsQuery");
        tagsQueryStage = STAGE_INITIALIZED;
      }
      return tagsQuery;
    }

    private String formatInitCycleMessage() {
      ArrayList<String> attributes = Lists.newArrayList();
      if (consistencyModeStage == STAGE_INITIALIZING) attributes.add("consistencyMode");
      if (isBlockingStage == STAGE_INITIALIZING) attributes.add("isBlocking");
      if (hasTokenStage == STAGE_INITIALIZING) attributes.add("hasToken");
      if (nodeMetaQueryStage == STAGE_INITIALIZING) attributes.add("nodeMetaQuery");
      if (tagsQueryStage == STAGE_INITIALIZING) attributes.add("tagsQuery");
      return "Cannot build QueryOptions, attribute initializers form cycle" + attributes;
    }
  }

  /**
   * @return The value of the {@code wait} attribute
   */
  @Override
  public Optional<String> getWait() {
    return wait;
  }

  /**
   * @return The value of the {@code token} attribute
   */
  @Override
  public Optional<String> getToken() {
    return token;
  }

  /**
   * @return The value of the {@code index} attribute
   */
  @Override
  public Optional<BigInteger> getIndex() {
    return index;
  }

  /**
   * @return The value of the {@code near} attribute
   */
  @Override
  public Optional<String> getNear() {
    return near;
  }

  /**
   * @return The value of the {@code datacenter} attribute
   */
  @Override
  public Optional<String> getDatacenter() {
    return datacenter;
  }

  /**
   * @return The value of the {@code nodeMeta} attribute
   */
  @Override
  public ImmutableList<String> getNodeMeta() {
    return nodeMeta;
  }

  /**
   * @return The value of the {@code tag} attribute
   */
  @Override
  public ImmutableList<String> getTag() {
    return tag;
  }

  /**
   * @return The value of the {@code consistencyMode} attribute
   */
  @Override
  public ConsistencyMode getConsistencyMode() {
    return initShim != null
        ? initShim.getConsistencyMode()
        : consistencyMode;
  }

  /**
   * @return The computed-at-construction value of the {@code isBlocking} attribute
   */
  @Override
  public boolean isBlocking() {
    return initShim != null
        ? initShim.isBlocking()
        : isBlocking;
  }

  /**
   * @return The computed-at-construction value of the {@code hasToken} attribute
   */
  @Override
  public boolean hasToken() {
    return initShim != null
        ? initShim.hasToken()
        : hasToken;
  }

  /**
   * @return The computed-at-construction value of the {@code nodeMetaQuery} attribute
   */
  @Override
  public List<String> getNodeMetaQuery() {
    return initShim != null
        ? initShim.getNodeMetaQuery()
        : nodeMetaQuery;
  }

  /**
   * @return The computed-at-construction value of the {@code tagsQuery} attribute
   */
  @Override
  public List<String> getTagsQuery() {
    return initShim != null
        ? initShim.getTagsQuery()
        : tagsQuery;
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link QueryOptions#getWait() wait} attribute.
   * @param value The value for wait
   * @return A modified copy of {@code this} object
   */
  public final ImmutableQueryOptions withWait(String value) {
    Optional<String> newValue = Optional.of(value);
    if (this.wait.equals(newValue)) return this;
    return validate(new ImmutableQueryOptions(
        newValue,
        this.token,
        this.index,
        this.near,
        this.datacenter,
        this.nodeMeta,
        this.tag,
        this.consistencyMode));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link QueryOptions#getWait() wait} attribute.
   * An equality check is used to prevent copying of the same value by returning {@code this}.
   * @param optional A value for wait
   * @return A modified copy of {@code this} object
   */
  public final ImmutableQueryOptions withWait(Optional<String> optional) {
    Optional<String> value = Preconditions.checkNotNull(optional, "wait");
    if (this.wait.equals(value)) return this;
    return validate(new ImmutableQueryOptions(
        value,
        this.token,
        this.index,
        this.near,
        this.datacenter,
        this.nodeMeta,
        this.tag,
        this.consistencyMode));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link QueryOptions#getToken() token} attribute.
   * @param value The value for token
   * @return A modified copy of {@code this} object
   */
  public final ImmutableQueryOptions withToken(String value) {
    Optional<String> newValue = Optional.of(value);
    if (this.token.equals(newValue)) return this;
    return validate(new ImmutableQueryOptions(
        this.wait,
        newValue,
        this.index,
        this.near,
        this.datacenter,
        this.nodeMeta,
        this.tag,
        this.consistencyMode));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link QueryOptions#getToken() token} attribute.
   * An equality check is used to prevent copying of the same value by returning {@code this}.
   * @param optional A value for token
   * @return A modified copy of {@code this} object
   */
  public final ImmutableQueryOptions withToken(Optional<String> optional) {
    Optional<String> value = Preconditions.checkNotNull(optional, "token");
    if (this.token.equals(value)) return this;
    return validate(new ImmutableQueryOptions(
        this.wait,
        value,
        this.index,
        this.near,
        this.datacenter,
        this.nodeMeta,
        this.tag,
        this.consistencyMode));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link QueryOptions#getIndex() index} attribute.
   * @param value The value for index
   * @return A modified copy of {@code this} object
   */
  public final ImmutableQueryOptions withIndex(BigInteger value) {
    Optional<BigInteger> newValue = Optional.of(value);
    if (this.index.isPresent() && this.index.get() == value) return this;
    return validate(new ImmutableQueryOptions(
        this.wait,
        this.token,
        newValue,
        this.near,
        this.datacenter,
        this.nodeMeta,
        this.tag,
        this.consistencyMode));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link QueryOptions#getIndex() index} attribute.
   * A shallow reference equality check on the optional value is used to prevent copying of the same value by returning {@code this}.
   * @param optional A value for index
   * @return A modified copy of {@code this} object
   */
  public final ImmutableQueryOptions withIndex(Optional<BigInteger> optional) {
    Optional<BigInteger> value = Preconditions.checkNotNull(optional, "index");
    if (!this.index.isPresent() && !value.isPresent()) return this;
    if (this.index.isPresent() && value.isPresent() && this.index.get() == value.get()) return this;
    return validate(new ImmutableQueryOptions(
        this.wait,
        this.token,
        value,
        this.near,
        this.datacenter,
        this.nodeMeta,
        this.tag,
        this.consistencyMode));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link QueryOptions#getNear() near} attribute.
   * @param value The value for near
   * @return A modified copy of {@code this} object
   */
  public final ImmutableQueryOptions withNear(String value) {
    Optional<String> newValue = Optional.of(value);
    if (this.near.equals(newValue)) return this;
    return validate(new ImmutableQueryOptions(
        this.wait,
        this.token,
        this.index,
        newValue,
        this.datacenter,
        this.nodeMeta,
        this.tag,
        this.consistencyMode));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link QueryOptions#getNear() near} attribute.
   * An equality check is used to prevent copying of the same value by returning {@code this}.
   * @param optional A value for near
   * @return A modified copy of {@code this} object
   */
  public final ImmutableQueryOptions withNear(Optional<String> optional) {
    Optional<String> value = Preconditions.checkNotNull(optional, "near");
    if (this.near.equals(value)) return this;
    return validate(new ImmutableQueryOptions(
        this.wait,
        this.token,
        this.index,
        value,
        this.datacenter,
        this.nodeMeta,
        this.tag,
        this.consistencyMode));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link QueryOptions#getDatacenter() datacenter} attribute.
   * @param value The value for datacenter
   * @return A modified copy of {@code this} object
   */
  public final ImmutableQueryOptions withDatacenter(String value) {
    Optional<String> newValue = Optional.of(value);
    if (this.datacenter.equals(newValue)) return this;
    return validate(new ImmutableQueryOptions(
        this.wait,
        this.token,
        this.index,
        this.near,
        newValue,
        this.nodeMeta,
        this.tag,
        this.consistencyMode));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link QueryOptions#getDatacenter() datacenter} attribute.
   * An equality check is used to prevent copying of the same value by returning {@code this}.
   * @param optional A value for datacenter
   * @return A modified copy of {@code this} object
   */
  public final ImmutableQueryOptions withDatacenter(Optional<String> optional) {
    Optional<String> value = Preconditions.checkNotNull(optional, "datacenter");
    if (this.datacenter.equals(value)) return this;
    return validate(new ImmutableQueryOptions(
        this.wait,
        this.token,
        this.index,
        this.near,
        value,
        this.nodeMeta,
        this.tag,
        this.consistencyMode));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link QueryOptions#getNodeMeta() nodeMeta}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableQueryOptions withNodeMeta(String... elements) {
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return validate(new ImmutableQueryOptions(
        this.wait,
        this.token,
        this.index,
        this.near,
        this.datacenter,
        newValue,
        this.tag,
        this.consistencyMode));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link QueryOptions#getNodeMeta() nodeMeta}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of nodeMeta elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableQueryOptions withNodeMeta(Iterable<String> elements) {
    if (this.nodeMeta == elements) return this;
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return validate(new ImmutableQueryOptions(
        this.wait,
        this.token,
        this.index,
        this.near,
        this.datacenter,
        newValue,
        this.tag,
        this.consistencyMode));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link QueryOptions#getTag() tag}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableQueryOptions withTag(String... elements) {
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return validate(new ImmutableQueryOptions(
        this.wait,
        this.token,
        this.index,
        this.near,
        this.datacenter,
        this.nodeMeta,
        newValue,
        this.consistencyMode));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link QueryOptions#getTag() tag}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of tag elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableQueryOptions withTag(Iterable<String> elements) {
    if (this.tag == elements) return this;
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return validate(new ImmutableQueryOptions(
        this.wait,
        this.token,
        this.index,
        this.near,
        this.datacenter,
        this.nodeMeta,
        newValue,
        this.consistencyMode));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link QueryOptions#getConsistencyMode() consistencyMode} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for consistencyMode
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableQueryOptions withConsistencyMode(ConsistencyMode value) {
    if (this.consistencyMode == value) return this;
    return validate(new ImmutableQueryOptions(
        this.wait,
        this.token,
        this.index,
        this.near,
        this.datacenter,
        this.nodeMeta,
        this.tag,
        Preconditions.checkNotNull(value, "consistencyMode")));
  }

  /**
   * This instance is equal to all instances of {@code ImmutableQueryOptions} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableQueryOptions
        && equalTo((ImmutableQueryOptions) another);
  }

  private boolean equalTo(ImmutableQueryOptions another) {
    return wait.equals(another.wait)
        && token.equals(another.token)
        && index.equals(another.index)
        && near.equals(another.near)
        && datacenter.equals(another.datacenter)
        && nodeMeta.equals(another.nodeMeta)
        && tag.equals(another.tag)
        && consistencyMode.equals(another.consistencyMode)
        && isBlocking == another.isBlocking
        && hasToken == another.hasToken
        && nodeMetaQuery.equals(another.nodeMetaQuery)
        && tagsQuery.equals(another.tagsQuery);
  }

  /**
   * Computes a hash code from attributes: {@code wait}, {@code token}, {@code index}, {@code near}, {@code datacenter}, {@code nodeMeta}, {@code tag}, {@code consistencyMode}, {@code isBlocking}, {@code hasToken}, {@code nodeMetaQuery}, {@code tagsQuery}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + wait.hashCode();
    h = h * 17 + token.hashCode();
    h = h * 17 + index.hashCode();
    h = h * 17 + near.hashCode();
    h = h * 17 + datacenter.hashCode();
    h = h * 17 + nodeMeta.hashCode();
    h = h * 17 + tag.hashCode();
    h = h * 17 + consistencyMode.hashCode();
    h = h * 17 + Booleans.hashCode(isBlocking);
    h = h * 17 + Booleans.hashCode(hasToken);
    h = h * 17 + nodeMetaQuery.hashCode();
    h = h * 17 + tagsQuery.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code QueryOptions} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("QueryOptions")
        .omitNullValues()
        .add("wait", wait.orNull())
        .add("token", token.orNull())
        .add("index", index.orNull())
        .add("near", near.orNull())
        .add("datacenter", datacenter.orNull())
        .add("nodeMeta", nodeMeta)
        .add("tag", tag)
        .add("consistencyMode", consistencyMode)
        .add("isBlocking", isBlocking)
        .add("hasToken", hasToken)
        .add("nodeMetaQuery", nodeMetaQuery)
        .add("tagsQuery", tagsQuery)
        .toString();
  }

  private static ImmutableQueryOptions validate(ImmutableQueryOptions instance) {
    instance.validate();
    return instance;
  }

  /**
   * Creates an immutable copy of a {@link QueryOptions} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable QueryOptions instance
   */
  public static ImmutableQueryOptions copyOf(QueryOptions instance) {
    if (instance instanceof ImmutableQueryOptions) {
      return (ImmutableQueryOptions) instance;
    }
    return ImmutableQueryOptions.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableQueryOptions ImmutableQueryOptions}.
   * @return A new ImmutableQueryOptions builder
   */
  public static ImmutableQueryOptions.Builder builder() {
    return new ImmutableQueryOptions.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableQueryOptions ImmutableQueryOptions}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private Optional<String> wait = Optional.absent();
    private Optional<String> token = Optional.absent();
    private Optional<BigInteger> index = Optional.absent();
    private Optional<String> near = Optional.absent();
    private Optional<String> datacenter = Optional.absent();
    private ImmutableList.Builder<String> nodeMetaBuilder = ImmutableList.builder();
    private ImmutableList.Builder<String> tagBuilder = ImmutableList.builder();
    private @Nullable ConsistencyMode consistencyMode;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code QueryOptions} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(QueryOptions instance) {
      Preconditions.checkNotNull(instance, "instance");
      Optional<String> waitOptional = instance.getWait();
      if (waitOptional.isPresent()) {
        wait(waitOptional);
      }
      Optional<String> tokenOptional = instance.getToken();
      if (tokenOptional.isPresent()) {
        token(tokenOptional);
      }
      Optional<BigInteger> indexOptional = instance.getIndex();
      if (indexOptional.isPresent()) {
        index(indexOptional);
      }
      Optional<String> nearOptional = instance.getNear();
      if (nearOptional.isPresent()) {
        near(nearOptional);
      }
      Optional<String> datacenterOptional = instance.getDatacenter();
      if (datacenterOptional.isPresent()) {
        datacenter(datacenterOptional);
      }
      addAllNodeMeta(instance.getNodeMeta());
      addAllTag(instance.getTag());
      consistencyMode(instance.getConsistencyMode());
      return this;
    }

    /**
     * Initializes the optional value {@link QueryOptions#getWait() wait} to wait.
     * @param wait The value for wait
     * @return {@code this} builder for chained invocation
     */
    public final Builder wait(String wait) {
      this.wait = Optional.of(wait);
      return this;
    }

    /**
     * Initializes the optional value {@link QueryOptions#getWait() wait} to wait.
     * @param wait The value for wait
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder wait(Optional<String> wait) {
      this.wait = Preconditions.checkNotNull(wait, "wait");
      return this;
    }

    /**
     * Initializes the optional value {@link QueryOptions#getToken() token} to token.
     * @param token The value for token
     * @return {@code this} builder for chained invocation
     */
    public final Builder token(String token) {
      this.token = Optional.of(token);
      return this;
    }

    /**
     * Initializes the optional value {@link QueryOptions#getToken() token} to token.
     * @param token The value for token
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder token(Optional<String> token) {
      this.token = Preconditions.checkNotNull(token, "token");
      return this;
    }

    /**
     * Initializes the optional value {@link QueryOptions#getIndex() index} to index.
     * @param index The value for index
     * @return {@code this} builder for chained invocation
     */
    public final Builder index(BigInteger index) {
      this.index = Optional.of(index);
      return this;
    }

    /**
     * Initializes the optional value {@link QueryOptions#getIndex() index} to index.
     * @param index The value for index
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder index(Optional<BigInteger> index) {
      this.index = Preconditions.checkNotNull(index, "index");
      return this;
    }

    /**
     * Initializes the optional value {@link QueryOptions#getNear() near} to near.
     * @param near The value for near
     * @return {@code this} builder for chained invocation
     */
    public final Builder near(String near) {
      this.near = Optional.of(near);
      return this;
    }

    /**
     * Initializes the optional value {@link QueryOptions#getNear() near} to near.
     * @param near The value for near
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder near(Optional<String> near) {
      this.near = Preconditions.checkNotNull(near, "near");
      return this;
    }

    /**
     * Initializes the optional value {@link QueryOptions#getDatacenter() datacenter} to datacenter.
     * @param datacenter The value for datacenter
     * @return {@code this} builder for chained invocation
     */
    public final Builder datacenter(String datacenter) {
      this.datacenter = Optional.of(datacenter);
      return this;
    }

    /**
     * Initializes the optional value {@link QueryOptions#getDatacenter() datacenter} to datacenter.
     * @param datacenter The value for datacenter
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder datacenter(Optional<String> datacenter) {
      this.datacenter = Preconditions.checkNotNull(datacenter, "datacenter");
      return this;
    }

    /**
     * Adds one element to {@link QueryOptions#getNodeMeta() nodeMeta} list.
     * @param element A nodeMeta element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addNodeMeta(String element) {
      nodeMetaBuilder.add(element);
      return this;
    }

    /**
     * Adds elements to {@link QueryOptions#getNodeMeta() nodeMeta} list.
     * @param elements An array of nodeMeta elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addNodeMeta(String... elements) {
      nodeMetaBuilder.add(elements);
      return this;
    }

    /**
     * Sets or replaces all elements for {@link QueryOptions#getNodeMeta() nodeMeta} list.
     * @param elements An iterable of nodeMeta elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder nodeMeta(Iterable<String> elements) {
      nodeMetaBuilder = ImmutableList.builder();
      return addAllNodeMeta(elements);
    }

    /**
     * Adds elements to {@link QueryOptions#getNodeMeta() nodeMeta} list.
     * @param elements An iterable of nodeMeta elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllNodeMeta(Iterable<String> elements) {
      nodeMetaBuilder.addAll(elements);
      return this;
    }

    /**
     * Adds one element to {@link QueryOptions#getTag() tag} list.
     * @param element A tag element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addTag(String element) {
      tagBuilder.add(element);
      return this;
    }

    /**
     * Adds elements to {@link QueryOptions#getTag() tag} list.
     * @param elements An array of tag elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addTag(String... elements) {
      tagBuilder.add(elements);
      return this;
    }

    /**
     * Sets or replaces all elements for {@link QueryOptions#getTag() tag} list.
     * @param elements An iterable of tag elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder tag(Iterable<String> elements) {
      tagBuilder = ImmutableList.builder();
      return addAllTag(elements);
    }

    /**
     * Adds elements to {@link QueryOptions#getTag() tag} list.
     * @param elements An iterable of tag elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllTag(Iterable<String> elements) {
      tagBuilder.addAll(elements);
      return this;
    }

    /**
     * Initializes the value for the {@link QueryOptions#getConsistencyMode() consistencyMode} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link QueryOptions#getConsistencyMode() consistencyMode}.</em>
     * @param consistencyMode The value for consistencyMode 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder consistencyMode(ConsistencyMode consistencyMode) {
      this.consistencyMode = Preconditions.checkNotNull(consistencyMode, "consistencyMode");
      return this;
    }

    /**
     * Builds a new {@link ImmutableQueryOptions ImmutableQueryOptions}.
     * @return An immutable instance of QueryOptions
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableQueryOptions build() {
      return ImmutableQueryOptions.validate(new ImmutableQueryOptions(this));
    }
  }
}
