package com.orbitz.consul.model.session;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link SessionCreatedResponse}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableSessionCreatedResponse.builder()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "SessionCreatedResponse"})
@Immutable
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ImmutableSessionCreatedResponse
    extends SessionCreatedResponse {
  private final String id;

  private ImmutableSessionCreatedResponse(String id) {
    this.id = id;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty(value = "ID")
  @Override
  public String getId() {
    return id;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SessionCreatedResponse#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSessionCreatedResponse withId(String value) {
    if (this.id.equals(value)) return this;
    return new ImmutableSessionCreatedResponse(Preconditions.checkNotNull(value, "id"));
  }

  /**
   * This instance is equal to all instances of {@code ImmutableSessionCreatedResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableSessionCreatedResponse
        && equalTo((ImmutableSessionCreatedResponse) another);
  }

  private boolean equalTo(ImmutableSessionCreatedResponse another) {
    return id.equals(another.id);
  }

  /**
   * Computes a hash code from attributes: {@code id}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + id.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code SessionCreatedResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("SessionCreatedResponse")
        .omitNullValues()
        .add("id", id)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  static final class Json extends SessionCreatedResponse {
    @Nullable String id;
    @JsonProperty(value = "ID")
    public void setId(String id) {
      this.id = id;
    }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static ImmutableSessionCreatedResponse fromJson(Json json) {
    ImmutableSessionCreatedResponse.Builder builder = ImmutableSessionCreatedResponse.builder();
    if (json.id != null) {
      builder.id(json.id);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link SessionCreatedResponse} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable SessionCreatedResponse instance
   */
  public static ImmutableSessionCreatedResponse copyOf(SessionCreatedResponse instance) {
    if (instance instanceof ImmutableSessionCreatedResponse) {
      return (ImmutableSessionCreatedResponse) instance;
    }
    return ImmutableSessionCreatedResponse.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableSessionCreatedResponse ImmutableSessionCreatedResponse}.
   * @return A new ImmutableSessionCreatedResponse builder
   */
  public static ImmutableSessionCreatedResponse.Builder builder() {
    return new ImmutableSessionCreatedResponse.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableSessionCreatedResponse ImmutableSessionCreatedResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private long initBits = 0x1;

    private @Nullable String id;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code SessionCreatedResponse} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SessionCreatedResponse instance) {
      Preconditions.checkNotNull(instance, "instance");
      id(instance.getId());
      return this;
    }

    /**
     * Initializes the value for the {@link SessionCreatedResponse#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder id(String id) {
      this.id = Preconditions.checkNotNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Builds a new {@link ImmutableSessionCreatedResponse ImmutableSessionCreatedResponse}.
     * @return An immutable instance of SessionCreatedResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableSessionCreatedResponse build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableSessionCreatedResponse(id);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = Lists.newArrayList();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      return "Cannot build SessionCreatedResponse, some of required attributes are not set " + attributes;
    }
  }
}
