package com.orbitz.consul.model.event;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.orbitz.consul.util.Base64EncodingDeserializer;
import java.util.List;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link Event}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableEvent.builder()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "Event"})
@Immutable
public final class ImmutableEvent extends Event {
  private final String id;
  private final String name;
  private final Optional<String> payload;
  private final Optional<String> nodeFilter;
  private final Optional<String> serviceFilter;
  private final Optional<String> tagFilter;
  private final int version;
  private final Long lTime;

  private ImmutableEvent(
      String id,
      String name,
      Optional<String> payload,
      Optional<String> nodeFilter,
      Optional<String> serviceFilter,
      Optional<String> tagFilter,
      int version,
      Long lTime) {
    this.id = id;
    this.name = name;
    this.payload = payload;
    this.nodeFilter = nodeFilter;
    this.serviceFilter = serviceFilter;
    this.tagFilter = tagFilter;
    this.version = version;
    this.lTime = lTime;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty(value = "ID")
  @Override
  public String getId() {
    return id;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty(value = "Name")
  @Override
  public String getName() {
    return name;
  }

  /**
   * @return The value of the {@code payload} attribute
   */
  @JsonProperty(value = "Payload")
  @JsonDeserialize(using = Base64EncodingDeserializer.class)
  @Override
  public Optional<String> getPayload() {
    return payload;
  }

  /**
   * @return The value of the {@code nodeFilter} attribute
   */
  @JsonProperty(value = "NodeFilter")
  @Override
  public Optional<String> getNodeFilter() {
    return nodeFilter;
  }

  /**
   * @return The value of the {@code serviceFilter} attribute
   */
  @JsonProperty(value = "ServiceFilter")
  @Override
  public Optional<String> getServiceFilter() {
    return serviceFilter;
  }

  /**
   * @return The value of the {@code tagFilter} attribute
   */
  @JsonProperty(value = "TagFilter")
  @Override
  public Optional<String> getTagFilter() {
    return tagFilter;
  }

  /**
   * @return The value of the {@code version} attribute
   */
  @JsonProperty(value = "Version")
  @Override
  public int getVersion() {
    return version;
  }

  /**
   * @return The value of the {@code lTime} attribute
   */
  @JsonProperty(value = "LTime")
  @Override
  public Long getLTime() {
    return lTime;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Event#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableEvent withId(String value) {
    if (this.id.equals(value)) return this;
    return new ImmutableEvent(
        Preconditions.checkNotNull(value, "id"),
        this.name,
        this.payload,
        this.nodeFilter,
        this.serviceFilter,
        this.tagFilter,
        this.version,
        this.lTime);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Event#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableEvent withName(String value) {
    if (this.name.equals(value)) return this;
    return new ImmutableEvent(
        this.id,
        Preconditions.checkNotNull(value, "name"),
        this.payload,
        this.nodeFilter,
        this.serviceFilter,
        this.tagFilter,
        this.version,
        this.lTime);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Event#getPayload() payload} attribute.
   * @param value The value for payload
   * @return A modified copy of {@code this} object
   */
  public final ImmutableEvent withPayload(String value) {
    Optional<String> newValue = Optional.of(value);
    if (this.payload.equals(newValue)) return this;
    return new ImmutableEvent(
        this.id,
        this.name,
        newValue,
        this.nodeFilter,
        this.serviceFilter,
        this.tagFilter,
        this.version,
        this.lTime);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Event#getPayload() payload} attribute.
   * An equality check is used to prevent copying of the same value by returning {@code this}.
   * @param optional A value for payload
   * @return A modified copy of {@code this} object
   */
  public final ImmutableEvent withPayload(Optional<String> optional) {
    Optional<String> value = Preconditions.checkNotNull(optional, "payload");
    if (this.payload.equals(value)) return this;
    return new ImmutableEvent(
        this.id,
        this.name,
        value,
        this.nodeFilter,
        this.serviceFilter,
        this.tagFilter,
        this.version,
        this.lTime);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Event#getNodeFilter() nodeFilter} attribute.
   * @param value The value for nodeFilter
   * @return A modified copy of {@code this} object
   */
  public final ImmutableEvent withNodeFilter(String value) {
    Optional<String> newValue = Optional.of(value);
    if (this.nodeFilter.equals(newValue)) return this;
    return new ImmutableEvent(
        this.id,
        this.name,
        this.payload,
        newValue,
        this.serviceFilter,
        this.tagFilter,
        this.version,
        this.lTime);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Event#getNodeFilter() nodeFilter} attribute.
   * An equality check is used to prevent copying of the same value by returning {@code this}.
   * @param optional A value for nodeFilter
   * @return A modified copy of {@code this} object
   */
  public final ImmutableEvent withNodeFilter(Optional<String> optional) {
    Optional<String> value = Preconditions.checkNotNull(optional, "nodeFilter");
    if (this.nodeFilter.equals(value)) return this;
    return new ImmutableEvent(
        this.id,
        this.name,
        this.payload,
        value,
        this.serviceFilter,
        this.tagFilter,
        this.version,
        this.lTime);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Event#getServiceFilter() serviceFilter} attribute.
   * @param value The value for serviceFilter
   * @return A modified copy of {@code this} object
   */
  public final ImmutableEvent withServiceFilter(String value) {
    Optional<String> newValue = Optional.of(value);
    if (this.serviceFilter.equals(newValue)) return this;
    return new ImmutableEvent(
        this.id,
        this.name,
        this.payload,
        this.nodeFilter,
        newValue,
        this.tagFilter,
        this.version,
        this.lTime);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Event#getServiceFilter() serviceFilter} attribute.
   * An equality check is used to prevent copying of the same value by returning {@code this}.
   * @param optional A value for serviceFilter
   * @return A modified copy of {@code this} object
   */
  public final ImmutableEvent withServiceFilter(Optional<String> optional) {
    Optional<String> value = Preconditions.checkNotNull(optional, "serviceFilter");
    if (this.serviceFilter.equals(value)) return this;
    return new ImmutableEvent(
        this.id,
        this.name,
        this.payload,
        this.nodeFilter,
        value,
        this.tagFilter,
        this.version,
        this.lTime);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Event#getTagFilter() tagFilter} attribute.
   * @param value The value for tagFilter
   * @return A modified copy of {@code this} object
   */
  public final ImmutableEvent withTagFilter(String value) {
    Optional<String> newValue = Optional.of(value);
    if (this.tagFilter.equals(newValue)) return this;
    return new ImmutableEvent(
        this.id,
        this.name,
        this.payload,
        this.nodeFilter,
        this.serviceFilter,
        newValue,
        this.version,
        this.lTime);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Event#getTagFilter() tagFilter} attribute.
   * An equality check is used to prevent copying of the same value by returning {@code this}.
   * @param optional A value for tagFilter
   * @return A modified copy of {@code this} object
   */
  public final ImmutableEvent withTagFilter(Optional<String> optional) {
    Optional<String> value = Preconditions.checkNotNull(optional, "tagFilter");
    if (this.tagFilter.equals(value)) return this;
    return new ImmutableEvent(
        this.id,
        this.name,
        this.payload,
        this.nodeFilter,
        this.serviceFilter,
        value,
        this.version,
        this.lTime);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Event#getVersion() version} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for version
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableEvent withVersion(int value) {
    if (this.version == value) return this;
    return new ImmutableEvent(
        this.id,
        this.name,
        this.payload,
        this.nodeFilter,
        this.serviceFilter,
        this.tagFilter,
        value,
        this.lTime);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Event#getLTime() lTime} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for lTime
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableEvent withLTime(Long value) {
    if (this.lTime.equals(value)) return this;
    return new ImmutableEvent(
        this.id,
        this.name,
        this.payload,
        this.nodeFilter,
        this.serviceFilter,
        this.tagFilter,
        this.version,
        Preconditions.checkNotNull(value, "lTime"));
  }

  /**
   * This instance is equal to all instances of {@code ImmutableEvent} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableEvent
        && equalTo((ImmutableEvent) another);
  }

  private boolean equalTo(ImmutableEvent another) {
    return id.equals(another.id)
        && name.equals(another.name)
        && payload.equals(another.payload)
        && nodeFilter.equals(another.nodeFilter)
        && serviceFilter.equals(another.serviceFilter)
        && tagFilter.equals(another.tagFilter)
        && version == another.version
        && lTime.equals(another.lTime);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code name}, {@code payload}, {@code nodeFilter}, {@code serviceFilter}, {@code tagFilter}, {@code version}, {@code lTime}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + id.hashCode();
    h = h * 17 + name.hashCode();
    h = h * 17 + payload.hashCode();
    h = h * 17 + nodeFilter.hashCode();
    h = h * 17 + serviceFilter.hashCode();
    h = h * 17 + tagFilter.hashCode();
    h = h * 17 + version;
    h = h * 17 + lTime.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Event} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Event")
        .omitNullValues()
        .add("id", id)
        .add("name", name)
        .add("payload", payload.orNull())
        .add("nodeFilter", nodeFilter.orNull())
        .add("serviceFilter", serviceFilter.orNull())
        .add("tagFilter", tagFilter.orNull())
        .add("version", version)
        .add("lTime", lTime)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  static final class Json extends Event {
    @Nullable String id;
    @Nullable String name;
    Optional<String> payload = Optional.absent();
    Optional<String> nodeFilter = Optional.absent();
    Optional<String> serviceFilter = Optional.absent();
    Optional<String> tagFilter = Optional.absent();
    @Nullable Integer version;
    @Nullable Long lTime;
    @JsonProperty(value = "ID")
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty(value = "Name")
    public void setName(String name) {
      this.name = name;
    }
    @JsonProperty(value = "Payload")
    @JsonDeserialize(using = Base64EncodingDeserializer.class)
    public void setPayload(Optional<String> payload) {
      this.payload = payload;
    }
    @JsonProperty(value = "NodeFilter")
    public void setNodeFilter(Optional<String> nodeFilter) {
      this.nodeFilter = nodeFilter;
    }
    @JsonProperty(value = "ServiceFilter")
    public void setServiceFilter(Optional<String> serviceFilter) {
      this.serviceFilter = serviceFilter;
    }
    @JsonProperty(value = "TagFilter")
    public void setTagFilter(Optional<String> tagFilter) {
      this.tagFilter = tagFilter;
    }
    @JsonProperty(value = "Version")
    public void setVersion(int version) {
      this.version = version;
    }
    @JsonProperty(value = "LTime")
    public void setLTime(Long lTime) {
      this.lTime = lTime;
    }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getPayload() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getNodeFilter() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getServiceFilter() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getTagFilter() { throw new UnsupportedOperationException(); }
    @Override
    public int getVersion() { throw new UnsupportedOperationException(); }
    @Override
    public Long getLTime() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static ImmutableEvent fromJson(Json json) {
    ImmutableEvent.Builder builder = ImmutableEvent.builder();
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.payload != null) {
      builder.payload(json.payload);
    }
    if (json.nodeFilter != null) {
      builder.nodeFilter(json.nodeFilter);
    }
    if (json.serviceFilter != null) {
      builder.serviceFilter(json.serviceFilter);
    }
    if (json.tagFilter != null) {
      builder.tagFilter(json.tagFilter);
    }
    if (json.version != null) {
      builder.version(json.version);
    }
    if (json.lTime != null) {
      builder.lTime(json.lTime);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Event} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Event instance
   */
  public static ImmutableEvent copyOf(Event instance) {
    if (instance instanceof ImmutableEvent) {
      return (ImmutableEvent) instance;
    }
    return ImmutableEvent.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableEvent ImmutableEvent}.
   * @return A new ImmutableEvent builder
   */
  public static ImmutableEvent.Builder builder() {
    return new ImmutableEvent.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableEvent ImmutableEvent}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private static final long INIT_BIT_NAME = 0x2L;
    private static final long INIT_BIT_VERSION = 0x4L;
    private static final long INIT_BIT_L_TIME = 0x8L;
    private long initBits = 0xf;

    private @Nullable String id;
    private @Nullable String name;
    private Optional<String> payload = Optional.absent();
    private Optional<String> nodeFilter = Optional.absent();
    private Optional<String> serviceFilter = Optional.absent();
    private Optional<String> tagFilter = Optional.absent();
    private int version;
    private @Nullable Long lTime;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Event} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Event instance) {
      Preconditions.checkNotNull(instance, "instance");
      id(instance.getId());
      name(instance.getName());
      Optional<String> payloadOptional = instance.getPayload();
      if (payloadOptional.isPresent()) {
        payload(payloadOptional);
      }
      Optional<String> nodeFilterOptional = instance.getNodeFilter();
      if (nodeFilterOptional.isPresent()) {
        nodeFilter(nodeFilterOptional);
      }
      Optional<String> serviceFilterOptional = instance.getServiceFilter();
      if (serviceFilterOptional.isPresent()) {
        serviceFilter(serviceFilterOptional);
      }
      Optional<String> tagFilterOptional = instance.getTagFilter();
      if (tagFilterOptional.isPresent()) {
        tagFilter(tagFilterOptional);
      }
      version(instance.getVersion());
      lTime(instance.getLTime());
      return this;
    }

    /**
     * Initializes the value for the {@link Event#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder id(String id) {
      this.id = Preconditions.checkNotNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link Event#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String name) {
      this.name = Preconditions.checkNotNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the optional value {@link Event#getPayload() payload} to payload.
     * @param payload The value for payload
     * @return {@code this} builder for chained invocation
     */
    public final Builder payload(String payload) {
      this.payload = Optional.of(payload);
      return this;
    }

    /**
     * Initializes the optional value {@link Event#getPayload() payload} to payload.
     * @param payload The value for payload
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder payload(Optional<String> payload) {
      this.payload = Preconditions.checkNotNull(payload, "payload");
      return this;
    }

    /**
     * Initializes the optional value {@link Event#getNodeFilter() nodeFilter} to nodeFilter.
     * @param nodeFilter The value for nodeFilter
     * @return {@code this} builder for chained invocation
     */
    public final Builder nodeFilter(String nodeFilter) {
      this.nodeFilter = Optional.of(nodeFilter);
      return this;
    }

    /**
     * Initializes the optional value {@link Event#getNodeFilter() nodeFilter} to nodeFilter.
     * @param nodeFilter The value for nodeFilter
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder nodeFilter(Optional<String> nodeFilter) {
      this.nodeFilter = Preconditions.checkNotNull(nodeFilter, "nodeFilter");
      return this;
    }

    /**
     * Initializes the optional value {@link Event#getServiceFilter() serviceFilter} to serviceFilter.
     * @param serviceFilter The value for serviceFilter
     * @return {@code this} builder for chained invocation
     */
    public final Builder serviceFilter(String serviceFilter) {
      this.serviceFilter = Optional.of(serviceFilter);
      return this;
    }

    /**
     * Initializes the optional value {@link Event#getServiceFilter() serviceFilter} to serviceFilter.
     * @param serviceFilter The value for serviceFilter
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceFilter(Optional<String> serviceFilter) {
      this.serviceFilter = Preconditions.checkNotNull(serviceFilter, "serviceFilter");
      return this;
    }

    /**
     * Initializes the optional value {@link Event#getTagFilter() tagFilter} to tagFilter.
     * @param tagFilter The value for tagFilter
     * @return {@code this} builder for chained invocation
     */
    public final Builder tagFilter(String tagFilter) {
      this.tagFilter = Optional.of(tagFilter);
      return this;
    }

    /**
     * Initializes the optional value {@link Event#getTagFilter() tagFilter} to tagFilter.
     * @param tagFilter The value for tagFilter
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder tagFilter(Optional<String> tagFilter) {
      this.tagFilter = Preconditions.checkNotNull(tagFilter, "tagFilter");
      return this;
    }

    /**
     * Initializes the value for the {@link Event#getVersion() version} attribute.
     * @param version The value for version 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder version(int version) {
      this.version = version;
      initBits &= ~INIT_BIT_VERSION;
      return this;
    }

    /**
     * Initializes the value for the {@link Event#getLTime() lTime} attribute.
     * @param lTime The value for lTime 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder lTime(Long lTime) {
      this.lTime = Preconditions.checkNotNull(lTime, "lTime");
      initBits &= ~INIT_BIT_L_TIME;
      return this;
    }

    /**
     * Builds a new {@link ImmutableEvent ImmutableEvent}.
     * @return An immutable instance of Event
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableEvent build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableEvent(id, name, payload, nodeFilter, serviceFilter, tagFilter, version, lTime);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = Lists.newArrayList();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_VERSION) != 0) attributes.add("version");
      if ((initBits & INIT_BIT_L_TIME) != 0) attributes.add("lTime");
      return "Cannot build Event, some of required attributes are not set " + attributes;
    }
  }
}
