/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.model.coordinate;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.orbitz.consul.model.coordinate.Coord;
import com.orbitz.consul.model.coordinate.Coordinate;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@JsonIgnoreProperties(ignoreUnknown=true)
@Immutable
public final class ImmutableCoordinate
extends Coordinate {
    private final String node;
    private final Coord coord;

    private ImmutableCoordinate(String node, Coord coord) {
        this.node = node;
        this.coord = coord;
    }

    @Override
    @JsonProperty(value="Node")
    public String getNode() {
        return this.node;
    }

    @Override
    @JsonProperty(value="Coord")
    public Coord getCoord() {
        return this.coord;
    }

    public final ImmutableCoordinate withNode(String value) {
        if (this.node.equals(value)) {
            return this;
        }
        return new ImmutableCoordinate((String)Preconditions.checkNotNull((Object)value, (Object)"node"), this.coord);
    }

    public final ImmutableCoordinate withCoord(Coord value) {
        if (this.coord == value) {
            return this;
        }
        return new ImmutableCoordinate(this.node, (Coord)Preconditions.checkNotNull((Object)value, (Object)"coord"));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCoordinate && this.equalTo((ImmutableCoordinate)another);
    }

    private boolean equalTo(ImmutableCoordinate another) {
        return this.node.equals(another.node) && this.coord.equals(another.coord);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.node.hashCode();
        h = h * 17 + this.coord.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Coordinate").omitNullValues().add("node", (Object)this.node).add("coord", (Object)this.coord).toString();
    }

    @Deprecated
    @JsonCreator
    static ImmutableCoordinate fromJson(Json json) {
        Builder builder = ImmutableCoordinate.builder();
        if (json.node != null) {
            builder.node(json.node);
        }
        if (json.coord != null) {
            builder.coord(json.coord);
        }
        return builder.build();
    }

    public static ImmutableCoordinate copyOf(Coordinate instance) {
        if (instance instanceof ImmutableCoordinate) {
            return (ImmutableCoordinate)instance;
        }
        return ImmutableCoordinate.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NODE = 1L;
        private static final long INIT_BIT_COORD = 2L;
        private long initBits = 3L;
        @Nullable
        private String node;
        @Nullable
        private Coord coord;

        private Builder() {
        }

        public final Builder from(Coordinate instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.node(instance.getNode());
            this.coord(instance.getCoord());
            return this;
        }

        public final Builder node(String node) {
            this.node = (String)Preconditions.checkNotNull((Object)node, (Object)"node");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder coord(Coord coord) {
            this.coord = (Coord)Preconditions.checkNotNull((Object)coord, (Object)"coord");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableCoordinate build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCoordinate(this.node, this.coord);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("node");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("coord");
            }
            return "Cannot build Coordinate, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    static final class Json
    extends Coordinate {
        @Nullable
        String node;
        @Nullable
        Coord coord;

        Json() {
        }

        @JsonProperty(value="Node")
        public void setNode(String node) {
            this.node = node;
        }

        @JsonProperty(value="Coord")
        public void setCoord(Coord coord) {
            this.coord = coord;
        }

        @Override
        public String getNode() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Coord getCoord() {
            throw new UnsupportedOperationException();
        }
    }
}

