/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.model.agent;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.orbitz.consul.model.agent.ImmutableCheck;
import org.immutables.value.Value;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonSerialize(as=ImmutableCheck.class)
@JsonDeserialize(as=ImmutableCheck.class)
@Value.Immutable
public abstract class Check {
    @JsonProperty(value="ID")
    public abstract String getId();

    @JsonProperty(value="Name")
    public abstract String getName();

    @JsonProperty(value="Notes")
    public abstract Optional<String> getNotes();

    @JsonProperty(value="Output")
    public abstract Optional<String> getOutput();

    @JsonProperty(value="Script")
    public abstract Optional<String> getScript();

    @JsonProperty(value="Interval")
    public abstract Optional<String> getInterval();

    @JsonProperty(value="TTL")
    public abstract Optional<String> getTtl();

    @JsonProperty(value="HTTP")
    public abstract Optional<String> getHttp();

    @JsonProperty(value="TCP")
    public abstract Optional<String> getTcp();

    @JsonProperty(value="ServiceID")
    public abstract Optional<String> getServiceId();

    @JsonProperty(value="DeregisterCriticalServiceAfter")
    public abstract Optional<String> getDeregisterCriticalServiceAfter();

    @Value.Check
    protected void validate() {
        Preconditions.checkState((this.getHttp().isPresent() || this.getTtl().isPresent() || this.getScript().isPresent() || this.getTcp().isPresent() ? 1 : 0) != 0, (Object)"Check must specify either http, tcp, ttl, or script");
        if (this.getHttp().isPresent() || this.getScript().isPresent() || this.getTcp().isPresent()) {
            Preconditions.checkState((boolean)this.getInterval().isPresent(), (Object)"Interval must be set if check type is http, tcp or script");
        }
    }
}

