/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.model.health;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.orbitz.consul.model.health.HealthCheck;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@JsonIgnoreProperties(ignoreUnknown=true)
@Immutable
public final class ImmutableHealthCheck
extends HealthCheck {
    private final String node;
    private final String checkId;
    private final String name;
    private final String status;
    private final Optional<String> notes;
    private final Optional<String> output;
    private final Optional<String> serviceId;
    private final Optional<String> serviceName;

    private ImmutableHealthCheck(String node, String checkId, String name, String status, Optional<String> notes, Optional<String> output, Optional<String> serviceId, Optional<String> serviceName) {
        this.node = node;
        this.checkId = checkId;
        this.name = name;
        this.status = status;
        this.notes = notes;
        this.output = output;
        this.serviceId = serviceId;
        this.serviceName = serviceName;
    }

    @Override
    @JsonProperty(value="Node")
    public String getNode() {
        return this.node;
    }

    @Override
    @JsonProperty(value="CheckID")
    public String getCheckId() {
        return this.checkId;
    }

    @Override
    @JsonProperty(value="Name")
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="Status")
    public String getStatus() {
        return this.status;
    }

    @Override
    @JsonProperty(value="Notes")
    public Optional<String> getNotes() {
        return this.notes;
    }

    @Override
    @JsonProperty(value="Output")
    public Optional<String> getOutput() {
        return this.output;
    }

    @Override
    @JsonProperty(value="ServiceID")
    public Optional<String> getServiceId() {
        return this.serviceId;
    }

    @Override
    @JsonProperty(value="ServiceName")
    public Optional<String> getServiceName() {
        return this.serviceName;
    }

    public final ImmutableHealthCheck withNode(String value) {
        if (this.node.equals(value)) {
            return this;
        }
        return new ImmutableHealthCheck((String)Preconditions.checkNotNull((Object)value, (Object)"node"), this.checkId, this.name, this.status, this.notes, this.output, this.serviceId, this.serviceName);
    }

    public final ImmutableHealthCheck withCheckId(String value) {
        if (this.checkId.equals(value)) {
            return this;
        }
        return new ImmutableHealthCheck(this.node, (String)Preconditions.checkNotNull((Object)value, (Object)"checkId"), this.name, this.status, this.notes, this.output, this.serviceId, this.serviceName);
    }

    public final ImmutableHealthCheck withName(String value) {
        if (this.name.equals(value)) {
            return this;
        }
        return new ImmutableHealthCheck(this.node, this.checkId, (String)Preconditions.checkNotNull((Object)value, (Object)"name"), this.status, this.notes, this.output, this.serviceId, this.serviceName);
    }

    public final ImmutableHealthCheck withStatus(String value) {
        if (this.status.equals(value)) {
            return this;
        }
        return new ImmutableHealthCheck(this.node, this.checkId, this.name, (String)Preconditions.checkNotNull((Object)value, (Object)"status"), this.notes, this.output, this.serviceId, this.serviceName);
    }

    public final ImmutableHealthCheck withNotes(String value) {
        Optional newValue = Optional.of((Object)value);
        if (this.notes.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableHealthCheck(this.node, this.checkId, this.name, this.status, (Optional<String>)newValue, this.output, this.serviceId, this.serviceName);
    }

    public final ImmutableHealthCheck withNotes(Optional<String> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"notes");
        if (this.notes.equals((Object)value)) {
            return this;
        }
        return new ImmutableHealthCheck(this.node, this.checkId, this.name, this.status, (Optional<String>)value, this.output, this.serviceId, this.serviceName);
    }

    public final ImmutableHealthCheck withOutput(String value) {
        Optional newValue = Optional.of((Object)value);
        if (this.output.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableHealthCheck(this.node, this.checkId, this.name, this.status, this.notes, (Optional<String>)newValue, this.serviceId, this.serviceName);
    }

    public final ImmutableHealthCheck withOutput(Optional<String> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"output");
        if (this.output.equals((Object)value)) {
            return this;
        }
        return new ImmutableHealthCheck(this.node, this.checkId, this.name, this.status, this.notes, (Optional<String>)value, this.serviceId, this.serviceName);
    }

    public final ImmutableHealthCheck withServiceId(String value) {
        Optional newValue = Optional.of((Object)value);
        if (this.serviceId.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableHealthCheck(this.node, this.checkId, this.name, this.status, this.notes, this.output, (Optional<String>)newValue, this.serviceName);
    }

    public final ImmutableHealthCheck withServiceId(Optional<String> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"serviceId");
        if (this.serviceId.equals((Object)value)) {
            return this;
        }
        return new ImmutableHealthCheck(this.node, this.checkId, this.name, this.status, this.notes, this.output, (Optional<String>)value, this.serviceName);
    }

    public final ImmutableHealthCheck withServiceName(String value) {
        Optional newValue = Optional.of((Object)value);
        if (this.serviceName.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableHealthCheck(this.node, this.checkId, this.name, this.status, this.notes, this.output, this.serviceId, (Optional<String>)newValue);
    }

    public final ImmutableHealthCheck withServiceName(Optional<String> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"serviceName");
        if (this.serviceName.equals((Object)value)) {
            return this;
        }
        return new ImmutableHealthCheck(this.node, this.checkId, this.name, this.status, this.notes, this.output, this.serviceId, (Optional<String>)value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableHealthCheck && this.equalTo((ImmutableHealthCheck)another);
    }

    private boolean equalTo(ImmutableHealthCheck another) {
        return this.node.equals(another.node) && this.checkId.equals(another.checkId) && this.name.equals(another.name) && this.status.equals(another.status) && this.notes.equals(another.notes) && this.output.equals(another.output) && this.serviceId.equals(another.serviceId) && this.serviceName.equals(another.serviceName);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.node.hashCode();
        h = h * 17 + this.checkId.hashCode();
        h = h * 17 + this.name.hashCode();
        h = h * 17 + this.status.hashCode();
        h = h * 17 + this.notes.hashCode();
        h = h * 17 + this.output.hashCode();
        h = h * 17 + this.serviceId.hashCode();
        h = h * 17 + this.serviceName.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"HealthCheck").omitNullValues().add("node", (Object)this.node).add("checkId", (Object)this.checkId).add("name", (Object)this.name).add("status", (Object)this.status).add("notes", this.notes.orNull()).add("output", this.output.orNull()).add("serviceId", this.serviceId.orNull()).add("serviceName", this.serviceName.orNull()).toString();
    }

    @Deprecated
    @JsonCreator
    static ImmutableHealthCheck fromJson(Json json) {
        Builder builder = ImmutableHealthCheck.builder();
        if (json.node != null) {
            builder.node(json.node);
        }
        if (json.checkId != null) {
            builder.checkId(json.checkId);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.status != null) {
            builder.status(json.status);
        }
        if (json.notes != null) {
            builder.notes(json.notes);
        }
        if (json.output != null) {
            builder.output(json.output);
        }
        if (json.serviceId != null) {
            builder.serviceId(json.serviceId);
        }
        if (json.serviceName != null) {
            builder.serviceName(json.serviceName);
        }
        return builder.build();
    }

    public static ImmutableHealthCheck copyOf(HealthCheck instance) {
        if (instance instanceof ImmutableHealthCheck) {
            return (ImmutableHealthCheck)instance;
        }
        return ImmutableHealthCheck.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NODE = 1L;
        private static final long INIT_BIT_CHECK_ID = 2L;
        private static final long INIT_BIT_NAME = 4L;
        private static final long INIT_BIT_STATUS = 8L;
        private long initBits = 15L;
        @Nullable
        private String node;
        @Nullable
        private String checkId;
        @Nullable
        private String name;
        @Nullable
        private String status;
        private Optional<String> notes = Optional.absent();
        private Optional<String> output = Optional.absent();
        private Optional<String> serviceId = Optional.absent();
        private Optional<String> serviceName = Optional.absent();

        private Builder() {
        }

        public final Builder from(HealthCheck instance) {
            Optional<String> serviceNameOptional;
            Optional<String> serviceIdOptional;
            Optional<String> outputOptional;
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.node(instance.getNode());
            this.checkId(instance.getCheckId());
            this.name(instance.getName());
            this.status(instance.getStatus());
            Optional<String> notesOptional = instance.getNotes();
            if (notesOptional.isPresent()) {
                this.notes(notesOptional);
            }
            if ((outputOptional = instance.getOutput()).isPresent()) {
                this.output(outputOptional);
            }
            if ((serviceIdOptional = instance.getServiceId()).isPresent()) {
                this.serviceId(serviceIdOptional);
            }
            if ((serviceNameOptional = instance.getServiceName()).isPresent()) {
                this.serviceName(serviceNameOptional);
            }
            return this;
        }

        public final Builder node(String node) {
            this.node = (String)Preconditions.checkNotNull((Object)node, (Object)"node");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder checkId(String checkId) {
            this.checkId = (String)Preconditions.checkNotNull((Object)checkId, (Object)"checkId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder name(String name) {
            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder status(String status) {
            this.status = (String)Preconditions.checkNotNull((Object)status, (Object)"status");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder notes(String notes) {
            this.notes = Optional.of((Object)notes);
            return this;
        }

        public final Builder notes(Optional<String> notes) {
            this.notes = (Optional)Preconditions.checkNotNull(notes, (Object)"notes");
            return this;
        }

        public final Builder output(String output) {
            this.output = Optional.of((Object)output);
            return this;
        }

        public final Builder output(Optional<String> output) {
            this.output = (Optional)Preconditions.checkNotNull(output, (Object)"output");
            return this;
        }

        public final Builder serviceId(String serviceId) {
            this.serviceId = Optional.of((Object)serviceId);
            return this;
        }

        public final Builder serviceId(Optional<String> serviceId) {
            this.serviceId = (Optional)Preconditions.checkNotNull(serviceId, (Object)"serviceId");
            return this;
        }

        public final Builder serviceName(String serviceName) {
            this.serviceName = Optional.of((Object)serviceName);
            return this;
        }

        public final Builder serviceName(Optional<String> serviceName) {
            this.serviceName = (Optional)Preconditions.checkNotNull(serviceName, (Object)"serviceName");
            return this;
        }

        public ImmutableHealthCheck build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableHealthCheck(this.node, this.checkId, this.name, this.status, this.notes, this.output, this.serviceId, this.serviceName);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("node");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("checkId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("status");
            }
            return "Cannot build HealthCheck, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    static final class Json
    extends HealthCheck {
        @Nullable
        String node;
        @Nullable
        String checkId;
        @Nullable
        String name;
        @Nullable
        String status;
        Optional<String> notes = Optional.absent();
        Optional<String> output = Optional.absent();
        Optional<String> serviceId = Optional.absent();
        Optional<String> serviceName = Optional.absent();

        Json() {
        }

        @JsonProperty(value="Node")
        public void setNode(String node) {
            this.node = node;
        }

        @JsonProperty(value="CheckID")
        public void setCheckId(String checkId) {
            this.checkId = checkId;
        }

        @JsonProperty(value="Name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="Status")
        public void setStatus(String status) {
            this.status = status;
        }

        @JsonProperty(value="Notes")
        public void setNotes(Optional<String> notes) {
            this.notes = notes;
        }

        @JsonProperty(value="Output")
        public void setOutput(Optional<String> output) {
            this.output = output;
        }

        @JsonProperty(value="ServiceID")
        public void setServiceId(Optional<String> serviceId) {
            this.serviceId = serviceId;
        }

        @JsonProperty(value="ServiceName")
        public void setServiceName(Optional<String> serviceName) {
            this.serviceName = serviceName;
        }

        @Override
        public String getNode() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getCheckId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getStatus() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getNotes() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getOutput() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getServiceId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getServiceName() {
            throw new UnsupportedOperationException();
        }
    }
}

