/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul;

import com.orbitz.consul.async.ConsulResponseCallback;
import com.orbitz.consul.model.ConsulResponse;
import com.orbitz.consul.model.catalog.CatalogDeregistration;
import com.orbitz.consul.model.catalog.CatalogNode;
import com.orbitz.consul.model.catalog.CatalogRegistration;
import com.orbitz.consul.model.catalog.CatalogService;
import com.orbitz.consul.model.health.Node;
import com.orbitz.consul.option.CatalogOptions;
import com.orbitz.consul.option.Options;
import com.orbitz.consul.option.QueryOptions;
import com.orbitz.consul.util.Http;
import java.util.List;
import java.util.Map;
import retrofit2.Call;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.QueryMap;

public class CatalogClient {
    private final Api api;

    CatalogClient(Retrofit retrofit) {
        this.api = (Api)retrofit.create(Api.class);
    }

    public List<String> getDatacenters() {
        return Http.extract(this.api.getDatacenters(), new Integer[0]);
    }

    public ConsulResponse<List<Node>> getNodes() {
        return this.getNodes(null, QueryOptions.BLANK);
    }

    public ConsulResponse<List<Node>> getNodes(CatalogOptions catalogOptions) {
        return this.getNodes(catalogOptions, QueryOptions.BLANK);
    }

    public ConsulResponse<List<Node>> getNodes(QueryOptions queryOptions) {
        return this.getNodes(null, queryOptions);
    }

    public ConsulResponse<List<Node>> getNodes(CatalogOptions catalogOptions, QueryOptions queryOptions) {
        return Http.extractConsulResponse(this.api.getNodes(Options.from(catalogOptions, queryOptions)), new Integer[0]);
    }

    public void getNodes(CatalogOptions catalogOptions, QueryOptions queryOptions, ConsulResponseCallback<List<Node>> callback) {
        Http.extractConsulResponse(this.api.getNodes(Options.from(catalogOptions, queryOptions)), callback, new Integer[0]);
    }

    public ConsulResponse<Map<String, List<String>>> getServices() {
        return this.getServices(null, QueryOptions.BLANK);
    }

    public ConsulResponse<Map<String, List<String>>> getServices(CatalogOptions catalogOptions) {
        return this.getServices(catalogOptions, QueryOptions.BLANK);
    }

    public ConsulResponse<Map<String, List<String>>> getServices(QueryOptions queryOptions) {
        return this.getServices(null, queryOptions);
    }

    public ConsulResponse<Map<String, List<String>>> getServices(CatalogOptions catalogOptions, QueryOptions queryOptions) {
        return Http.extractConsulResponse(this.api.getServices(Options.from(catalogOptions, queryOptions)), new Integer[0]);
    }

    public ConsulResponse<List<CatalogService>> getService(String service) {
        return this.getService(service, null, QueryOptions.BLANK);
    }

    public ConsulResponse<List<CatalogService>> getService(String service, CatalogOptions catalogOptions) {
        return this.getService(service, catalogOptions, QueryOptions.BLANK);
    }

    public ConsulResponse<List<CatalogService>> getService(String service, QueryOptions queryOptions) {
        return this.getService(service, null, queryOptions);
    }

    public ConsulResponse<List<CatalogService>> getService(String service, CatalogOptions catalogOptions, QueryOptions queryOptions) {
        return Http.extractConsulResponse(this.api.getService(service, Options.from(catalogOptions, queryOptions)), new Integer[0]);
    }

    public ConsulResponse<CatalogNode> getNode(String node) {
        return this.getNode(node, null, QueryOptions.BLANK);
    }

    public ConsulResponse<CatalogNode> getNode(String node, CatalogOptions catalogOptions) {
        return this.getNode(node, catalogOptions, QueryOptions.BLANK);
    }

    public ConsulResponse<CatalogNode> getNode(String node, QueryOptions queryOptions) {
        return this.getNode(node, null, queryOptions);
    }

    public ConsulResponse<CatalogNode> getNode(String node, CatalogOptions catalogOptions, QueryOptions queryOptions) {
        return Http.extractConsulResponse(this.api.getNode(node, Options.from(catalogOptions, queryOptions)), new Integer[0]);
    }

    public void register(CatalogRegistration registration) {
        Http.handle(this.api.register(registration), new Integer[0]);
    }

    public void deregister(CatalogDeregistration deregistration) {
        Http.handle(this.api.deregister(deregistration), new Integer[0]);
    }

    static interface Api {
        @GET(value="catalog/datacenters")
        public Call<List<String>> getDatacenters();

        @GET(value="catalog/nodes")
        public Call<List<Node>> getNodes(@QueryMap Map<String, Object> var1);

        @GET(value="catalog/node/{node}")
        public Call<CatalogNode> getNode(@Path(value="node") String var1, @QueryMap Map<String, Object> var2);

        @GET(value="catalog/services")
        public Call<Map<String, List<String>>> getServices(@QueryMap Map<String, Object> var1);

        @GET(value="catalog/service/{service}")
        public Call<List<CatalogService>> getService(@Path(value="service") String var1, @QueryMap Map<String, Object> var2);

        @PUT(value="catalog/register")
        public Call<Void> register(@Body CatalogRegistration var1);

        @PUT(value="catalog/deregister")
        public Call<Void> deregister(@Body CatalogDeregistration var1);
    }
}

