/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.model.agent;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.orbitz.consul.model.agent.ImmutableRegCheck;
import com.orbitz.consul.model.agent.ImmutableRegistration;
import java.util.List;
import org.immutables.value.Value;

@JsonSerialize(as=ImmutableRegistration.class)
@JsonDeserialize(as=ImmutableRegistration.class)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@Value.Immutable
public abstract class Registration {
    @JsonProperty(value="Name")
    public abstract String getName();

    @JsonProperty(value="Id")
    public abstract String getId();

    @JsonProperty(value="Address")
    public abstract Optional<String> getAddress();

    @JsonProperty(value="Port")
    public abstract Optional<Integer> getPort();

    @JsonProperty(value="Check")
    public abstract Optional<RegCheck> getCheck();

    @JsonProperty(value="Checks")
    public abstract List<RegCheck> getChecks();

    @JsonProperty(value="Tags")
    public abstract List<String> getTags();

    @JsonProperty(value="EnableTagOverride")
    public abstract Optional<Boolean> getEnableTagOverride();

    @JsonSerialize(as=ImmutableRegCheck.class)
    @JsonDeserialize(as=ImmutableRegCheck.class)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Value.Immutable
    public static abstract class RegCheck {
        @JsonProperty(value="Script")
        public abstract Optional<String> getScript();

        @JsonProperty(value="Interval")
        public abstract Optional<String> getInterval();

        @JsonProperty(value="TTL")
        public abstract Optional<String> getTtl();

        @JsonProperty(value="HTTP")
        public abstract Optional<String> getHttp();

        @JsonProperty(value="TCP")
        public abstract Optional<String> getTcp();

        @JsonProperty(value="Timeout")
        public abstract Optional<String> getTimeout();

        @JsonProperty(value="Notes")
        public abstract Optional<String> getNotes();

        @JsonProperty(value="DeregisterCriticalServiceAfter")
        public abstract Optional<String> getDeregisterCriticalServiceAfter();

        public static RegCheck ttl(long ttl) {
            return ImmutableRegCheck.builder().ttl(String.format("%ss", ttl)).build();
        }

        public static RegCheck script(String script, long interval) {
            return ImmutableRegCheck.builder().script(script).interval(String.format("%ss", interval)).build();
        }

        public static RegCheck script(String script, long interval, long timeout) {
            return ImmutableRegCheck.builder().script(script).interval(String.format("%ss", interval)).timeout(String.format("%ss", timeout)).build();
        }

        public static RegCheck script(String script, long interval, long timeout, String notes) {
            return ImmutableRegCheck.builder().script(script).interval(String.format("%ss", interval)).timeout(String.format("%ss", timeout)).notes(notes).build();
        }

        public static RegCheck http(String http, long interval) {
            return ImmutableRegCheck.builder().http(http).interval(String.format("%ss", interval)).build();
        }

        public static RegCheck http(String http, long interval, long timeout) {
            return ImmutableRegCheck.builder().http(http).interval(String.format("%ss", interval)).timeout(String.format("%ss", timeout)).build();
        }

        public static RegCheck http(String http, long interval, long timeout, String notes) {
            return ImmutableRegCheck.builder().http(http).interval(String.format("%ss", interval)).timeout(String.format("%ss", timeout)).notes(notes).build();
        }

        public static RegCheck tcp(String tcp, long interval) {
            return ImmutableRegCheck.builder().tcp(tcp).interval(String.format("%ss", interval)).build();
        }

        public static RegCheck tcp(String tcp, long interval, long timeout) {
            return ImmutableRegCheck.builder().tcp(tcp).interval(String.format("%ss", interval)).timeout(String.format("%ss", timeout)).build();
        }

        public static RegCheck tcp(String tcp, long interval, long timeout, String notes) {
            return ImmutableRegCheck.builder().tcp(tcp).interval(String.format("%ss", interval)).timeout(String.format("%ss", timeout)).notes(notes).build();
        }

        @Value.Check
        protected void validate() {
            Preconditions.checkState((this.getHttp().isPresent() || this.getTtl().isPresent() || this.getScript().isPresent() || this.getTcp().isPresent() ? 1 : 0) != 0, (Object)"Check must specify either http, tcp, ttl, or script");
            if (this.getHttp().isPresent() || this.getScript().isPresent() || this.getTcp().isPresent()) {
                Preconditions.checkState((boolean)this.getInterval().isPresent(), (Object)"Interval must be set if check type is http, tcp or script");
            }
        }
    }
}

