/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.model.health;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.orbitz.consul.model.health.Service;
import com.orbitz.fasterxml.jackson.annotation.JsonCreator;
import com.orbitz.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.orbitz.fasterxml.jackson.annotation.JsonProperty;
import com.orbitz.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
public final class ImmutableService
extends Service {
    private final String id;
    private final String service;
    private final ImmutableList<String> tags;
    private final String address;
    private final int port;

    private ImmutableService(String id, String service, ImmutableList<String> tags, String address, int port) {
        this.id = id;
        this.service = service;
        this.tags = tags;
        this.address = address;
        this.port = port;
    }

    @Override
    @JsonProperty(value="ID")
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="Service")
    public String getService() {
        return this.service;
    }

    @JsonProperty(value="Tags")
    @JsonDeserialize(as=ImmutableList.class, contentAs=String.class)
    public ImmutableList<String> getTags() {
        return this.tags;
    }

    @Override
    @JsonProperty(value="Address")
    public String getAddress() {
        return this.address;
    }

    @Override
    @JsonProperty(value="Port")
    public int getPort() {
        return this.port;
    }

    public final ImmutableService withId(String value) {
        if (this.id.equals(value)) {
            return this;
        }
        return new ImmutableService((String)Preconditions.checkNotNull((Object)value, (Object)"id"), this.service, this.tags, this.address, this.port);
    }

    public final ImmutableService withService(String value) {
        if (this.service.equals(value)) {
            return this;
        }
        return new ImmutableService(this.id, (String)Preconditions.checkNotNull((Object)value, (Object)"service"), this.tags, this.address, this.port);
    }

    public final ImmutableService withTags(String ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableService(this.id, this.service, (ImmutableList<String>)newValue, this.address, this.port);
    }

    public final ImmutableService withTags(Iterable<String> elements) {
        if (this.tags == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableService(this.id, this.service, (ImmutableList<String>)newValue, this.address, this.port);
    }

    public final ImmutableService withAddress(String value) {
        if (this.address.equals(value)) {
            return this;
        }
        return new ImmutableService(this.id, this.service, this.tags, (String)Preconditions.checkNotNull((Object)value, (Object)"address"), this.port);
    }

    public final ImmutableService withPort(int value) {
        if (this.port == value) {
            return this;
        }
        return new ImmutableService(this.id, this.service, this.tags, this.address, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableService && this.equalTo((ImmutableService)another);
    }

    private boolean equalTo(ImmutableService another) {
        return this.id.equals(another.id) && this.service.equals(another.service) && this.tags.equals(another.tags) && this.address.equals(another.address) && this.port == another.port;
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.id.hashCode();
        h = h * 17 + this.service.hashCode();
        h = h * 17 + this.tags.hashCode();
        h = h * 17 + this.address.hashCode();
        h = h * 17 + this.port;
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Service").omitNullValues().add("id", (Object)this.id).add("service", (Object)this.service).add("tags", this.tags).add("address", (Object)this.address).add("port", this.port).toString();
    }

    @Deprecated
    @JsonCreator
    static ImmutableService fromJson(Json json) {
        Builder builder = ImmutableService.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.service != null) {
            builder.service(json.service);
        }
        if (json.tags != null) {
            builder.addAllTags(json.tags);
        }
        if (json.address != null) {
            builder.address(json.address);
        }
        if (json.port != null) {
            builder.port(json.port);
        }
        return builder.build();
    }

    public static ImmutableService copyOf(Service instance) {
        if (instance instanceof ImmutableService) {
            return (ImmutableService)instance;
        }
        return ImmutableService.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_SERVICE = 2L;
        private static final long INIT_BIT_ADDRESS = 4L;
        private static final long INIT_BIT_PORT = 8L;
        private long initBits = 15L;
        private String id;
        private String service;
        private ImmutableList.Builder<String> tagsBuilder = ImmutableList.builder();
        private String address;
        private int port;

        private Builder() {
        }

        public final Builder from(Service instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.id(instance.getId());
            this.service(instance.getService());
            this.addAllTags(instance.getTags());
            this.address(instance.getAddress());
            this.port(instance.getPort());
            return this;
        }

        public final Builder id(String id) {
            this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder service(String service) {
            this.service = (String)Preconditions.checkNotNull((Object)service, (Object)"service");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder addTags(String element) {
            this.tagsBuilder.add((Object)element);
            return this;
        }

        public final Builder addTags(String ... elements) {
            this.tagsBuilder.add((Object[])elements);
            return this;
        }

        public final Builder tags(Iterable<String> elements) {
            this.tagsBuilder = ImmutableList.builder();
            return this.addAllTags(elements);
        }

        public final Builder addAllTags(Iterable<String> elements) {
            this.tagsBuilder.addAll(elements);
            return this;
        }

        public final Builder address(String address) {
            this.address = (String)Preconditions.checkNotNull((Object)address, (Object)"address");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder port(int port) {
            this.port = port;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableService build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableService(this.id, this.service, this.tagsBuilder.build(), this.address, this.port);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("service");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("address");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("port");
            }
            return "Cannot build Service, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    static final class Json
    extends Service {
        String id;
        String service;
        List<String> tags = ImmutableList.of();
        String address;
        Integer port;

        Json() {
        }

        @JsonProperty(value="ID")
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty(value="Service")
        public void setService(String service) {
            this.service = service;
        }

        @JsonProperty(value="Tags")
        @JsonDeserialize(as=ImmutableList.class, contentAs=String.class)
        public void setTags(List<String> tags) {
            this.tags = tags;
        }

        @JsonProperty(value="Address")
        public void setAddress(String address) {
            this.address = address;
        }

        @JsonProperty(value="Port")
        public void setPort(int port) {
            this.port = port;
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getService() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getTags() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getAddress() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getPort() {
            throw new UnsupportedOperationException();
        }
    }
}

