/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.model.agent;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.orbitz.consul.model.agent.Agent;
import com.orbitz.consul.model.agent.Config;
import com.orbitz.consul.model.agent.Member;
import com.orbitz.fasterxml.jackson.annotation.JsonCreator;
import com.orbitz.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.orbitz.fasterxml.jackson.annotation.JsonProperty;
import com.orbitz.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;

@JsonIgnoreProperties(ignoreUnknown=true)
public final class ImmutableAgent
extends Agent {
    private final Config config;
    private final Member member;

    private ImmutableAgent(Config config, Member member) {
        this.config = config;
        this.member = member;
    }

    @Override
    @JsonProperty(value="Config")
    public Config getConfig() {
        return this.config;
    }

    @Override
    @JsonProperty(value="Member")
    public Member getMember() {
        return this.member;
    }

    public final ImmutableAgent withConfig(Config value) {
        if (this.config == value) {
            return this;
        }
        return new ImmutableAgent((Config)Preconditions.checkNotNull((Object)value, (Object)"config"), this.member);
    }

    public final ImmutableAgent withMember(Member value) {
        if (this.member == value) {
            return this;
        }
        return new ImmutableAgent(this.config, (Member)Preconditions.checkNotNull((Object)value, (Object)"member"));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAgent && this.equalTo((ImmutableAgent)another);
    }

    private boolean equalTo(ImmutableAgent another) {
        return this.config.equals(another.config) && this.member.equals(another.member);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.config.hashCode();
        h = h * 17 + this.member.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Agent").omitNullValues().add("config", (Object)this.config).add("member", (Object)this.member).toString();
    }

    @Deprecated
    @JsonCreator
    static ImmutableAgent fromJson(Json json) {
        Builder builder = ImmutableAgent.builder();
        if (json.config != null) {
            builder.config(json.config);
        }
        if (json.member != null) {
            builder.member(json.member);
        }
        return builder.build();
    }

    public static ImmutableAgent copyOf(Agent instance) {
        if (instance instanceof ImmutableAgent) {
            return (ImmutableAgent)instance;
        }
        return ImmutableAgent.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_CONFIG = 1L;
        private static final long INIT_BIT_MEMBER = 2L;
        private long initBits = 3L;
        private Config config;
        private Member member;

        private Builder() {
        }

        public final Builder from(Agent instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.config(instance.getConfig());
            this.member(instance.getMember());
            return this;
        }

        public final Builder config(Config config) {
            this.config = (Config)Preconditions.checkNotNull((Object)config, (Object)"config");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder member(Member member) {
            this.member = (Member)Preconditions.checkNotNull((Object)member, (Object)"member");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableAgent build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableAgent(this.config, this.member);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("config");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("member");
            }
            return "Cannot build Agent, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    static final class Json
    extends Agent {
        Config config;
        Member member;

        Json() {
        }

        @JsonProperty(value="Config")
        public void setConfig(Config config) {
            this.config = config;
        }

        @JsonProperty(value="Member")
        public void setMember(Member member) {
            this.member = member;
        }

        @Override
        public Config getConfig() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Member getMember() {
            throw new UnsupportedOperationException();
        }
    }
}

