/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.fasterxml.jackson.datatype.guava.deser.util;

import com.orbitz.google.common.collect.BoundType;
import com.orbitz.google.common.collect.Lists;
import com.orbitz.google.common.collect.Range;
import java.lang.reflect.Method;
import java.util.concurrent.Callable;

public class RangeFactory {
    private static final String LEGACY_RANGES_CLASS_NAME = "com.orbitz.google.common.collect.Ranges";
    private static final String LEGACY_RANGE_METHOD_NAME = "range";
    private static final String LEGACY_DOWN_TO_METHOD_NAME = "downTo";
    private static final String LEGACY_UP_TO_METHOD_NAME = "upTo";
    private static final String LEGACY_ALL_METHOD_NAME = "all";
    private static Method legacyRangeMethod;
    private static Method legacyDownToMethod;
    private static Method legacyUpToMethod;
    private static Method legacyAllMethod;

    private static void initLegacyRangeFactoryMethods() {
        try {
            Class<?> rangesClass = Class.forName(LEGACY_RANGES_CLASS_NAME);
            legacyRangeMethod = RangeFactory.findMethod(rangesClass, LEGACY_RANGE_METHOD_NAME, Comparable.class, BoundType.class, Comparable.class, BoundType.class);
            legacyDownToMethod = RangeFactory.findMethod(rangesClass, LEGACY_DOWN_TO_METHOD_NAME, Comparable.class, BoundType.class);
            legacyUpToMethod = RangeFactory.findMethod(rangesClass, LEGACY_UP_TO_METHOD_NAME, Comparable.class, BoundType.class);
            legacyAllMethod = RangeFactory.findMethod(rangesClass, LEGACY_ALL_METHOD_NAME, new Class[0]);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    private static Method findMethod(Class<?> clazz, String methodName, Class<?> ... paramTypes) {
        try {
            return clazz.getMethod(methodName, paramTypes);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static <C extends Comparable<?>> Range<C> open(C lowerEndpoint, C upperEndpoint) {
        return RangeFactory.range(lowerEndpoint, BoundType.OPEN, upperEndpoint, BoundType.OPEN);
    }

    public static <C extends Comparable<?>> Range<C> openClosed(C lowerEndpoint, C upperEndpoint) {
        return RangeFactory.range(lowerEndpoint, BoundType.OPEN, upperEndpoint, BoundType.CLOSED);
    }

    public static <C extends Comparable<?>> Range<C> closedOpen(C lowerEndpoint, C upperEndpoint) {
        return RangeFactory.range(lowerEndpoint, BoundType.CLOSED, upperEndpoint, BoundType.OPEN);
    }

    public static <C extends Comparable<?>> Range<C> closed(C lowerEndpoint, C upperEndpoint) {
        return RangeFactory.range(lowerEndpoint, BoundType.CLOSED, upperEndpoint, BoundType.CLOSED);
    }

    public static <C extends Comparable<?>> Range<C> range(final C lowerEndpoint, final BoundType lowerBoundType, final C upperEndpoint, final BoundType upperBoundType) {
        return RangeFactory.createRange(new Callable<Range<C>>(){

            @Override
            public Range<C> call() throws Exception {
                return Range.range(lowerEndpoint, lowerBoundType, upperEndpoint, upperBoundType);
            }
        }, legacyRangeMethod, new Object[]{lowerEndpoint, lowerBoundType, upperEndpoint, upperBoundType});
    }

    public static <C extends Comparable<?>> Range<C> greaterThan(C lowerEndpoint) {
        return RangeFactory.downTo(lowerEndpoint, BoundType.OPEN);
    }

    public static <C extends Comparable<?>> Range<C> atLeast(C lowerEndpoint) {
        return RangeFactory.downTo(lowerEndpoint, BoundType.CLOSED);
    }

    public static <C extends Comparable<?>> Range<C> downTo(final C lowerEndpoint, final BoundType lowerBoundType) {
        return RangeFactory.createRange(new Callable<Range<C>>(){

            @Override
            public Range<C> call() throws Exception {
                return Range.downTo(lowerEndpoint, lowerBoundType);
            }
        }, legacyDownToMethod, new Object[]{lowerEndpoint, lowerBoundType});
    }

    public static <C extends Comparable<?>> Range<C> lessThan(C upperEndpoint) {
        return RangeFactory.upTo(upperEndpoint, BoundType.OPEN);
    }

    public static <C extends Comparable<?>> Range<C> atMost(C upperEndpoint) {
        return RangeFactory.upTo(upperEndpoint, BoundType.CLOSED);
    }

    public static <C extends Comparable<?>> Range<C> upTo(final C upperEndpoint, final BoundType upperBoundType) {
        return RangeFactory.createRange(new Callable<Range<C>>(){

            @Override
            public Range<C> call() throws Exception {
                return Range.upTo(upperEndpoint, upperBoundType);
            }
        }, legacyUpToMethod, new Object[]{upperEndpoint, upperBoundType});
    }

    public static <C extends Comparable<?>> Range<C> all() {
        return RangeFactory.createRange(new Callable<Range<C>>(){

            @Override
            public Range<C> call() throws Exception {
                return Range.all();
            }
        }, legacyAllMethod, new Object[0]);
    }

    public static <C extends Comparable<?>> Range<C> singleton(final C value) {
        return RangeFactory.createRange(new Callable<Range<C>>(){

            @Override
            public Range<C> call() throws Exception {
                return Range.singleton(value);
            }
        }, legacyRangeMethod, new Object[]{value, BoundType.CLOSED, value, BoundType.CLOSED});
    }

    private static <C extends Comparable<?>> Range<C> createRange(Callable<Range<C>> rangeCallable, Method legacyRangeFactoryMethod, Object ... params) {
        try {
            return rangeCallable.call();
        }
        catch (NoSuchMethodError noSuchMethodError) {
            if (legacyRangeFactoryMethod != null) {
                return RangeFactory.invokeLegacyRangeFactoryMethod(legacyRangeFactoryMethod, params);
            }
            throw noSuchMethodError;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static <C extends Comparable<?>> Range<C> invokeLegacyRangeFactoryMethod(Method method, Object ... params) {
        try {
            return (Range)method.invoke(null, params);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to invoke legacy Range factory method [" + method.getName() + "] with params " + Lists.newArrayList(params) + ".", e);
        }
    }

    private RangeFactory() {
    }

    static {
        RangeFactory.initLegacyRangeFactoryMethods();
    }
}

