/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.option;

import com.orbitz.consul.option.PutOptions;
import com.orbitz.google.common.base.MoreObjects;
import com.orbitz.google.common.base.Optional;
import com.orbitz.google.common.base.Preconditions;

public final class ImmutablePutOptions
extends PutOptions {
    private final Optional<Long> cas;
    private final Optional<String> acquire;
    private final Optional<String> release;
    private final Optional<String> dc;

    private ImmutablePutOptions(Optional<Long> cas, Optional<String> acquire, Optional<String> release, Optional<String> dc) {
        this.cas = cas;
        this.acquire = acquire;
        this.release = release;
        this.dc = dc;
    }

    @Override
    public Optional<Long> getCas() {
        return this.cas;
    }

    @Override
    public Optional<String> getAcquire() {
        return this.acquire;
    }

    @Override
    public Optional<String> getRelease() {
        return this.release;
    }

    @Override
    public Optional<String> getDc() {
        return this.dc;
    }

    public final ImmutablePutOptions withCas(long value) {
        Optional<Long> newValue = Optional.of(value);
        return new ImmutablePutOptions(newValue, this.acquire, this.release, this.dc);
    }

    public final ImmutablePutOptions withCas(Optional<Long> optional) {
        Optional<Long> value = Preconditions.checkNotNull(optional, "cas");
        if (this.cas == value) {
            return this;
        }
        return new ImmutablePutOptions(value, this.acquire, this.release, this.dc);
    }

    public final ImmutablePutOptions withAcquire(String value) {
        Optional<String> newValue = Optional.of(value);
        return new ImmutablePutOptions(this.cas, newValue, this.release, this.dc);
    }

    public final ImmutablePutOptions withAcquire(Optional<String> optional) {
        Optional<String> value = Preconditions.checkNotNull(optional, "acquire");
        if (this.acquire == value) {
            return this;
        }
        return new ImmutablePutOptions(this.cas, value, this.release, this.dc);
    }

    public final ImmutablePutOptions withRelease(String value) {
        Optional<String> newValue = Optional.of(value);
        return new ImmutablePutOptions(this.cas, this.acquire, newValue, this.dc);
    }

    public final ImmutablePutOptions withRelease(Optional<String> optional) {
        Optional<String> value = Preconditions.checkNotNull(optional, "release");
        if (this.release == value) {
            return this;
        }
        return new ImmutablePutOptions(this.cas, this.acquire, value, this.dc);
    }

    public final ImmutablePutOptions withDc(String value) {
        Optional<String> newValue = Optional.of(value);
        return new ImmutablePutOptions(this.cas, this.acquire, this.release, newValue);
    }

    public final ImmutablePutOptions withDc(Optional<String> optional) {
        Optional<String> value = Preconditions.checkNotNull(optional, "dc");
        if (this.dc == value) {
            return this;
        }
        return new ImmutablePutOptions(this.cas, this.acquire, this.release, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePutOptions && this.equalTo((ImmutablePutOptions)another);
    }

    private boolean equalTo(ImmutablePutOptions another) {
        return this.cas.equals(another.cas) && this.acquire.equals(another.acquire) && this.release.equals(another.release) && this.dc.equals(another.dc);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.cas.hashCode();
        h = h * 17 + this.acquire.hashCode();
        h = h * 17 + this.release.hashCode();
        h = h * 17 + this.dc.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("PutOptions").add("cas", this.cas).add("acquire", this.acquire).add("release", this.release).add("dc", this.dc).toString();
    }

    public static ImmutablePutOptions copyOf(PutOptions instance) {
        if (instance instanceof ImmutablePutOptions) {
            return (ImmutablePutOptions)instance;
        }
        return ImmutablePutOptions.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Optional<Long> cas = Optional.absent();
        private Optional<String> acquire = Optional.absent();
        private Optional<String> release = Optional.absent();
        private Optional<String> dc = Optional.absent();

        private Builder() {
        }

        public final Builder from(PutOptions instance) {
            Optional<String> dcOptional;
            Optional<String> releaseOptional;
            Optional<String> acquireOptional;
            Preconditions.checkNotNull(instance, "instance");
            Optional<Long> casOptional = instance.getCas();
            if (casOptional.isPresent()) {
                this.cas(casOptional);
            }
            if ((acquireOptional = instance.getAcquire()).isPresent()) {
                this.acquire(acquireOptional);
            }
            if ((releaseOptional = instance.getRelease()).isPresent()) {
                this.release(releaseOptional);
            }
            if ((dcOptional = instance.getDc()).isPresent()) {
                this.dc(dcOptional);
            }
            return this;
        }

        public final Builder cas(long cas) {
            this.cas = Optional.of(cas);
            return this;
        }

        public final Builder cas(Optional<Long> cas) {
            this.cas = Preconditions.checkNotNull(cas, "cas");
            return this;
        }

        public final Builder acquire(String acquire) {
            this.acquire = Optional.of(acquire);
            return this;
        }

        public final Builder acquire(Optional<String> acquire) {
            this.acquire = Preconditions.checkNotNull(acquire, "acquire");
            return this;
        }

        public final Builder release(String release) {
            this.release = Optional.of(release);
            return this;
        }

        public final Builder release(Optional<String> release) {
            this.release = Preconditions.checkNotNull(release, "release");
            return this;
        }

        public final Builder dc(String dc) {
            this.dc = Optional.of(dc);
            return this;
        }

        public final Builder dc(Optional<String> dc) {
            this.dc = Preconditions.checkNotNull(dc, "dc");
            return this;
        }

        public ImmutablePutOptions build() throws IllegalStateException {
            return new ImmutablePutOptions(this.cas, this.acquire, this.release, this.dc);
        }
    }
}

