/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.model.query;

import com.orbitz.consul.model.query.DnsQuery;
import com.orbitz.consul.model.query.PreparedQuery;
import com.orbitz.consul.model.query.ServiceQuery;
import com.orbitz.fasterxml.jackson.annotation.JsonCreator;
import com.orbitz.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.orbitz.fasterxml.jackson.annotation.JsonProperty;
import com.orbitz.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.orbitz.google.common.base.MoreObjects;
import com.orbitz.google.common.base.Optional;
import com.orbitz.google.common.base.Preconditions;
import com.orbitz.google.common.collect.Lists;
import java.util.ArrayList;

@JsonIgnoreProperties(ignoreUnknown=true)
public final class ImmutablePreparedQuery
extends PreparedQuery {
    private final String name;
    private final Optional<String> session;
    private final Optional<String> token;
    private final ServiceQuery service;
    private final Optional<DnsQuery> dns;

    private ImmutablePreparedQuery(String name, Optional<String> session, Optional<String> token, ServiceQuery service, Optional<DnsQuery> dns) {
        this.name = name;
        this.session = session;
        this.token = token;
        this.service = service;
        this.dns = dns;
    }

    @Override
    @JsonProperty(value="Name")
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="Session")
    public Optional<String> getSession() {
        return this.session;
    }

    @Override
    @JsonProperty(value="Token")
    public Optional<String> getToken() {
        return this.token;
    }

    @Override
    @JsonProperty(value="Service")
    public ServiceQuery getService() {
        return this.service;
    }

    @Override
    @JsonProperty(value="DNS")
    public Optional<DnsQuery> getDns() {
        return this.dns;
    }

    public final ImmutablePreparedQuery withName(String value) {
        if (this.name.equals(value)) {
            return this;
        }
        return new ImmutablePreparedQuery(Preconditions.checkNotNull(value, "name"), this.session, this.token, this.service, this.dns);
    }

    public final ImmutablePreparedQuery withSession(String value) {
        Optional<String> newValue = Optional.of(value);
        return new ImmutablePreparedQuery(this.name, newValue, this.token, this.service, this.dns);
    }

    public final ImmutablePreparedQuery withSession(Optional<String> optional) {
        Optional<String> value = Preconditions.checkNotNull(optional, "session");
        if (this.session == value) {
            return this;
        }
        return new ImmutablePreparedQuery(this.name, value, this.token, this.service, this.dns);
    }

    public final ImmutablePreparedQuery withToken(String value) {
        Optional<String> newValue = Optional.of(value);
        return new ImmutablePreparedQuery(this.name, this.session, newValue, this.service, this.dns);
    }

    public final ImmutablePreparedQuery withToken(Optional<String> optional) {
        Optional<String> value = Preconditions.checkNotNull(optional, "token");
        if (this.token == value) {
            return this;
        }
        return new ImmutablePreparedQuery(this.name, this.session, value, this.service, this.dns);
    }

    public final ImmutablePreparedQuery withService(ServiceQuery value) {
        if (this.service == value) {
            return this;
        }
        return new ImmutablePreparedQuery(this.name, this.session, this.token, Preconditions.checkNotNull(value, "service"), this.dns);
    }

    public final ImmutablePreparedQuery withDns(DnsQuery value) {
        Optional<DnsQuery> newValue = Optional.of(value);
        return new ImmutablePreparedQuery(this.name, this.session, this.token, this.service, newValue);
    }

    public final ImmutablePreparedQuery withDns(Optional<DnsQuery> optional) {
        Optional<DnsQuery> value = Preconditions.checkNotNull(optional, "dns");
        if (this.dns == value) {
            return this;
        }
        return new ImmutablePreparedQuery(this.name, this.session, this.token, this.service, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePreparedQuery && this.equalTo((ImmutablePreparedQuery)another);
    }

    private boolean equalTo(ImmutablePreparedQuery another) {
        return this.name.equals(another.name) && this.session.equals(another.session) && this.token.equals(another.token) && this.service.equals(another.service) && this.dns.equals(another.dns);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.name.hashCode();
        h = h * 17 + this.session.hashCode();
        h = h * 17 + this.token.hashCode();
        h = h * 17 + this.service.hashCode();
        h = h * 17 + this.dns.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("PreparedQuery").add("name", this.name).add("session", this.session).add("token", this.token).add("service", this.service).add("dns", this.dns).toString();
    }

    @Deprecated
    @JsonCreator
    static ImmutablePreparedQuery fromJson(Json json) {
        Builder builder = ImmutablePreparedQuery.builder();
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.session != null) {
            builder.session(json.session);
        }
        if (json.token != null) {
            builder.token(json.token);
        }
        if (json.service != null) {
            builder.service(json.service);
        }
        if (json.dns != null) {
            builder.dns(json.dns);
        }
        return builder.build();
    }

    public static ImmutablePreparedQuery copyOf(PreparedQuery instance) {
        if (instance instanceof ImmutablePreparedQuery) {
            return (ImmutablePreparedQuery)instance;
        }
        return ImmutablePreparedQuery.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_SERVICE = 2L;
        private long initBits = 3L;
        private String name;
        private Optional<String> session = Optional.absent();
        private Optional<String> token = Optional.absent();
        private ServiceQuery service;
        private Optional<DnsQuery> dns = Optional.absent();

        private Builder() {
        }

        public final Builder from(PreparedQuery instance) {
            Optional<String> tokenOptional;
            Preconditions.checkNotNull(instance, "instance");
            this.name(instance.getName());
            Optional<String> sessionOptional = instance.getSession();
            if (sessionOptional.isPresent()) {
                this.session(sessionOptional);
            }
            if ((tokenOptional = instance.getToken()).isPresent()) {
                this.token(tokenOptional);
            }
            this.service(instance.getService());
            Optional<DnsQuery> dnsOptional = instance.getDns();
            if (dnsOptional.isPresent()) {
                this.dns(dnsOptional);
            }
            return this;
        }

        public final Builder name(String name) {
            this.name = Preconditions.checkNotNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder session(String session) {
            this.session = Optional.of(session);
            return this;
        }

        public final Builder session(Optional<String> session) {
            this.session = Preconditions.checkNotNull(session, "session");
            return this;
        }

        public final Builder token(String token) {
            this.token = Optional.of(token);
            return this;
        }

        public final Builder token(Optional<String> token) {
            this.token = Preconditions.checkNotNull(token, "token");
            return this;
        }

        public final Builder service(ServiceQuery service) {
            this.service = Preconditions.checkNotNull(service, "service");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder dns(DnsQuery dns) {
            this.dns = Optional.of(dns);
            return this;
        }

        public final Builder dns(Optional<DnsQuery> dns) {
            this.dns = Preconditions.checkNotNull(dns, "dns");
            return this;
        }

        public ImmutablePreparedQuery build() throws IllegalStateException {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePreparedQuery(this.name, this.session, this.token, this.service, this.dns);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("service");
            }
            return "Cannot build PreparedQuery, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    static final class Json
    extends PreparedQuery {
        String name;
        Optional<String> session = Optional.absent();
        Optional<String> token = Optional.absent();
        ServiceQuery service;
        Optional<DnsQuery> dns = Optional.absent();

        Json() {
        }

        @JsonProperty(value="Name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="Session")
        public void setSession(Optional<String> session) {
            this.session = session;
        }

        @JsonProperty(value="Token")
        public void setToken(Optional<String> token) {
            this.token = token;
        }

        @JsonProperty(value="Service")
        public void setService(ServiceQuery service) {
            this.service = service;
        }

        @JsonProperty(value="DNS")
        public void setDns(Optional<DnsQuery> dns) {
            this.dns = dns;
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getSession() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getToken() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ServiceQuery getService() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<DnsQuery> getDns() {
            throw new UnsupportedOperationException();
        }
    }
}

