/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.model.query;

import com.orbitz.consul.model.query.DnsQuery;
import com.orbitz.fasterxml.jackson.annotation.JsonCreator;
import com.orbitz.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.orbitz.fasterxml.jackson.annotation.JsonProperty;
import com.orbitz.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.orbitz.google.common.base.MoreObjects;
import com.orbitz.google.common.base.Preconditions;
import com.orbitz.google.common.collect.Lists;
import java.util.ArrayList;

@JsonIgnoreProperties(ignoreUnknown=true)
public final class ImmutableDnsQuery
extends DnsQuery {
    private final String ttl;

    private ImmutableDnsQuery(String ttl) {
        this.ttl = ttl;
    }

    @Override
    @JsonProperty(value="TTL")
    public String getTtl() {
        return this.ttl;
    }

    public final ImmutableDnsQuery withTtl(String value) {
        if (this.ttl.equals(value)) {
            return this;
        }
        return new ImmutableDnsQuery(Preconditions.checkNotNull(value, "ttl"));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDnsQuery && this.equalTo((ImmutableDnsQuery)another);
    }

    private boolean equalTo(ImmutableDnsQuery another) {
        return this.ttl.equals(another.ttl);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.ttl.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("DnsQuery").add("ttl", this.ttl).toString();
    }

    @Deprecated
    @JsonCreator
    static ImmutableDnsQuery fromJson(Json json) {
        Builder builder = ImmutableDnsQuery.builder();
        if (json.ttl != null) {
            builder.ttl(json.ttl);
        }
        return builder.build();
    }

    public static ImmutableDnsQuery copyOf(DnsQuery instance) {
        if (instance instanceof ImmutableDnsQuery) {
            return (ImmutableDnsQuery)instance;
        }
        return ImmutableDnsQuery.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_TTL = 1L;
        private long initBits = 1L;
        private String ttl;

        private Builder() {
        }

        public final Builder from(DnsQuery instance) {
            Preconditions.checkNotNull(instance, "instance");
            this.ttl(instance.getTtl());
            return this;
        }

        public final Builder ttl(String ttl) {
            this.ttl = Preconditions.checkNotNull(ttl, "ttl");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableDnsQuery build() throws IllegalStateException {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableDnsQuery(this.ttl);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("ttl");
            }
            return "Cannot build DnsQuery, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    static final class Json
    extends DnsQuery {
        String ttl;

        Json() {
        }

        @JsonProperty(value="TTL")
        public void setTtl(String ttl) {
            this.ttl = ttl;
        }

        @Override
        public String getTtl() {
            throw new UnsupportedOperationException();
        }
    }
}

