/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.model;

import com.orbitz.consul.model.EventResponse;
import com.orbitz.consul.model.event.Event;
import com.orbitz.fasterxml.jackson.annotation.JsonCreator;
import com.orbitz.fasterxml.jackson.annotation.JsonProperty;
import com.orbitz.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.orbitz.google.common.base.MoreObjects;
import com.orbitz.google.common.base.Preconditions;
import com.orbitz.google.common.collect.ImmutableList;
import com.orbitz.google.common.collect.Lists;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public final class ImmutableEventResponse
extends EventResponse {
    private final ImmutableList<Event> events;
    private final BigInteger index;

    private ImmutableEventResponse(Iterable<? extends Event> events, BigInteger index) {
        this.events = ImmutableList.copyOf(events);
        this.index = Preconditions.checkNotNull(index, "index");
    }

    private ImmutableEventResponse(ImmutableEventResponse original, ImmutableList<Event> events, BigInteger index) {
        this.events = events;
        this.index = index;
    }

    @JsonProperty
    public ImmutableList<Event> getEvents() {
        return this.events;
    }

    @Override
    @JsonProperty
    public BigInteger getIndex() {
        return this.index;
    }

    public final ImmutableEventResponse withEvents(Event ... elements) {
        ImmutableList<Event> newValue = ImmutableList.copyOf(elements);
        return new ImmutableEventResponse(this, newValue, this.index);
    }

    public final ImmutableEventResponse withEvents(Iterable<? extends Event> elements) {
        if (this.events == elements) {
            return this;
        }
        ImmutableList<Event> newValue = ImmutableList.copyOf(elements);
        return new ImmutableEventResponse(this, newValue, this.index);
    }

    public final ImmutableEventResponse withIndex(BigInteger value) {
        if (this.index == value) {
            return this;
        }
        return new ImmutableEventResponse(this, this.events, Preconditions.checkNotNull(value, "index"));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableEventResponse && this.equalTo((ImmutableEventResponse)another);
    }

    private boolean equalTo(ImmutableEventResponse another) {
        return this.events.equals(another.events) && this.index.equals(another.index);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.events.hashCode();
        h = h * 17 + this.index.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("EventResponse").add("events", this.events).add("index", this.index).toString();
    }

    @Deprecated
    @JsonCreator
    static ImmutableEventResponse fromJson(Json json) {
        Builder builder = ImmutableEventResponse.builder();
        if (json.events != null) {
            builder.addAllEvents(json.events);
        }
        if (json.index != null) {
            builder.index(json.index);
        }
        return builder.build();
    }

    public static ImmutableEventResponse of(List<Event> events, BigInteger index) {
        return ImmutableEventResponse.of(events, index);
    }

    public static ImmutableEventResponse of(Iterable<? extends Event> events, BigInteger index) {
        return new ImmutableEventResponse(events, index);
    }

    public static ImmutableEventResponse copyOf(EventResponse instance) {
        if (instance instanceof ImmutableEventResponse) {
            return (ImmutableEventResponse)instance;
        }
        return ImmutableEventResponse.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_INDEX = 1L;
        private long initBits = 1L;
        private ImmutableList.Builder<Event> eventsBuilder = ImmutableList.builder();
        private BigInteger index;

        private Builder() {
        }

        public final Builder from(EventResponse instance) {
            Preconditions.checkNotNull(instance, "instance");
            this.addAllEvents(instance.getEvents());
            this.index(instance.getIndex());
            return this;
        }

        public final Builder addEvents(Event element) {
            this.eventsBuilder.add((Object)element);
            return this;
        }

        public final Builder addEvents(Event ... elements) {
            this.eventsBuilder.add(elements);
            return this;
        }

        public final Builder events(Iterable<? extends Event> elements) {
            this.eventsBuilder = ImmutableList.builder();
            return this.addAllEvents(elements);
        }

        public final Builder addAllEvents(Iterable<? extends Event> elements) {
            this.eventsBuilder.addAll(elements);
            return this;
        }

        public final Builder index(BigInteger index) {
            this.index = Preconditions.checkNotNull(index, "index");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableEventResponse build() throws IllegalStateException {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableEventResponse(null, (ImmutableList)this.eventsBuilder.build(), this.index);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("index");
            }
            return "Cannot build EventResponse, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    static final class Json
    extends EventResponse {
        List<Event> events = ImmutableList.of();
        BigInteger index;

        Json() {
        }

        @JsonProperty
        public void setEvents(List<Event> events) {
            this.events = events;
        }

        @JsonProperty
        public void setIndex(BigInteger index) {
            this.index = index;
        }

        @Override
        public List<Event> getEvents() {
            throw new UnsupportedOperationException();
        }

        @Override
        public BigInteger getIndex() {
            throw new UnsupportedOperationException();
        }
    }
}

