/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.cache;

import com.orbitz.consul.cache.ServiceHealthKey;
import com.orbitz.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.orbitz.google.common.base.MoreObjects;
import com.orbitz.google.common.base.Preconditions;
import com.orbitz.google.common.collect.Lists;
import java.util.ArrayList;

@JsonIgnoreProperties(ignoreUnknown=true)
public final class ImmutableServiceHealthKey
extends ServiceHealthKey {
    private final String serviceId;
    private final String host;
    private final Integer port;

    private ImmutableServiceHealthKey(String serviceId, String host, Integer port) {
        this.serviceId = serviceId;
        this.host = host;
        this.port = port;
    }

    @Override
    public String getServiceId() {
        return this.serviceId;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public Integer getPort() {
        return this.port;
    }

    public final ImmutableServiceHealthKey withServiceId(String value) {
        if (this.serviceId.equals(value)) {
            return this;
        }
        return new ImmutableServiceHealthKey(Preconditions.checkNotNull(value, "serviceId"), this.host, this.port);
    }

    public final ImmutableServiceHealthKey withHost(String value) {
        if (this.host.equals(value)) {
            return this;
        }
        return new ImmutableServiceHealthKey(this.serviceId, Preconditions.checkNotNull(value, "host"), this.port);
    }

    public final ImmutableServiceHealthKey withPort(Integer value) {
        if (this.port.equals(value)) {
            return this;
        }
        return new ImmutableServiceHealthKey(this.serviceId, this.host, Preconditions.checkNotNull(value, "port"));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableServiceHealthKey && this.equalTo((ImmutableServiceHealthKey)another);
    }

    private boolean equalTo(ImmutableServiceHealthKey another) {
        return this.serviceId.equals(another.serviceId) && this.host.equals(another.host) && this.port.equals(another.port);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.serviceId.hashCode();
        h = h * 17 + this.host.hashCode();
        h = h * 17 + this.port.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("ServiceHealthKey").add("serviceId", this.serviceId).add("host", this.host).add("port", this.port).toString();
    }

    public static ImmutableServiceHealthKey copyOf(ServiceHealthKey instance) {
        if (instance instanceof ImmutableServiceHealthKey) {
            return (ImmutableServiceHealthKey)instance;
        }
        return ImmutableServiceHealthKey.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_SERVICE_ID = 1L;
        private static final long INIT_BIT_HOST = 2L;
        private static final long INIT_BIT_PORT = 4L;
        private long initBits = 7L;
        private String serviceId;
        private String host;
        private Integer port;

        private Builder() {
        }

        public final Builder from(ServiceHealthKey instance) {
            Preconditions.checkNotNull(instance, "instance");
            this.serviceId(instance.getServiceId());
            this.host(instance.getHost());
            this.port(instance.getPort());
            return this;
        }

        public final Builder serviceId(String serviceId) {
            this.serviceId = Preconditions.checkNotNull(serviceId, "serviceId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder host(String host) {
            this.host = Preconditions.checkNotNull(host, "host");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder port(Integer port) {
            this.port = Preconditions.checkNotNull(port, "port");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableServiceHealthKey build() throws IllegalStateException {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableServiceHealthKey(this.serviceId, this.host, this.port);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("serviceId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("host");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("port");
            }
            return "Cannot build ServiceHealthKey, some of required attributes are not set " + attributes;
        }
    }
}

