/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul;

import com.orbitz.consul.model.query.PreparedQuery;
import com.orbitz.consul.model.query.QueryId;
import com.orbitz.consul.model.query.QueryResults;
import com.orbitz.consul.model.query.StoredQuery;
import com.orbitz.consul.util.Http;
import com.orbitz.google.common.base.Optional;
import com.orbitz.retrofit.Call;
import com.orbitz.retrofit.Retrofit;
import com.orbitz.retrofit.http.Body;
import com.orbitz.retrofit.http.GET;
import com.orbitz.retrofit.http.POST;
import com.orbitz.retrofit.http.Path;
import java.util.List;

public class PreparedQueryClient {
    private final Api api;

    PreparedQueryClient(Retrofit retrofit) {
        this.api = retrofit.create(Api.class);
    }

    public String createPreparedQuery(PreparedQuery preparedQuery) {
        return Http.extract(this.api.createPreparedQuery(preparedQuery)).getId();
    }

    public Optional<StoredQuery> getPreparedQuery(String id) {
        List<StoredQuery> result = Http.extract(this.api.getPreparedQuery(id));
        return result.isEmpty() ? Optional.absent() : Optional.of(result.get(0));
    }

    public QueryResults execute(String nameOrId) {
        return Http.extract(this.api.execute(nameOrId));
    }

    static interface Api {
        @POST(value="query")
        public Call<QueryId> createPreparedQuery(@Body PreparedQuery var1);

        @GET(value="query/{id}")
        public Call<List<StoredQuery>> getPreparedQuery(@Path(value="id") String var1);

        @GET(value="query/{nameOrId}/execute")
        public Call<QueryResults> execute(@Path(value="nameOrId") String var1);
    }
}

